/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.utils;

import com.brandon3055.brandonscore.BrandonsCore;
import com.brandon3055.brandonscore.utils.BCLogHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityEffect;
import net.minecraft.network.play.server.SPacketRespawn;
import net.minecraft.network.play.server.SPacketSetExperience;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class Teleporter {
    private static Entity teleportEntity(Entity entity, TeleportLocation destination) {
        EntityPlayerMP player;
        if (entity == null || entity.field_70170_p.field_72995_K || entity.func_184207_aI()) {
            return entity;
        }
        World startWorld = entity.field_70170_p;
        WorldServer destinationWorld = BrandonsCore.proxy.getMCServer().func_71218_a(destination.dimension);
        if (destinationWorld == null) {
            BCLogHelper.error("Destination world dose not exist!");
            return entity;
        }
        Entity mount = entity.func_184187_bx();
        if (mount != null && mount != entity) {
            entity.func_184210_p();
            mount = Teleporter.teleportEntity(mount, destination);
        }
        boolean interDimensional = startWorld.field_73011_w.getDimension() != destinationWorld.field_73011_w.getDimension();
        startWorld.func_72866_a(entity, false);
        if (entity instanceof EntityPlayerMP && interDimensional) {
            player = (EntityPlayerMP)entity;
            player.func_71053_j();
            player.field_71093_bK = destination.dimension;
            player.field_71135_a.func_147359_a((Packet)new SPacketRespawn(player.field_71093_bK, player.field_70170_p.func_175659_aa(), destinationWorld.func_72912_H().func_76067_t(), player.field_71134_c.func_73081_b()));
            ((WorldServer)startWorld).field_73063_M.func_72695_c(player);
            startWorld.field_73010_i.remove(player);
            startWorld.func_72854_c();
            int i = entity.field_70176_ah;
            int j = entity.field_70164_aj;
            if (entity.field_70175_ag && startWorld.func_175726_f(new BlockPos(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v)).func_150802_k()) {
                startWorld.func_72964_e(i, j).func_76622_b(entity);
                startWorld.func_72964_e(i, j).func_177427_f(true);
            }
            startWorld.field_72996_f.remove(entity);
            startWorld.func_72847_b(entity);
        }
        entity.func_70012_b(destination.xCoord, destination.yCoord, destination.zCoord, destination.yaw, destination.pitch);
        destinationWorld.func_72863_F().func_186028_c((int)destination.xCoord >> 4, (int)destination.zCoord >> 4);
        destinationWorld.field_72984_F.func_76320_a("placing");
        if (interDimensional) {
            if (!(entity instanceof EntityPlayer)) {
                NBTTagCompound entityNBT = new NBTTagCompound();
                entity.field_70128_L = false;
                entityNBT.func_74778_a("id", EntityList.func_75621_b((Entity)entity));
                entity.func_189511_e(entityNBT);
                entity.field_70128_L = true;
                entity = EntityList.func_75615_a((NBTTagCompound)entityNBT, (World)destinationWorld);
                if (entity == null) {
                    BCLogHelper.error("Failed to teleport entity to new location");
                    return null;
                }
                entity.field_71093_bK = destinationWorld.field_73011_w.getDimension();
            }
            destinationWorld.func_72838_d(entity);
            entity.func_70029_a((World)destinationWorld);
        }
        entity.func_70012_b(destination.xCoord, destination.yCoord, destination.zCoord, destination.yaw, entity.field_70125_A);
        destinationWorld.func_72866_a(entity, false);
        entity.func_70012_b(destination.xCoord, destination.yCoord, destination.zCoord, destination.yaw, entity.field_70125_A);
        if (entity instanceof EntityPlayerMP) {
            player = (EntityPlayerMP)entity;
            if (interDimensional) {
                player.field_71133_b.func_184103_al().func_72375_a(player, destinationWorld);
            }
            player.field_71135_a.func_147364_a(destination.xCoord, destination.yCoord, destination.zCoord, player.field_70177_z, player.field_70125_A);
        }
        destinationWorld.func_72866_a(entity, false);
        if (entity instanceof EntityPlayerMP && interDimensional) {
            player = (EntityPlayerMP)entity;
            player.field_71134_c.func_73080_a(destinationWorld);
            player.field_71133_b.func_184103_al().func_72354_b(player, destinationWorld);
            player.field_71133_b.func_184103_al().func_72385_f(player);
            for (PotionEffect potionEffect : player.func_70651_bq()) {
                player.field_71135_a.func_147359_a((Packet)new SPacketEntityEffect(player.func_145782_y(), potionEffect));
            }
            player.field_71135_a.func_147359_a((Packet)new SPacketSetExperience(player.field_71106_cc, player.field_71067_cb, player.field_71068_ca));
            FMLCommonHandler.instance().firePlayerChangedDimensionEvent((EntityPlayer)player, startWorld.field_73011_w.getDimension(), destinationWorld.field_73011_w.getDimension());
        }
        entity.func_70012_b(destination.xCoord, destination.yCoord, destination.zCoord, destination.yaw, entity.field_70125_A);
        if (mount != null) {
            entity.func_184220_m(mount);
            if (entity instanceof EntityPlayerMP) {
                destinationWorld.func_72866_a(entity, true);
            }
        }
        destinationWorld.field_72984_F.func_76319_b();
        entity.field_70143_R = 0.0f;
        return entity;
    }

    public static class TeleportLocation {
        protected double xCoord;
        protected double yCoord;
        protected double zCoord;
        protected int dimension;
        protected float pitch;
        protected float yaw;
        protected String name;
        protected String dimensionName = "";
        protected boolean writeProtected = false;

        public TeleportLocation() {
        }

        public TeleportLocation(double x, double y, double z, int dimension) {
            this.xCoord = x;
            this.yCoord = y;
            this.zCoord = z;
            this.dimension = dimension;
            this.pitch = 0.0f;
            this.yaw = 0.0f;
        }

        public TeleportLocation(double x, double y, double z, int dimension, float pitch, float yaw) {
            this.xCoord = x;
            this.yCoord = y;
            this.zCoord = z;
            this.dimension = dimension;
            this.pitch = pitch;
            this.yaw = yaw;
        }

        public TeleportLocation(double x, double y, double z, int dimension, float pitch, float yaw, String name) {
            this.xCoord = x;
            this.yCoord = y;
            this.zCoord = z;
            this.dimension = dimension;
            this.pitch = pitch;
            this.yaw = yaw;
            this.name = name;
        }

        public double getXCoord() {
            return this.xCoord;
        }

        public double getYCoord() {
            return this.yCoord;
        }

        public double getZCoord() {
            return this.zCoord;
        }

        public int getDimension() {
            return this.dimension;
        }

        public String getDimensionName() {
            return this.dimensionName;
        }

        public float getPitch() {
            return this.pitch;
        }

        public float getYaw() {
            return this.yaw;
        }

        public String getName() {
            return this.name;
        }

        public boolean getWriteProtected() {
            return this.writeProtected;
        }

        public void setXCoord(double x) {
            this.xCoord = x;
        }

        public void setYCoord(double y) {
            this.yCoord = y;
        }

        public void setZCoord(double z) {
            this.zCoord = z;
        }

        public void setDimension(int d) {
            this.dimension = d;
        }

        public void setPitch(float p) {
            this.pitch = p;
        }

        public void setYaw(float y) {
            this.yaw = y;
        }

        public void setName(String s) {
            this.name = s;
        }

        public void setWriteProtected(boolean b) {
            this.writeProtected = b;
        }

        public void writeToNBT(NBTTagCompound compound) {
            compound.func_74780_a("X", this.xCoord);
            compound.func_74780_a("Y", this.yCoord);
            compound.func_74780_a("Z", this.zCoord);
            compound.func_74768_a("Dimension", this.dimension);
            compound.func_74776_a("Pitch", this.pitch);
            compound.func_74776_a("Yaw", this.yaw);
            compound.func_74778_a("Name", this.name);
            compound.func_74778_a("DimentionName", this.dimensionName);
            compound.func_74757_a("WP", this.writeProtected);
        }

        public void readFromNBT(NBTTagCompound compound) {
            this.xCoord = compound.func_74769_h("X");
            this.yCoord = compound.func_74769_h("Y");
            this.zCoord = compound.func_74769_h("Z");
            this.dimension = compound.func_74762_e("Dimension");
            this.pitch = compound.func_74760_g("Pitch");
            this.yaw = compound.func_74760_g("Yaw");
            this.name = compound.func_74779_i("Name");
            this.dimensionName = compound.func_74779_i("DimentionName");
            this.writeProtected = compound.func_74767_n("WP");
        }

        public void teleport(Entity entity) {
            Teleporter.teleportEntity(entity, this);
        }

        public void setDimensionName(String dimensionName) {
            this.dimensionName = dimensionName;
        }

        public int hashCode() {
            return (this.xCoord + "-" + this.yCoord + "-" + this.zCoord + "-" + this.name + "-" + this.dimensionName + "-" + this.dimension + "-" + this.yaw + "-" + this.pitch).hashCode();
        }
    }
}

