/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.api.machine;

import com.google.common.collect.ImmutableList;
import com.rwtema.extrautils2.api.machine.MachineRecipeRegistry;
import com.rwtema.extrautils2.api.machine.MachineSlotFluid;
import com.rwtema.extrautils2.api.machine.MachineSlotItem;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.ModContainer;
import org.apache.commons.lang3.Validate;

public class Machine {
    public final String name;
    public final int energyBufferSize;
    public final ImmutableList<MachineSlotItem> itemInputs;
    public final ImmutableList<MachineSlotItem> itemOutputs;
    public final ImmutableList<MachineSlotFluid> fluidInputs;
    public final ImmutableList<MachineSlotFluid> fluidOutputs;
    public final String frontTexture;
    public final String frontTextureActive;
    public final MachineRecipeRegistry recipes_registry = new MachineRecipeRegistry();
    @Nonnull
    public final EnergyMode energyMode;
    public final int color;
    ModContainer container = null;

    public Machine(@Nonnull String name, int energyBufferSize, @Nonnull List<MachineSlotItem> itemInputs, @Nonnull List<MachineSlotFluid> fluidInputs, @Nonnull List<MachineSlotItem> itemOutputs, @Nonnull List<MachineSlotFluid> fluidOutputs, @Nonnull String frontTexture, @Nonnull String frontTextureActive, @Nonnull EnergyMode energyMode, int color) {
        this.color = color;
        ResourceLocation location = new ResourceLocation(name);
        Validate.isTrue((!"minecraft".equals(location.func_110624_b()) ? 1 : 0) != 0, (String)"Name %s must be in resource location format and not be in the minecraft domain.", (Object[])new Object[]{name});
        this.name = location.toString();
        this.energyBufferSize = energyBufferSize;
        this.itemInputs = ImmutableList.copyOf(itemInputs);
        this.itemOutputs = ImmutableList.copyOf(itemOutputs);
        this.fluidInputs = ImmutableList.copyOf(fluidInputs);
        this.fluidOutputs = ImmutableList.copyOf(fluidOutputs);
        this.frontTexture = frontTexture;
        this.frontTextureActive = frontTextureActive;
        this.energyMode = energyMode;
    }

    public static enum EnergyMode {
        USES_ENERGY,
        GENERATES_ENERGY;

    }
}

