/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.api.machine;

import com.google.common.collect.ImmutableSet;
import com.rwtema.extrautils2.api.machine.Machine;
import com.rwtema.extrautils2.api.machine.XUMachineCrusher;
import com.rwtema.extrautils2.api.machine.XUMachineFurnace;
import com.rwtema.extrautils2.api.machine.XUMachineGenerator;
import java.util.LinkedHashMap;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.fml.common.Loader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MachineRegistry {
    private static final LinkedHashMap<String, Machine> machines;
    private static Logger logger;

    public static Machine register(@Nonnull Machine machine) {
        machine.container = Loader.instance().activeModContainer();
        logger.trace("Registering " + machine.name + " from " + machine.container);
        MachineRegistry.registerMachineDo(machine);
        return machine;
    }

    private static void registerMachineDo(@Nonnull Machine machine) {
        if (machines.containsKey(machine.name)) {
            throw new RuntimeException(machine.name + " already registered.");
        }
        machines.put(machine.name, machine);
    }

    public static boolean deregister(Machine machine) {
        logger.trace(machine.name + " was deregistered by " + machine.container);
        return machines.remove(machine.name) == machine;
    }

    private static Machine registerInternal(@Nonnull Machine machine) {
        logger.trace("Registering internal machine " + machine.name);
        MachineRegistry.registerMachineDo(machine);
        return machine;
    }

    @Nullable
    public static Machine getMachine(String machine) {
        return machines.get(machine);
    }

    public static Set<Machine> getMachineValues() {
        return ImmutableSet.copyOf(machines.values());
    }

    static {
        logger = LogManager.getLogger((String)"ExtraMachinaAPI");
        machines = new LinkedHashMap();
        MachineRegistry.registerInternal(XUMachineFurnace.INSTANCE);
        MachineRegistry.registerInternal(XUMachineCrusher.INSTANCE);
        MachineRegistry.registerInternal(XUMachineGenerator.INSTANCE);
    }
}

