/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.backend;

import com.rwtema.extrautils2.backend.XUBlock;
import com.rwtema.extrautils2.backend.model.BoxModel;
import com.rwtema.extrautils2.backend.model.MutableModel;
import com.rwtema.extrautils2.backend.model.Transforms;
import com.rwtema.extrautils2.network.PacketBuffer;
import com.rwtema.extrautils2.tile.XUTile;
import com.rwtema.extrautils2.tile.tesr.ITESRHook;
import com.rwtema.extrautils2.utils.MCTimer;
import com.rwtema.extrautils2.utils.datastructures.NBTSerializable;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class XUBlockTESR
extends XUBlock {
    public XUBlockTESR() {
    }

    public XUBlockTESR(Material materialIn) {
    }

    public abstract BoxModel getModel(@Nullable ItemStack var1, float var2);

    @Override
    @Nonnull
    public BoxModel getWorldModel(IBlockAccess world, BlockPos pos, @Nullable IBlockState state) {
        if (world == null) {
            return this.getModel(null, 0.0f);
        }
        XUTESRTile tile = (XUTESRTile)world.func_175625_s(pos);
        if (tile == null) {
            return this.getModel(null, 0.0f);
        }
        return this.getModel(tile.NBTStack.getRaw(), 0.0f);
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nonnull
    public XUTESRTile createTileEntity(@Nonnull World world, @Nonnull IBlockState state) {
        return new XUTESRTile();
    }

    @Override
    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public BoxModel getInventoryModel(@Nullable ItemStack item) {
        return this.getModel(item, MCTimer.renderTimer);
    }

    public class XUTESRTile
    extends XUTile
    implements ITESRHook {
        public NBTSerializable.NBTStack NBTStack = this.registerNBT("stack", new NBTSerializable.NBTStack());

        @Override
        public void handleDescriptionPacket(PacketBuffer packet) {
            this.NBTStack.setStackRaw(packet.readItemStack());
        }

        @Override
        public void addToDescriptionPacket(PacketBuffer packet) {
            packet.writeItemStack(this.NBTStack.getRaw());
        }

        @Override
        public void render(IBlockAccess world, BlockPos pos, double x, double y, double z, float partialTicks, int destroyStage, VertexBuffer renderer, BlockRendererDispatcher blockRenderer) {
            MutableModel model = new MutableModel(Transforms.blockTransforms);
            BoxModel boxes = XUBlockTESR.this.getModel(this.NBTStack.getRaw(), MCTimer.renderTimer);
            boxes.loadIntoMutable(model, null);
            this.renderBakedModel(world, renderer, blockRenderer, (IBakedModel)model);
        }

        @Override
        public void onBlockPlacedBy(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack, XUBlock xuBlock) {
            this.NBTStack.setStackCopy(stack);
        }

        @Override
        public Optional<ItemStack> getPickBlock(EntityPlayer player, RayTraceResult target) {
            return Optional.ofNullable(this.NBTStack.getCopy());
        }

        @Override
        public boolean harvestBlock(World worldIn, EntityPlayer player, BlockPos pos, XUBlock xuBlock, IBlockState state) {
            ItemStack copy = this.NBTStack.getCopy();
            if (copy != null) {
                Block.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)copy);
            }
            return true;
        }
    }
}

