/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.backend.entries;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import com.rwtema.extrautils2.backend.entries.EntryHandler;
import com.rwtema.extrautils2.backend.entries.IItemStackMaker;
import com.rwtema.extrautils2.crafting.CraftingHelper;
import com.rwtema.extrautils2.crafting.XUShapedRecipe;
import com.rwtema.extrautils2.crafting.XUShapelessRecipe;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.common.config.Configuration;

public abstract class Entry<T>
implements IItemStackMaker {
    public final String name;
    public final LoadingCache<Integer, IItemStackMaker> metaCache = CacheBuilder.newBuilder().initialCapacity(1).build((CacheLoader)new CacheLoader<Integer, IItemStackMaker>(){

        public IItemStackMaker load(final @Nonnull Integer key) throws Exception {
            if (key == 0) {
                return Entry.this;
            }
            return new IItemStackMaker(){

                @Override
                public ItemStack newStack() {
                    return Entry.this.newStack(1, key);
                }
            };
        }
    });
    public T value;
    public boolean enabled;
    public List<IRecipe> recipes = new ArrayList<IRecipe>();

    public Entry(String name) {
        this.name = name;
        EntryHandler.entries.add(this);
    }

    public String getDisplayName(int meta) {
        ItemStack itemStack = this.newStack(1, meta);
        String title = itemStack != null ? itemStack.func_82833_r() : this.name;
        return title;
    }

    public IItemStackMaker getMetaMaker(int meta) {
        return (IItemStackMaker)this.metaCache.getUnchecked((Object)meta);
    }

    public IItemStackMaker getOreDicMaker() {
        return (IItemStackMaker)this.metaCache.getUnchecked((Object)Short.MAX_VALUE);
    }

    protected abstract T initValue();

    public void loadAdditionalConfig(Configuration config) {
    }

    public void preInitLoad() {
        this.value = this.initValue();
    }

    public void preInitRegister() {
    }

    public void addRecipes() {
    }

    public boolean isActive() {
        return this.enabled;
    }

    public void registerOres() {
    }

    public void addShapeless(ItemStack stack, Object ... recipe) {
        CraftingHelper.addRecipe((IRecipe)new XUShapelessRecipe(stack, recipe));
    }

    public void addShaped(ItemStack stack, Object ... recipe) {
        CraftingHelper.addRecipe((IRecipe)new XUShapedRecipe(stack, recipe));
    }

    public void addShapeless(Item stack, Object ... recipe) {
        CraftingHelper.addRecipe((IRecipe)new XUShapelessRecipe(stack, recipe));
    }

    public void addShaped(Item stack, Object ... recipe) {
        CraftingHelper.addRecipe((IRecipe)new XUShapedRecipe(stack, recipe));
    }

    public void addShapeless(Block stack, Object ... recipe) {
        CraftingHelper.addRecipe((IRecipe)new XUShapelessRecipe(stack, recipe));
    }

    public void addShaped(Block stack, Object ... recipe) {
        CraftingHelper.addRecipe((IRecipe)new XUShapedRecipe(stack, recipe));
    }

    public void postInit() {
    }

    @Override
    public final ItemStack newStack() {
        return this.newStack(1);
    }

    public final ItemStack newStackMeta(int meta) {
        return this.newStack(1, meta);
    }

    public final ItemStack newStack(int amount) {
        return this.newStack(amount, 0);
    }

    public ItemStack newStack(int amount, int meta) {
        return null;
    }

    public String getConfigLabel() {
        return this.name;
    }

    public void addAchievements() {
    }

    public Set<Entry<?>> getDependencies() {
        return ImmutableSet.of();
    }

    public void init() {
    }
}

