/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.backend.entries;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.rwtema.extrautils2.achievements.AchievementHelper;
import com.rwtema.extrautils2.backend.entries.Entry;
import com.rwtema.extrautils2.crafting.CraftingHelper;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import net.minecraftforge.common.config.Configuration;

public class EntryHandler {
    public static List<Entry> entries = Lists.newArrayList();
    public static List<Entry> activeEntries = Lists.newArrayList();
    public static HashMap<String, Entry> entryHashMap = new HashMap();

    public static void loadConfig(Configuration config) {
        HashMap configEntries = Maps.newHashMap();
        for (Entry entry2 : entries) {
            entryHashMap.put(entry2.name.toLowerCase(), entry2);
            configEntries.put(entry2.name, config.get("Enabled", entry2.getConfigLabel(), true).getBoolean());
            entry2.loadAdditionalConfig(config);
        }
        for (Entry entry2 : entries) {
            entry2.enabled = (Boolean)configEntries.get(entry2.name);
            if (entry2.enabled) {
                Set<Entry<?>> dependencies = entry2.getDependencies();
                for (Entry<?> dependency : dependencies) {
                    if (((Boolean)configEntries.get(dependency.name)).booleanValue()) continue;
                    entry2.enabled = false;
                    break;
                }
            }
            if (!entry2.enabled) continue;
            activeEntries.add(entry2);
        }
    }

    public static void preInit() {
        for (Entry activeEntry : activeEntries) {
            activeEntry.preInitLoad();
        }
        for (Entry activeEntry : activeEntries) {
            activeEntry.preInitRegister();
        }
        for (Entry entry2 : entries) {
            entry2.addAchievements();
        }
        for (Entry activeEntry : activeEntries) {
            activeEntry.registerOres();
        }
        for (Entry entry2 : activeEntries) {
            CraftingHelper.recipeCallback.set(entry2.recipes);
            entry2.addRecipes();
            CraftingHelper.recipeCallback.set(null);
        }
        AchievementHelper.bake();
    }

    public static void init() {
        for (Entry entry2 : activeEntries) {
            entry2.init();
        }
    }

    public static void postInit() {
        for (Entry entry2 : activeEntries) {
            entry2.postInit();
        }
    }
}

