/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.backend.model;

import com.google.common.collect.ImmutableList;
import com.rwtema.extrautils2.backend.model.Box;
import com.rwtema.extrautils2.backend.model.UV;
import com.rwtema.extrautils2.utils.helpers.QuadHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.util.EnumFacing;

public class BoxSingleQuad
extends Box {
    private final UV[] vecs;
    public boolean addShading = true;
    boolean doubleSided = true;

    public BoxSingleQuad(UV ... vecs) {
        super(BoxSingleQuad.getBB(vecs, 0), BoxSingleQuad.getBB(vecs, 1), BoxSingleQuad.getBB(vecs, 2), BoxSingleQuad.getBB(vecs, 3), BoxSingleQuad.getBB(vecs, 4), BoxSingleQuad.getBB(vecs, 5));
        this.vecs = vecs;
    }

    @Override
    public Box copy() {
        UV[] v = new UV[this.vecs.length];
        for (int i = 0; i < this.vecs.length; ++i) {
            v[i] = this.vecs[i].copy();
        }
        BoxSingleQuad box = new BoxSingleQuad(v);
        box.doubleSided = this.doubleSided;
        box.addShading = this.addShading;
        return box;
    }

    public static float getBB(UV[] vecs, int i) {
        float k = i >= 3 ? Float.MIN_VALUE : Float.MAX_VALUE;
        for (UV vec : vecs) {
            float t;
            switch (i) {
                case 0: 
                case 3: {
                    t = vec.x;
                    break;
                }
                case 1: 
                case 4: {
                    t = vec.y;
                    break;
                }
                case 2: 
                case 5: {
                    t = vec.z;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Wrong Arg: " + i);
                }
            }
            k = i >= 3 ? Math.max(k, t) : Math.min(k, t);
        }
        return k;
    }

    @Override
    public Box rotateY(int numRotations) {
        return super.rotateY(numRotations);
    }

    @Override
    public void clearCache() {
    }

    @Override
    public List<BakedQuad> makeQuads(@Nullable EnumFacing side) {
        if (side != null) {
            return ImmutableList.of();
        }
        if (this.doubleSided) {
            UV[] v2 = new UV[this.vecs.length];
            for (int i = 0; i < v2.length; ++i) {
                v2[i] = this.vecs[this.vecs.length - 1 - i];
            }
            return ImmutableList.of((Object)QuadHelper.createBakedQuad(this.vecs, this.texture, this.addShading, this.tint), (Object)QuadHelper.createBakedQuad(v2, this.texture, this.addShading, this.tint));
        }
        return ImmutableList.of((Object)QuadHelper.createBakedQuad(this.vecs, this.texture, this.addShading, this.tint));
    }

    public Box setDoubleSided(boolean doubleSided) {
        this.doubleSided = doubleSided;
        return this;
    }
}

