/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.backend.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.rwtema.extrautils2.backend.IXUItem;
import com.rwtema.extrautils2.backend.XUBlock;
import com.rwtema.extrautils2.backend.XUBlockStatic;
import com.rwtema.extrautils2.backend.XUItem;
import com.rwtema.extrautils2.backend.XUItemBlock;
import com.rwtema.extrautils2.backend.model.PassthruModelBlock;
import com.rwtema.extrautils2.backend.model.PassthruModelItemBlock;
import com.rwtema.extrautils2.textures.TextureComponent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.DefaultStateMapper;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.IRegistry;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.Validate;

@SideOnly(value=Side.CLIENT)
public class Textures {
    public static final HashMap<String, TextureAtlasSprite> textureNames = Maps.newHashMap();
    private static final HashMap<Item, ModelResourceLocation> locations = new HashMap();
    public static HashMap<String, TextureAtlasSprite> sprites;
    public static TextureAtlasSprite MISSING_SPRITE;
    public static final HashMap<TextureAtlasSprite, List<TextureComponent>> simpleCompositeTextureCache;
    public static final Function<TextureAtlasSprite, List<TextureComponent>> simpleCompostiteFunction;

    public static ModelResourceLocation getModelResourceLocation(Item item) {
        ModelResourceLocation location = locations.get(item);
        if (location != null) {
            return location;
        }
        location = new ModelResourceLocation((ResourceLocation)Validate.notNull((Object)Item.field_150901_e.func_177774_c((Object)item)), "inventory");
        locations.put(item, location);
        return location;
    }

    public static ModelResourceLocation getModelResourceLocation(Item item, int metadata) {
        if (metadata == Short.MAX_VALUE) {
            return Textures.getModelResourceLocation(item);
        }
        ModelResourceLocation location = locations.get(item);
        if (location != null) {
            return location;
        }
        location = new ModelResourceLocation(Item.field_150901_e.func_177774_c((Object)item) + "_" + metadata, "inventory");
        locations.put(item, location);
        return location;
    }

    public static void register(String ... textures) {
        for (String texture : textures) {
            if (texture == null) continue;
            textureNames.put(texture, null);
        }
    }

    public static ResourceLocation completeTextureResourceLocation(ResourceLocation location) {
        return new ResourceLocation(location.func_110624_b(), String.format("%s/%s%s", "textures", location.func_110623_a(), ".png"));
    }

    public static TextureAtlasSprite getSprite(String textureName) {
        TextureAtlasSprite sprite = sprites.get(textureName);
        return sprite != null ? sprite : MISSING_SPRITE;
    }

    @SubscribeEvent
    public void loadTextures(TextureStitchEvent.Pre event) {
        MISSING_SPRITE = event.getMap().func_174944_f();
        simpleCompositeTextureCache.clear();
        for (IXUItem item : XUItem.items) {
            item.clearCaches();
            item.registerTextures();
        }
        for (XUItemBlock itemBlock : XUItemBlock.itemBlocks) {
            itemBlock.clearCaches();
            itemBlock.registerTextures();
        }
        for (XUBlock block : XUBlock.blocks) {
            block.clearCaches();
            block.registerTextures();
        }
        sprites = new HashMap(16, 0.25f);
        TextureMap map = event.getMap();
        sprites.put("[Missing]", MISSING_SPRITE);
        for (Map.Entry<String, TextureAtlasSprite> entry2 : textureNames.entrySet()) {
            String texture = entry2.getKey();
            String name = texture.indexOf(58) == -1 ? "extrautils2:" + texture : texture;
            TextureAtlasSprite value = entry2.getValue();
            if (value != null) {
                map.setTextureEntry(value);
                sprites.put(texture, value);
                continue;
            }
            sprites.put(texture, map.func_174942_a(new ResourceLocation(name)));
        }
        for (IXUItem item : XUItem.items) {
            item.postTextureRegister();
        }
        for (XUItemBlock itemBlock : XUItemBlock.itemBlocks) {
            itemBlock.postTextureRegister();
        }
        for (XUBlock block : XUBlock.blocks) {
            block.postTextureRegister();
        }
    }

    @SubscribeEvent
    public void registerModels(ModelBakeEvent event) {
        IRegistry modelRegistry = event.getModelRegistry();
        IBakedModel missingModel = event.getModelManager().func_174951_a();
        for (IXUItem xuItems : XUItem.items) {
            Item item = (Item)xuItems;
            int maxMetadata = xuItems.getMaxMetadata();
            if (maxMetadata == 0) {
                ModelLoader.setCustomMeshDefinition((Item)item, (ItemMeshDefinition)ItemMesher.INSTANCE);
                ModelResourceLocation modelResourceLocation = Textures.getModelResourceLocation(item);
                ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)modelResourceLocation);
                if (xuItems.allowOverride() && modelRegistry.func_82594_a((Object)modelResourceLocation) != missingModel) continue;
                modelRegistry.func_82595_a((Object)modelResourceLocation, (Object)xuItems.createModel(0));
                continue;
            }
            ModelLoader.setCustomMeshDefinition((Item)item, (ItemMeshDefinition)ItemMesher.INSTANCE);
            ModelResourceLocation genericLocation = Textures.getModelResourceLocation(item);
            modelRegistry.func_82595_a((Object)genericLocation, (Object)xuItems.createModel(0));
            for (int i = 0; i < maxMetadata; ++i) {
                ModelLoader.setCustomMeshDefinition((Item)item, (ItemMeshDefinition)new ItemMesherItem(xuItems));
                ModelResourceLocation modelResourceLocation = Textures.getModelResourceLocation(item, i);
                ModelLoader.setCustomModelResourceLocation((Item)item, (int)i, (ModelResourceLocation)modelResourceLocation);
                if (xuItems.allowOverride() && modelRegistry.func_82594_a((Object)modelResourceLocation) != missingModel) continue;
                modelRegistry.func_82595_a((Object)modelResourceLocation, (Object)xuItems.createModel(i));
            }
        }
        for (XUItemBlock item : XUItemBlock.itemBlocks) {
            ModelLoader.setCustomMeshDefinition((Item)item, (ItemMeshDefinition)ItemMesher.INSTANCE);
            final ModelResourceLocation location = Textures.getModelResourceLocation((Item)item);
            ModelLoader.setCustomStateMapper((Block)item.field_150939_a, (IStateMapper)new StateMapperBase(){

                @Nonnull
                protected ModelResourceLocation func_178132_a(@Nonnull IBlockState state) {
                    return location;
                }
            });
            if (item.field_150939_a instanceof XUBlockStatic && modelRegistry.func_82594_a((Object)location) != missingModel) continue;
            modelRegistry.func_82595_a((Object)location, (Object)new PassthruModelItemBlock(item));
        }
        for (XUBlock block : XUBlock.blocks) {
            DefaultStateMapper defaultStateMapper = new DefaultStateMapper();
            for (Map.Entry entry2 : defaultStateMapper.func_178130_a((Block)block).entrySet()) {
                ModelResourceLocation location = (ModelResourceLocation)entry2.getValue();
                IBakedModel object = (IBakedModel)modelRegistry.func_82594_a((Object)location);
                if (block instanceof XUBlockStatic && object != missingModel) continue;
                PassthruModelBlock passthruModelBlock = block.createPassthruModel((IBlockState)entry2.getKey(), location);
                modelRegistry.func_82595_a((Object)location, (Object)passthruModelBlock);
            }
        }
    }

    static {
        MinecraftForge.EVENT_BUS.register((Object)new Textures());
        simpleCompositeTextureCache = new HashMap();
        simpleCompostiteFunction = textureAtlasSprite -> ImmutableList.of((Object)new TextureComponent((TextureAtlasSprite)textureAtlasSprite, 0, 0, 16, 16));
    }

    public static class ItemMesherItem
    implements ItemMeshDefinition {
        final IXUItem item;

        public ItemMesherItem(IXUItem item) {
            this.item = item;
        }

        @Nonnull
        public ModelResourceLocation func_178113_a(@Nonnull ItemStack stack) {
            int meta = stack.func_77952_i();
            if (meta < 0) {
                meta = 0;
            } else if (meta > this.item.getMaxMetadata()) {
                meta = this.item.getMaxMetadata();
            }
            return Textures.getModelResourceLocation(stack.func_77973_b(), meta);
        }
    }

    public static class ItemMesher
    implements ItemMeshDefinition {
        public static final ItemMesher INSTANCE = new ItemMesher();

        @Nonnull
        public ModelResourceLocation func_178113_a(@Nonnull ItemStack stack) {
            return Textures.getModelResourceLocation(stack.func_77973_b());
        }
    }
}

