/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.blocks;

import com.rwtema.extrautils2.backend.PropertyEnumSimple;
import com.rwtema.extrautils2.backend.XUBlock;
import com.rwtema.extrautils2.backend.XUBlockConnectedTextureBase;
import com.rwtema.extrautils2.backend.XUBlockStateCreator;
import com.rwtema.extrautils2.backend.entries.IItemStackMaker;
import com.rwtema.extrautils2.backend.entries.XU2Entries;
import com.rwtema.extrautils2.blocks.BlockDecorativeSolid;
import com.rwtema.extrautils2.crafting.CraftingHelper;
import com.rwtema.extrautils2.textures.ConnectedTexture;
import com.rwtema.extrautils2.textures.ISolidWorldTexture;
import com.rwtema.extrautils2.tile.TileResonator;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockDecorativeGlass
extends XUBlockConnectedTextureBase {
    public static final PropertyEnumSimple<DecorStates> decor = new PropertyEnumSimple<DecorStates>(DecorStates.class);

    public boolean func_149751_l(IBlockState state) {
        return ((DecorStates)((Object)state.func_177229_b(BlockDecorativeGlass.decor))).opacity == 0;
    }

    public float func_185485_f(IBlockState state) {
        return this.func_149751_l(state) ? 1.0f : 0.2f;
    }

    public BlockDecorativeGlass() {
        super(Material.field_151592_s);
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    public boolean canSilkHarvest(World world, BlockPos pos, @Nonnull IBlockState state, EntityPlayer player) {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerTextures() {
        for (DecorStates decorState : DecorStates.values()) {
            decorState.tex = new ConnectedTexture(decorState.toString(), this.xuBlockState.defaultState.func_177226_a(decor, (Comparable)((Object)decorState)), this);
        }
    }

    @Override
    @Nonnull
    protected XUBlockStateCreator createBlockState() {
        return new XUBlockStateCreator((XUBlock)this, false, new IProperty[]{decor});
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public boolean canRenderInLayer(BlockRenderLayer layer) {
        return layer == BlockRenderLayer.CUTOUT || layer == BlockRenderLayer.TRANSLUCENT;
    }

    @Override
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ISolidWorldTexture getConnectedTexture(IBlockState state, EnumFacing side) {
        return ((DecorStates)((Object)state.func_177229_b(BlockDecorativeGlass.decor))).tex;
    }

    public int getLightOpacity(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (state.func_177230_c() != this) {
            return 0;
        }
        return ((DecorStates)((Object)state.func_177229_b(BlockDecorativeGlass.decor))).opacity;
    }

    public int getLightValue(@Nonnull IBlockState state, IBlockAccess world, @Nonnull BlockPos pos) {
        if (state.func_177230_c() != this) {
            return 0;
        }
        return ((DecorStates)((Object)state.func_177229_b(BlockDecorativeGlass.decor))).light_level;
    }

    @Override
    public BlockRenderLayer renderLayer(IBlockState state) {
        return ((DecorStates)((Object)state.func_177229_b(BlockDecorativeGlass.decor))).layer;
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return state.func_177230_c() == this && ((DecorStates)((Object)state.func_177229_b(BlockDecorativeGlass.decor))).redstone_level > 0;
    }

    public int func_180656_a(IBlockState state, IBlockAccess worldIn, BlockPos pos, EnumFacing side) {
        if (state == null) {
            if (worldIn instanceof World && !((World)worldIn).func_175667_e(pos)) {
                return 0;
            }
            state = worldIn.func_180495_p(pos);
        }
        if (state.func_177230_c() != this) {
            return 0;
        }
        return ((DecorStates)((Object)state.func_177229_b(BlockDecorativeGlass.decor))).redstone_level;
    }

    public static enum DecorStates implements IItemStackMaker
    {
        glass{

            @Override
            public void addRecipes() {
                FurnaceRecipes.func_77602_a().func_151394_a(BlockDecorativeSolid.DecorStates.sandy_glass.newStack(1), this.newStack(1), 0.0f);
            }
        }
        ,
        glass_border{

            @Override
            public void addRecipes() {
                CraftingHelper.addShaped(this.newStack(4), "SS", "SS", Character.valueOf('S'), glass.newStack(1));
            }
        }
        ,
        glass_diamonds{

            @Override
            public void addRecipes() {
                CraftingHelper.addShaped(this.newStack(4), "SS", "SS", Character.valueOf('S'), glass_border.newStack(1));
            }
        }
        ,
        darkglass{
            {
                this.layer = BlockRenderLayer.TRANSLUCENT;
                this.opacity = 255;
            }

            @Override
            public void addRecipes() {
                CraftingHelper.addShapeless(this.newStack(2), glass.newStack(1), "dyeBlack", glass.newStack(1));
            }
        }
        ,
        glass_glowstone{
            {
                this.layer = BlockRenderLayer.TRANSLUCENT;
                this.light_level = 15;
            }

            @Override
            public void addRecipes() {
                CraftingHelper.addShapeless(this.newStack(2), glass.newStack(1), "dustGlowstone", glass.newStack(1));
            }
        }
        ,
        glass_redstone{
            {
                this.redstone_level = 15;
            }

            @Override
            public void addRecipes() {
                if (XU2Entries.resonator.isActive()) {
                    TileResonator.register(glass.newStack(1), this.newStack(1), 100);
                } else {
                    CraftingHelper.addShapeless(this.newStack(2), glass.newStack(1), "dustRedstone", glass.newStack(1));
                }
            }
        };

        @SideOnly(value=Side.CLIENT)
        public ISolidWorldTexture tex;
        int opacity = 0;
        int light_level = 0;
        int redstone_level = 0;
        BlockRenderLayer layer = BlockRenderLayer.CUTOUT;

        public abstract void addRecipes();

        public ItemStack newStack(int amount) {
            return XU2Entries.decorativeGlass.newStack(amount, new Object[]{decor, this});
        }

        @Override
        public ItemStack newStack() {
            return this.newStack(1);
        }
    }
}

