/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.blocks;

import com.rwtema.extrautils2.backend.PropertyEnumSimple;
import com.rwtema.extrautils2.backend.XUBlockStateCreator;
import com.rwtema.extrautils2.backend.XUBlockStatic;
import com.rwtema.extrautils2.backend.model.Box;
import com.rwtema.extrautils2.backend.model.BoxModel;
import com.rwtema.extrautils2.backend.model.BoxSingleQuad;
import com.rwtema.extrautils2.backend.model.UV;
import com.rwtema.extrautils2.fluids.FluidColors;
import com.rwtema.extrautils2.tile.TileDrum;
import com.rwtema.extrautils2.utils.Lang;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockDrum
extends XUBlockStatic {
    public static final PropertyEnumSimple<Capacity> PROPERTY_CAPACITY = new PropertyEnumSimple<Capacity>(Capacity.class);

    @Override
    public void func_149666_a(@Nonnull Item itemIn, CreativeTabs tab, List<ItemStack> list) {
        for (int i = 0; i < this.xuBlockState.dropmeta2state.length; ++i) {
            ItemStack emptyStack = new ItemStack(itemIn, 1, i);
            list.add(emptyStack);
        }
    }

    @Override
    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void postTextureRegister() {
        BlockColors blockColors;
        Minecraft mc = Minecraft.func_71410_x();
        ItemColors itemColors = mc.getItemColors();
        if (itemColors != null) {
            itemColors.func_186731_a(new IItemColor(){

                public int func_186726_a(@Nonnull ItemStack stack, int tintIndex) {
                    FluidStack fluidStack = TileDrum.getFluidFromItemStack(stack);
                    return FluidColors.getColor(fluidStack);
                }
            }, new Block[]{this});
        }
        if ((blockColors = mc.func_184125_al()) != null) {
            blockColors.func_186722_a(new IBlockColor(){

                public int func_186720_a(@Nonnull IBlockState state, IBlockAccess world, BlockPos pos, int tintIndex) {
                    TileEntity te;
                    if (tintIndex != 0 && world != null && pos != null && (te = world.func_175625_s(pos)) instanceof TileDrum) {
                        FluidStack fluid = ((TileDrum)te).tanks.getFluid();
                        return FluidColors.getColor(fluid);
                    }
                    return -1;
                }
            }, new Block[]{this});
        }
    }

    @Override
    @Nonnull
    protected XUBlockStateCreator createBlockState() {
        return new XUBlockStateCreator.Builder(this).addDropProperties(new IProperty[]{PROPERTY_CAPACITY}).build();
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nonnull
    public TileEntity createTileEntity(@Nonnull World world, @Nonnull IBlockState state) {
        return ((Capacity)((Object)state.func_177229_b(PROPERTY_CAPACITY))).createTile();
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        TileEntity te;
        if (!worldIn.field_72995_K && (te = worldIn.func_175625_s(pos)) instanceof TileDrum) {
            ((TileDrum)te).ticked();
        }
    }

    @Override
    public BoxModel getModel(IBlockState state) {
        int[][] vs;
        int i;
        Capacity capacity = (Capacity)((Object)state.func_177229_b(PROPERTY_CAPACITY));
        BoxModel model = new BoxModel();
        int n = 8;
        float[] t = new float[8];
        float[] x = new float[8];
        float[] z = new float[8];
        for (i = 0; i < 8; ++i) {
            double angle1 = (0.5 + (double)i) / 8.0 * 2.0 * Math.PI;
            x[i] = 0.5f + capacity.getWidth() * (float)Math.cos(angle1);
            z[i] = 0.5f + capacity.getWidth() * (float)Math.sin(angle1);
            t[i] = (float)i / 8.0f * 2.0f % 1.0f;
        }
        for (i = 0; i < 8; ++i) {
            int j = (i + 1) % 8;
            float u1 = t[i];
            float u2 = t[j];
            if ((double)u2 < 1.0E-10) {
                u2 = 1.0f;
            }
            model.add(new BoxSingleQuad(new UV(x[i], 0.0f, z[i], u1, 0.0f), new UV(x[i], 1.0f, z[i], u1, 1.0f), new UV(x[j], 1.0f, z[j], u2, 1.0f), new UV(x[j], 0.0f, z[j], u2, 0.0f)).setTexture("drum_center_colored").setLayer(BlockRenderLayer.CUTOUT).setTint(1));
            model.add(new BoxSingleQuad(new UV(x[i], 0.0f, z[i], u1, 0.0f), new UV(x[i], 1.0f, z[i], u1, 1.0f), new UV(x[j], 1.0f, z[j], u2, 1.0f), new UV(x[j], 0.0f, z[j], u2, 0.0f)).setTexture(capacity.texture_side));
        }
        for (int[] v : vs = new int[][]{{0, 1, 2, 3}, {4, 5, 6, 7}, {0, 3, 4, 7}}) {
            int j;
            int i2;
            UV[] vals = new UV[4];
            for (i2 = 0; i2 < 4; ++i2) {
                j = v[i2];
                vals[i2] = new UV(x[j], 0.0625f, z[j], x[j], z[j]);
            }
            model.add(new BoxSingleQuad(vals).setTexture(capacity.texture_top));
            vals = new UV[4];
            for (i2 = 0; i2 < 4; ++i2) {
                j = v[3 - i2];
                vals[i2] = new UV(x[j], 0.9375f, z[j], x[j], z[j]);
            }
            model.add(new BoxSingleQuad(vals).setTexture(capacity.texture_top));
        }
        model.overrideBounds = new Box(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        return model;
    }

    @Override
    public void addInformation(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        FluidStack fluidStack = TileDrum.getFluidFromItemStack(stack);
        if (fluidStack != null) {
            Fluid fluid = fluidStack.getFluid();
            String unlocalizedName = fluid == FluidRegistry.WATER ? "tile.water.name" : (fluid == FluidRegistry.LAVA ? "tile.lava.name" : fluid.getUnlocalizedName(fluidStack));
            int capacity = ((Capacity)((Object)this.xuBlockState.getStateFromDropMeta((int)stack.func_77960_j()).func_177229_b(BlockDrum.PROPERTY_CAPACITY))).capacity * 1000;
            tooltip.add(Lang.translateArgs("Drum: %s (%s / %s)", I18n.func_74838_a((String)unlocalizedName), fluidStack.amount, capacity));
        }
    }

    public static enum Capacity {
        DRUM_16("stone", 16){

            @Override
            public TileDrum createTile() {
                return new TileDrum.Tank16();
            }
        }
        ,
        DRUM_256("iron", 256){

            @Override
            public TileDrum createTile() {
                return new TileDrum.Tank256();
            }
        }
        ,
        DRUM_4096("highcapacity", 4096){

            @Override
            public float getWidth() {
                return 0.4f;
            }

            @Override
            public TileDrum createTile() {
                return new TileDrum.Tank4096();
            }
        }
        ,
        DRUM_65536("insane", 65536){

            @Override
            public TileDrum createTile() {
                return new TileDrum.Tank65536();
            }

            @Override
            public float getWidth() {
                return 0.484375f;
            }
        }
        ,
        DRUM_CREATIVE("creative", 10000){

            @Override
            public TileDrum createTile() {
                return new TileDrum.TankInf();
            }
        };

        public final String texture;
        public final String texture_side;
        public final String texture_top;
        public final int capacity;

        private Capacity(String texture, int capacity) {
            this.texture = texture;
            this.capacity = capacity;
            this.texture_side = "drum_center_stripe_" + texture;
            this.texture_top = "drum_top_" + texture;
        }

        public abstract TileDrum createTile();

        public float getWidth() {
            return 0.4f;
        }
    }
}

