/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.blocks;

import com.rwtema.extrautils2.backend.PropertyEnumSimple;
import com.rwtema.extrautils2.backend.XUBlock;
import com.rwtema.extrautils2.backend.XUBlockFull;
import com.rwtema.extrautils2.backend.XUBlockStateCreator;
import com.rwtema.extrautils2.backend.model.Textures;
import com.rwtema.extrautils2.textures.TextureRedstoneClock;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockRedstoneClock
extends XUBlockFull {
    public static final PropertyEnumSimple<PowerState> PROPERTY_POWER_STATE = new PropertyEnumSimple<PowerState>(PowerState.class);
    public static final int POWER_TIME = 2;
    public static final int TICK_TIME = 20;
    boolean canProvidePower = true;
    boolean changing = false;

    public BlockRedstoneClock() {
        super(Material.field_151576_e);
        for (PowerState powerState : PowerState.values()) {
            powerState.state = this.func_176223_P().func_177226_a(PROPERTY_POWER_STATE, (Comparable)((Object)powerState));
        }
    }

    @Override
    @Nonnull
    protected XUBlockStateCreator createBlockState() {
        return new XUBlockStateCreator((XUBlock)this, new IProperty[]{PROPERTY_POWER_STATE});
    }

    @Override
    public void registerTextures() {
        Textures.register("redstone_clock_off");
        Textures.textureNames.put("redstone_clock_on", new TextureRedstoneClock("ExtraUtils2:redstone_clock_on"));
    }

    @Override
    public String getTexture(IBlockState state, EnumFacing side) {
        if (state.func_177229_b(PROPERTY_POWER_STATE) == PowerState.DISABLED) {
            return "redstone_clock_off";
        }
        return "redstone_clock_on";
    }

    @Nonnull
    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.BLOCK;
    }

    public int func_180656_a(IBlockState state, IBlockAccess worldIn, BlockPos pos, EnumFacing side) {
        return this.canProvidePower && state.func_177229_b(PROPERTY_POWER_STATE) == PowerState.ENABLED_POWERED ? 15 : 0;
    }

    public boolean shouldCheckWeakPower(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    @Override
    public boolean func_149637_q(IBlockState state) {
        return true;
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        worldIn.func_180497_b(pos, (Block)this, 1, 0);
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    @Override
    public boolean func_176212_b(IBlockAccess worldIn, @Nonnull BlockPos pos, EnumFacing side) {
        return true;
    }

    public boolean isSideSolid(IBlockState base_state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, EnumFacing side) {
        return true;
    }

    @Override
    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block neighborBlock) {
        if (this.changing || worldIn.field_72995_K) {
            return;
        }
        boolean powered = this.isPowered((IBlockAccess)worldIn, pos);
        PowerState value = (PowerState)((Object)state.func_177229_b(PROPERTY_POWER_STATE));
        this.changing = true;
        if (powered && value != PowerState.DISABLED) {
            worldIn.func_180501_a(pos, PowerState.DISABLED.state, 3);
        } else if (!powered && value == PowerState.DISABLED) {
            int l = (int)(worldIn.func_82737_E() % 20L);
            if (l < 2) {
                worldIn.func_180501_a(pos, PowerState.ENABLED_POWERED.state, 3);
                worldIn.func_180497_b(pos, (Block)this, 2 - l, 0);
            } else {
                worldIn.func_180501_a(pos, PowerState.ENABLED_NOT_POWERED.state, 3);
                worldIn.func_180497_b(pos, (Block)this, 20 - l, 0);
            }
        }
        this.changing = false;
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (worldIn.field_72995_K) {
            return;
        }
        PowerState powerState = (PowerState)((Object)state.func_177229_b(PROPERTY_POWER_STATE));
        if (powerState == PowerState.DISABLED) {
            return;
        }
        int l = (int)(worldIn.func_82737_E() % 20L);
        this.changing = true;
        if (l < 2) {
            worldIn.func_180501_a(pos, PowerState.ENABLED_POWERED.state, 1);
            worldIn.func_180497_b(pos, (Block)this, 2 - l, 0);
        } else {
            worldIn.func_180501_a(pos, PowerState.ENABLED_NOT_POWERED.state, 1);
            if (this.isPowered((IBlockAccess)worldIn, pos)) {
                worldIn.func_180501_a(pos, PowerState.DISABLED.state, 3);
            } else {
                worldIn.func_180497_b(pos, (Block)this, 20 - l, 0);
            }
        }
        this.changing = false;
    }

    private boolean isPowered(IBlockAccess worldIn, BlockPos pos) {
        this.canProvidePower = false;
        boolean powered = false;
        for (EnumFacing side : EnumFacing.values()) {
            if (worldIn.func_175627_a(pos.func_177972_a(side), side) <= 0) continue;
            powered = true;
            break;
        }
        this.canProvidePower = true;
        return powered;
    }

    static enum PowerState {
        ENABLED_NOT_POWERED,
        ENABLED_POWERED,
        DISABLED;

        public IBlockState state;
    }
}

