/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.commands;

import com.google.common.collect.Lists;
import com.rwtema.extrautils2.ExtraUtils2;
import com.rwtema.extrautils2.achievements.AchievementHelper;
import com.rwtema.extrautils2.chunkloading.XUChunkLoaderManager;
import com.rwtema.extrautils2.power.PowerManager;
import com.rwtema.extrautils2.utils.LogHelper;
import gnu.trove.iterator.TObjectLongIterator;
import gnu.trove.map.hash.TObjectLongHashMap;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.ChunkProviderServer;

public class CommandDebug
extends CommandBase {
    @Nonnull
    public String func_71517_b() {
        return "xudebug";
    }

    @Nonnull
    public String func_71518_a(@Nonnull ICommandSender sender) {
        return "xudebug";
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return ExtraUtils2.deobf || ExtraUtils2.version.contains("fc1-build");
    }

    public void func_184881_a(@Nonnull MinecraftServer server, @Nonnull ICommandSender sender, @Nonnull String[] args) throws CommandException {
        if (args.length == 0) {
            throw new CommandException("Unknown Command", new Object[0]);
        }
        String t = args[0];
        ArrayList info = Lists.newArrayList();
        switch (t) {
            case "power": {
                PowerManager.instance.getDebug(info);
                break;
            }
            case "chunks": {
                XUChunkLoaderManager.instance.getDebug(info);
                break;
            }
            case "packethandler": {
                break;
            }
            case "onetime": {
                info.addAll(LogHelper.getOneTimeStrings());
                break;
            }
            case "ach": {
                AchievementHelper.bake();
                break;
            }
            case "tpx": {
                break;
            }
            case "checkBlockContents": {
                World world = sender.func_130014_f_();
                if (!(world instanceof WorldServer)) break;
                TObjectLongHashMap types = new TObjectLongHashMap();
                ChunkProviderServer chunkProvider = ((WorldServer)world).func_72863_F();
                Collection loadedChunks = chunkProvider.func_189548_a();
                long total = 0L;
                for (Chunk chunk : loadedChunks) {
                    for (int y = 0; y < 256; ++y) {
                        for (int x = 0; x < 16; ++x) {
                            for (int z = 0; z < 16; ++z) {
                                IBlockState blockState = chunk.func_186032_a(x, y, z);
                                types.adjustOrPutValue((Object)blockState, 1L, 1L);
                            }
                        }
                    }
                }
                info.add("Block Component Results:");
                TObjectLongIterator iterator = types.iterator();
                while (iterator.hasNext()) {
                    iterator.advance();
                    info.add(((IBlockState)iterator.key()).toString() + ": " + iterator.value() + "  (" + (double)iterator.value() / (double)loadedChunks.size() + ")");
                }
                break;
            }
            default: {
                throw new CommandException("Unknown Command", new Object[0]);
            }
        }
        for (String s : info) {
            sender.func_145747_a((ITextComponent)new TextComponentString(s));
        }
    }
}

