/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.crafting;

import com.rwtema.extrautils2.ExtraUtils2;
import com.rwtema.extrautils2.api.recipes.IRecipeInfoWrapper;
import com.rwtema.extrautils2.backend.ISidedFunction;
import com.rwtema.extrautils2.crafting.IItemMatcher;
import com.rwtema.extrautils2.utils.Lang;
import com.rwtema.extrautils2.utils.helpers.ItemStackHelper;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketSetExperience;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerList;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EnchantRecipe
implements IRecipe,
IRecipeInfoWrapper<IRecipe> {
    public final IRecipe recipe;
    public final IItemMatcher matcher;
    private final int enchantLevel;

    public EnchantRecipe(IRecipe recipe, int enchantLevel) {
        this.recipe = recipe;
        this.matcher = recipe instanceof IItemMatcher ? (IItemMatcher)recipe : IItemMatcher.CRAFTING;
        this.enchantLevel = enchantLevel;
        MinecraftForge.EVENT_BUS.register((Object)new EventHandler());
    }

    public int func_77570_a() {
        return this.recipe.func_77570_a();
    }

    public ItemStack func_77571_b() {
        return this.recipe.func_77571_b();
    }

    @Nonnull
    public ItemStack[] func_179532_b(@Nonnull InventoryCrafting inv) {
        return this.recipe.func_179532_b(inv);
    }

    public ItemStack func_77572_b(@Nonnull InventoryCrafting var1) {
        if (!this.isGoodForCrafting(var1)) {
            return null;
        }
        return this.recipe.func_77572_b(var1);
    }

    public boolean func_77569_a(@Nonnull InventoryCrafting inv, @Nonnull World world) {
        return this.recipe.func_77569_a(inv, world);
    }

    public boolean isGoodForCrafting(InventoryCrafting inv) {
        PlayerList manager;
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            return ExtraUtils2.proxy.apply(new ClientIsGoodForCrafting(inv), null);
        }
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (server != null && (manager = server.func_184103_al()) != null) {
            Container container = inv.field_70465_c;
            if (container == null) {
                return false;
            }
            EntityPlayerMP foundPlayer = null;
            for (EntityPlayerMP entityPlayerMP : manager.func_181057_v()) {
                if (entityPlayerMP.field_71070_bA != container || !container.func_75145_c((EntityPlayer)entityPlayerMP) || !container.func_75129_b((EntityPlayer)entityPlayerMP)) continue;
                if (foundPlayer != null) {
                    return false;
                }
                foundPlayer = entityPlayerMP;
            }
            if (foundPlayer != null) {
                foundPlayer.field_71135_a.func_147359_a((Packet)new SPacketSetExperience(foundPlayer.field_71106_cc, foundPlayer.field_71067_cb, foundPlayer.field_71068_ca));
                return foundPlayer.field_71068_ca >= this.enchantLevel;
            }
        }
        return false;
    }

    @Override
    public IRecipe getOriginalRecipe() {
        return this.recipe;
    }

    @Override
    public String info() {
        return Lang.translateArgs("%s XP", this.enchantLevel);
    }

    private class ClientIsGoodForCrafting
    implements ISidedFunction<Void, Boolean> {
        private final InventoryCrafting inv;

        public ClientIsGoodForCrafting(InventoryCrafting inv) {
            this.inv = inv;
        }

        @Override
        @SideOnly(value=Side.SERVER)
        public Boolean applyServer(Void input) {
            return false;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public Boolean applyClient(Void input) {
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            return player != null && player.field_71068_ca >= EnchantRecipe.this.enchantLevel && player.field_71070_bA == this.inv.field_70465_c;
        }
    }

    private class EventHandler {
        private EventHandler() {
        }

        @SideOnly(value=Side.CLIENT)
        @SubscribeEvent
        public void tooltip(ItemTooltipEvent event) {
            ItemStack itemStack = event.getItemStack();
            if (itemStack != EnchantRecipe.this.recipe.func_77571_b()) {
                return;
            }
            if (EnchantRecipe.this.enchantLevel == 1) {
                ItemStackHelper.addInfoWidth(event.getToolTip(), itemStack, Lang.translate("Requires 1 enchantment level to craft"));
            } else {
                ItemStackHelper.addInfoWidth(event.getToolTip(), itemStack, Lang.translateArgs("Requires %s enchantment levels to craft", EnchantRecipe.this.enchantLevel));
            }
        }

        @SubscribeEvent
        public void onCraft(PlayerEvent.ItemCraftedEvent event) {
            EntityPlayer player = event.player;
            if (player == null) {
                return;
            }
            ItemStack crafting = event.crafting;
            if (crafting == null || !EnchantRecipe.this.matcher.itemsMatch(crafting, EnchantRecipe.this.recipe.func_77571_b())) {
                return;
            }
            player.func_71013_b(EnchantRecipe.this.enchantLevel);
        }
    }
}

