/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.crafting.jei;

import com.rwtema.extrautils2.api.recipes.IRecipeInfoWrapper;
import java.awt.Color;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.BlankRecipeWrapper;
import mezz.jei.api.recipe.IRecipeHandler;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.api.recipe.wrapper.ICraftingRecipeWrapper;
import mezz.jei.api.recipe.wrapper.IShapedCraftingRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;

public class JEIVanillaCraftingRecipeHandler<T extends IRecipeInfoWrapper>
implements IRecipeHandler<T> {
    final Class<T> clazz;

    public JEIVanillaCraftingRecipeHandler(Class<T> clazz) {
        this.clazz = clazz;
    }

    @Nonnull
    public Class<T> getRecipeClass() {
        return this.clazz;
    }

    @Nonnull
    public String getRecipeCategoryUid() {
        return "minecraft.crafting";
    }

    @Nonnull
    public String getRecipeCategoryUid(@Nonnull T recipe) {
        return "minecraft.crafting";
    }

    @Nonnull
    public IRecipeWrapper getRecipeWrapper(@Nonnull T recipe) {
        int[] dimensions = IRecipeInfoWrapper.getDimensions(recipe.getOriginalRecipe());
        if (dimensions != null) {
            return new MyIShapedCraftingRecipeWrapper(this, recipe, dimensions[0], dimensions[1]);
        }
        return new MyICraftingRecipeWrapper(this, recipe);
    }

    public void drawInfo(T recipe, ICraftingRecipeWrapper iCraftingRecipeWrapper, Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        String info = recipe.info();
        if (info != null) {
            minecraft.field_71466_p.func_78276_b(info, 60, 10, Color.black.getRGB());
        }
    }

    public boolean isRecipeValid(@Nonnull T recipe) {
        return true;
    }

    private static class MyICraftingRecipeWrapper
    extends BlankRecipeWrapper
    implements ICraftingRecipeWrapper {
        protected final T recipe;
        protected final List<List<ItemStack>> inputs;
        protected final ItemStack output;
        final /* synthetic */ JEIVanillaCraftingRecipeHandler this$0;

        public MyICraftingRecipeWrapper(T recipe) {
            this.this$0 = var1_1;
            this.recipe = recipe;
            Object originalRecipe = recipe.getOriginalRecipe();
            this.inputs = IRecipeInfoWrapper.getInputList(originalRecipe);
            this.output = originalRecipe.func_77571_b();
        }

        public void getIngredients(@Nonnull IIngredients ingredients) {
            ingredients.setOutput(ItemStack.class, (Object)this.output);
            ingredients.setInputLists(ItemStack.class, this.inputs);
        }

        public void drawInfo(@Nonnull Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
            this.this$0.drawInfo(this.recipe, this, minecraft, recipeWidth, recipeHeight, mouseX, mouseY);
        }
    }

    private class MyIShapedCraftingRecipeWrapper
    extends MyICraftingRecipeWrapper
    implements IShapedCraftingRecipeWrapper {
        final int width;
        final int height;
        final /* synthetic */ JEIVanillaCraftingRecipeHandler this$0;

        /*
         * WARNING - Possible parameter corruption
         */
        public MyIShapedCraftingRecipeWrapper(T recipe, int width, int height) {
            this.this$0 = (JEIVanillaCraftingRecipeHandler)n;
            super((JEIVanillaCraftingRecipeHandler)n, recipe);
            this.width = width;
            this.height = height;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }
    }
}

