/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.crafting.jei;

import com.google.common.collect.Lists;
import com.rwtema.extrautils2.api.machine.IMachineRecipe;
import com.rwtema.extrautils2.api.machine.Machine;
import com.rwtema.extrautils2.api.machine.MachineRegistry;
import com.rwtema.extrautils2.api.machine.MachineSlotFluid;
import com.rwtema.extrautils2.api.machine.MachineSlotItem;
import com.rwtema.extrautils2.backend.entries.XU2Entries;
import com.rwtema.extrautils2.crafting.EnchantRecipe;
import com.rwtema.extrautils2.crafting.jei.BlockPatternHandler;
import com.rwtema.extrautils2.crafting.jei.JEIMachine;
import com.rwtema.extrautils2.crafting.jei.JEIRadar;
import com.rwtema.extrautils2.crafting.jei.JEIVanillaCraftingRecipeHandler;
import com.rwtema.extrautils2.crafting.jei.PatternRecipe;
import com.rwtema.extrautils2.crafting.jei.ResonatorHandler;
import com.rwtema.extrautils2.gui.backend.DynamicContainer;
import com.rwtema.extrautils2.gui.backend.DynamicGui;
import com.rwtema.extrautils2.gui.backend.DynamicWindow;
import com.rwtema.extrautils2.gui.backend.WidgetSlotGhost;
import com.rwtema.extrautils2.items.ItemIngredients;
import com.rwtema.extrautils2.machine.BlockMachine;
import com.rwtema.extrautils2.machine.ItemBlockMachine;
import com.rwtema.extrautils2.network.NetworkHandler;
import com.rwtema.extrautils2.network.PacketBuffer;
import com.rwtema.extrautils2.tile.TileCrafter;
import com.rwtema.extrautils2.tile.TileResonator;
import com.rwtema.extrautils2.transfernodes.TileIndexer;
import com.rwtema.extrautils2.utils.Lang;
import com.rwtema.extrautils2.utils.LogHelper;
import com.rwtema.extrautils2.utils.datastructures.ItemRef;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.BlankModPlugin;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IItemListOverlay;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IJeiRuntime;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.IRecipeRegistry;
import mezz.jei.api.ISubtypeRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.gui.IAdvancedGuiHandler;
import mezz.jei.api.gui.IGuiIngredient;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import mezz.jei.gui.ItemListOverlay;
import mezz.jei.input.ICloseable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.Pair;

@JEIPlugin
public class XUJEIPlugin
extends BlankModPlugin
implements IModPlugin {
    public static IJeiHelpers jeiHelpers;
    public static IRecipeRegistry recipeRegistry;
    public static IGuiHelper guiHelper;

    public XUJEIPlugin() {
        LogHelper.info("Extra Utilities 2 JEI Plugin - ACTIVATE!", new Object[0]);
    }

    public void register(@Nonnull IModRegistry registry) {
        jeiHelpers = registry.getJeiHelpers();
        registry.addRecipeCategories(new IRecipeCategory[]{BlockPatternHandler.category});
        registry.addRecipeHandlers(new IRecipeHandler[]{BlockPatternHandler.handler});
        registry.addRecipes(PatternRecipe.recipeList);
        if (XU2Entries.itemFakeCopy.isActive()) {
            jeiHelpers.getItemBlacklist().addItemToBlacklist(XU2Entries.itemFakeCopy.newStack(1, Short.MAX_VALUE));
        }
        if (XU2Entries.blockSpotlight.isActive()) {
            jeiHelpers.getItemBlacklist().addItemToBlacklist(XU2Entries.blockSpotlight.newStack(1, Short.MAX_VALUE));
        }
        if (XU2Entries.sunCrystal.isActive()) {
            registry.addDescription(XU2Entries.sunCrystal.newStack(1), new String[]{Lang.translate("Craft an empty Sun Crystal first, then throw the crystal on the ground in direct sunlight.")});
        }
        if (XU2Entries.blockEnderLilly.isActive()) {
            registry.addDescription(XU2Entries.blockEnderLilly.newStack(1), new String[]{Lang.translate("Found in dungeon chests.")});
        }
        if (XU2Entries.blockRedOrchid.isActive()) {
            registry.addDescription(XU2Entries.blockRedOrchid.newStack(1), new String[]{Lang.translate("Found in dungeon chests.")});
        }
        if (XU2Entries.itemIngredients.isActive()) {
            registry.addDescription(ItemIngredients.Type.EVIL_DROP.newStack(), new String[]{Lang.translate("Rare drop from wither skeletons")});
        }
        if (XU2Entries.cursedEarth.isActive()) {
            registry.addDescription(XU2Entries.cursedEarth.newStack(), new String[]{Lang.translate("Right click soil with a drop of evil.")});
        }
        if (XU2Entries.resonator.isActive()) {
            ResonatorHandler resonator = new ResonatorHandler();
            registry.addRecipeCategoryCraftingItem(XU2Entries.resonator.newStack(), new String[]{"ExtraUtils2.resonator"});
            registry.addRecipeCategories(new IRecipeCategory[]{resonator});
            registry.addRecipeHandlers(new IRecipeHandler[]{resonator});
            registry.addRecipes(TileResonator.resonatorRecipes);
        }
        if (XU2Entries.machineEntry.isActive()) {
            JEIMachine.helper = registry.getIngredientRegistry().getIngredientHelper(ItemStack.class);
            JEIMachine.renderer = registry.getIngredientRegistry().getIngredientRenderer(ItemStack.class);
            registry.addRecipeHandlers(new IRecipeHandler[]{JEIMachine.Handler.INSTANCE});
            for (Machine machine : MachineRegistry.getMachineValues()) {
                JEIMachine handler = new JEIMachine(machine);
                registry.addRecipeCategoryCraftingItem(((BlockMachine)XU2Entries.machineEntry.value).createStack(machine), new String[]{handler.getUid()});
                registry.addRecipeCategories(new IRecipeCategory[]{handler});
                for (IMachineRecipe recipe : machine.recipes_registry) {
                    List<Pair<Map<MachineSlotItem, List<ItemStack>>, Map<MachineSlotFluid, FluidStack>>> jeiInputItemExamples = recipe.getJEIInputItemExamples();
                    registry.addRecipes(jeiInputItemExamples.stream().map(mapMapPair -> new JEIMachine.JEIMachineRecipe(machine, recipe, (Map)mapMapPair.getLeft(), (Map)mapMapPair.getRight())).collect(Collectors.toList()));
                }
            }
            registry.getJeiHelpers().getSubtypeRegistry().registerNbtInterpreter((Item)Validate.notNull((Object)Item.func_150898_a((Block)((Block)XU2Entries.machineEntry.value))), new ISubtypeRegistry.ISubtypeInterpreter(){

                @Nullable
                public String getSubtypeInfo(@Nonnull ItemStack itemStack) {
                    if (!itemStack.func_77942_o()) {
                        return "machine[blank]";
                    }
                    Machine machineType = ItemBlockMachine.getMachineType(itemStack);
                    return "machine[" + (machineType != null ? machineType.name : "unknown") + "]";
                }
            });
        }
        registry.addRecipeHandlers(new IRecipeHandler[]{new JEIVanillaCraftingRecipeHandler<EnchantRecipe>(EnchantRecipe.class)});
        registry.addAdvancedGuiHandlers(new IAdvancedGuiHandler[]{new IAdvancedGuiHandler<DynamicGui>(){

            @Nonnull
            public Class<DynamicGui> getGuiContainerClass() {
                return DynamicGui.class;
            }

            @Nullable
            public List<Rectangle> getGuiExtraAreas(@Nonnull DynamicGui gui) {
                ArrayList rectangles = Lists.newArrayList();
                for (DynamicWindow window : gui.container.getWindows()) {
                    rectangles.add(new Rectangle(gui.field_147003_i + window.x, gui.field_147009_r + window.y, window.w, window.h));
                }
                return rectangles;
            }
        }});
        if (XU2Entries.indexer.enabled) {
            registry.getRecipeTransferRegistry().addUniversalRecipeTransferHandler((IRecipeTransferHandler)new IRecipeTransferHandler<TileIndexer.ContainerIndexer>(){

                @Nonnull
                public Class<TileIndexer.ContainerIndexer> getContainerClass() {
                    return TileIndexer.ContainerIndexer.class;
                }

                @Nonnull
                public String getRecipeCategoryUid() {
                    return "universal recipe transfer handler";
                }

                @Nullable
                public IRecipeTransferError transferRecipe(@Nonnull TileIndexer.ContainerIndexer container, @Nonnull IRecipeLayout recipeLayout, @Nonnull EntityPlayer player, boolean maxTransfer, boolean doTransfer) {
                    IRecipeTransferHandlerHelper handlerHelper = jeiHelpers.recipeTransferHandlerHelper();
                    ArrayList toFind = new ArrayList();
                    IGuiItemStackGroup itemStackGroup = recipeLayout.getItemStacks();
                    Map guiIngredients = itemStackGroup.getGuiIngredients();
                    for (IGuiIngredient ingredient : guiIngredients.values()) {
                        Set collect;
                        if (!ingredient.isInput() || (collect = ingredient.getAllIngredients().stream().map(ItemRef::wrapCrafting).collect(Collectors.toSet())).isEmpty()) continue;
                        toFind.add(collect);
                    }
                    ArrayList<ItemRef> toRequest = new ArrayList<ItemRef>();
                    ArrayList<ItemRef> list = container.list;
                    for (ItemRef itemRef : list) {
                        ItemRef craftingRef = itemRef.toCraftingVersion();
                        ItemRef wildRef = craftingRef.toNoMetaVersion();
                        Iterator iterator = toFind.iterator();
                        while (iterator.hasNext()) {
                            Set itemRefs = (Set)iterator.next();
                            if (!itemRefs.contains(craftingRef) && !itemRefs.contains(wildRef)) continue;
                            toRequest.add(itemRef);
                            iterator.remove();
                        }
                        if (!toFind.isEmpty()) continue;
                        break;
                    }
                    if (toRequest.isEmpty()) {
                        return handlerHelper.createUserErrorWithTooltip(Lang.translate("Unable to find any ingredients"));
                    }
                    if (doTransfer) {
                        for (ItemRef itemRef : toRequest) {
                            PacketBuffer pkt = new PacketBuffer();
                            if (itemRef == ItemRef.NULL) continue;
                            itemRef.write(pkt);
                            pkt.writeBoolean(maxTransfer);
                            container.sendInputPacket(container.mainButton, pkt);
                        }
                    }
                    return null;
                }
            });
        }
        if (XU2Entries.blockCrafter.enabled) {
            registry.addRecipeCategoryCraftingItem(XU2Entries.blockCrafter.newStack(), new String[]{"minecraft.crafting"});
            registry.getRecipeTransferRegistry().addRecipeTransferHandler((IRecipeTransferHandler)new IRecipeTransferHandler<TileCrafter.CrafterContainer>(){

                @Nonnull
                public Class<TileCrafter.CrafterContainer> getContainerClass() {
                    return TileCrafter.CrafterContainer.class;
                }

                @Nonnull
                public String getRecipeCategoryUid() {
                    return "minecraft.crafting";
                }

                @Nullable
                public IRecipeTransferError transferRecipe(@Nonnull TileCrafter.CrafterContainer container, @Nonnull IRecipeLayout recipeLayout, @Nonnull EntityPlayer player, boolean maxTransfer, boolean doTransfer) {
                    if (!doTransfer) {
                        return null;
                    }
                    Map guiIngredients = recipeLayout.getItemStacks().getGuiIngredients();
                    for (int i = 0; i < 9; ++i) {
                        List allIngredients;
                        IGuiIngredient value = (IGuiIngredient)guiIngredients.get(1 + i);
                        ItemStack stack = value != null ? (!(allIngredients = value.getAllIngredients()).isEmpty() ? (ItemStack)allIngredients.get(0) : null) : null;
                        WidgetSlotGhost ghostSlot = container.ghostSlots[i];
                        int widgetID = container.getWidgets().indexOf(ghostSlot);
                        NetworkHandler.sendPacketToServer(new DynamicContainer.PacketSetGhost(container.field_75152_c, widgetID, stack));
                    }
                    return null;
                }
            });
            guiHelper = registry.getJeiHelpers().getGuiHelper();
        }
    }

    public void onRuntimeAvailable(@Nonnull IJeiRuntime jeiRuntime) {
        IItemListOverlay itemListOverlay = jeiRuntime.getItemListOverlay();
        ItemListOverlay closable = (ItemListOverlay)itemListOverlay;
        JEIRadar.register(itemListOverlay);
        if (XU2Entries.indexer.enabled) {
            TileIndexer.ContainerIndexer.textInterface = new TileIndexer.ContainerIndexer.JeiTextInterface((ICloseable)closable, itemListOverlay){
                final /* synthetic */ ICloseable val$closable;
                final /* synthetic */ IItemListOverlay val$itemListOverlay;
                {
                    this.val$closable = iCloseable;
                    this.val$itemListOverlay = iItemListOverlay;
                }

                @Override
                @Nonnull
                public String getFilterText() {
                    return this.val$closable.isOpen() ? this.val$itemListOverlay.getFilterText() : "";
                }

                @Override
                public void setFilterText(@Nonnull String text) {
                    this.val$itemListOverlay.setFilterText(text);
                }
            };
        }
        recipeRegistry = jeiRuntime.getRecipeRegistry();
    }

    public class SubType
    implements ISubtypeRegistry.ISubtypeInterpreter {
        HashSet<String> types;

        @Nullable
        public String getSubtypeInfo(@Nonnull ItemStack itemStack) {
            NBTTagCompound tagCompound = itemStack.func_77978_p();
            if (tagCompound == null) {
                return null;
            }
            return null;
        }
    }
}

