/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.dimensions.workhousedim;

import com.google.common.collect.ImmutableSet;
import com.rwtema.extrautils2.backend.entries.XU2Entries;
import com.rwtema.extrautils2.backend.save.SaveManager;
import com.rwtema.extrautils2.backend.save.SaveModule;
import com.rwtema.extrautils2.dimensions.XUWorldProvider;
import com.rwtema.extrautils2.dimensions.workhousedim.ChunkProviderSpecialDim;
import com.rwtema.extrautils2.utils.XURandom;
import com.rwtema.extrautils2.utils.datastructures.NBTSerializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ClassInheritanceMultiMap;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityTravelToDimensionEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class WorldProviderSpecialDim
extends XUWorldProvider {
    public static final int DIST_BETWEEN_CHUNKS = 3;
    public static final NBTSerializable.NBTCollection<ChunkPos, Set<ChunkPos>, NBTTagLong> diggingChunks = new NBTSerializable.NBTCollection<ChunkPos, HashSet<ChunkPos>, NBTTagLong>(new HashSet(), chunkPos -> new NBTTagLong((long)chunkPos.field_77276_a << 32 | (long)chunkPos.field_77275_b & 0xFFFFFFFFL), nbtTagLong -> {
        long c = nbtTagLong.func_150291_c();
        return new ChunkPos((int)(c >> 32), (int)c);
    });
    public static Biome biome = null;
    public static Long seedOverride = null;
    private ChunkProviderSpecialDim chunkProviderSpecialDim;
    static List<Biome> suitableBiomes = null;
    static final Set<BiomeDictionary.Type> blacklist = ImmutableSet.of((Object)BiomeDictionary.Type.NETHER, (Object)BiomeDictionary.Type.END);

    @Nonnull
    private static List<Biome> buildBiomesList() {
        ArrayList<Biome> biomes = new ArrayList<Biome>();
        block0: for (Biome biome : Biome.field_185377_q) {
            for (BiomeDictionary.Type type : BiomeDictionary.getTypesForBiome((Biome)biome)) {
                if (blacklist.contains(type)) continue block0;
            }
            biomes.add(biome);
        }
        return biomes;
    }

    public WorldProviderSpecialDim() {
        super(XU2Entries.specialdim);
        this.field_76576_e = true;
        SaveManager.saveModules.add(new DigLocationsSaveModule());
        MinecraftForge.EVENT_BUS.register(WorldProviderSpecialDim.class);
    }

    @SubscribeEvent
    public static void preventTeleportation(EntityTravelToDimensionEvent event) {
    }

    private static void resetChunkBlocks(World world, int chunkXPos, int chunkZPos) {
        Chunk chunk = world.func_72964_e(chunkXPos, chunkZPos);
        ClassInheritanceMultiMap[] entityLists = chunk.func_177429_s();
        for (ClassInheritanceMultiMap entityList : entityLists) {
            for (Entity entity : entityList) {
                if (entity instanceof EntityPlayer) continue;
                entity.func_70106_y();
            }
        }
        for (TileEntity tileEntity : chunk.func_177434_r().values()) {
            tileEntity.func_145843_s();
        }
        chunk.func_177434_r().clear();
        WorldProviderSpecialDim provider = (WorldProviderSpecialDim)WorldProviderSpecialDim.getWorld().field_73011_w;
        chunk.func_76602_a(provider.chunkProviderSpecialDim.func_185932_a(chunkXPos, chunkZPos).func_76587_i());
        chunk.func_177446_d(true);
        chunk.func_76630_e();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releaseChunk(ChunkPos pos) {
        NBTSerializable.NBTCollection<ChunkPos, Set<ChunkPos>, NBTTagLong> nBTCollection = diggingChunks;
        synchronized (nBTCollection) {
            ((Set)WorldProviderSpecialDim.diggingChunks.collection).remove(pos);
            ChunkPos chunkPos = WorldProviderSpecialDim.adjustChunkRef(pos);
            for (int dx = -1; dx <= 1; ++dx) {
                for (int dz = -1; dz <= 1; ++dz) {
                    WorldProviderSpecialDim.resetChunkBlocks((World)WorldProviderSpecialDim.getWorld(), chunkPos.field_77276_a + dx, chunkPos.field_77275_b + dz);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ChunkPos prepareNewChunk() {
        NBTSerializable.NBTCollection<ChunkPos, Set<ChunkPos>, NBTTagLong> nBTCollection = diggingChunks;
        synchronized (nBTCollection) {
            ChunkPos pos = new ChunkPos(0, 0);
            int i = 0;
            int n = 1;
            boolean z = false;
            Dir d = Dir.RIGHT;
            while (((Set)WorldProviderSpecialDim.diggingChunks.collection).contains(pos)) {
                pos = new ChunkPos(pos.field_77276_a + d.dx, pos.field_77275_b + d.dz);
                if (++i != n) continue;
                i = 0;
                if (z) {
                    ++n;
                }
                z = !z;
                d = d.getNext();
            }
            ((Set)WorldProviderSpecialDim.diggingChunks.collection).add(pos);
            WorldServer world = WorldProviderSpecialDim.getWorld();
            ChunkPos chunkPos = WorldProviderSpecialDim.adjustChunkRef(pos);
            ChunkProviderServer chunkProvider = world.func_72863_F();
            IChunkGenerator generator = chunkProvider.field_186029_c;
            try {
                seedOverride = XURandom.rand.nextLong();
                if (suitableBiomes == null) {
                    suitableBiomes = WorldProviderSpecialDim.buildBiomesList();
                }
                biome = XURandom.getRandomElement(suitableBiomes);
                WorldProviderSpecialDim.generate(chunkPos.field_77276_a, chunkPos.field_77275_b, chunkProvider, generator);
                WorldProviderSpecialDim.generate(chunkPos.field_77276_a, chunkPos.field_77275_b - 1, chunkProvider, generator);
                WorldProviderSpecialDim.generate(chunkPos.field_77276_a - 1, chunkPos.field_77275_b, chunkProvider, generator);
                WorldProviderSpecialDim.generate(chunkPos.field_77276_a - 1, chunkPos.field_77275_b - 1, chunkProvider, generator);
            }
            finally {
                seedOverride = null;
                biome = null;
            }
            return pos;
        }
    }

    private static void generate(int chunkXPos, int chunkZPos, ChunkProviderServer chunkProvider, IChunkGenerator generator) {
        Chunk chunk = chunkProvider.func_186025_d(chunkXPos, chunkZPos);
        int idForBiome = Biome.func_185362_a((Biome)biome);
        Arrays.fill(chunk.func_76605_m(), (byte)idForBiome);
        chunk.func_177446_d(true);
        generator.func_185931_b(chunk.field_76635_g, chunk.field_76647_h);
        GameRegistry.generateWorld((int)chunk.field_76635_g, (int)chunk.field_76647_h, (World)chunk.func_177412_p(), (IChunkGenerator)generator, (IChunkProvider)chunk.func_177412_p().func_72863_F());
        chunk.func_76630_e();
        chunk.func_177446_d(true);
    }

    public static WorldServer getWorld() {
        return DimensionManager.getWorld((int)((DimensionType)XU2Entries.specialdim.value).func_186068_a());
    }

    public static ChunkPos adjustChunkRef(ChunkPos pos) {
        return new ChunkPos(pos.field_77276_a * 3, pos.field_77275_b * 3);
    }

    public boolean func_76567_e() {
        return false;
    }

    @Nonnull
    public IChunkGenerator func_186060_c() {
        this.chunkProviderSpecialDim = new ChunkProviderSpecialDim(this.field_76579_a);
        return this.chunkProviderSpecialDim;
    }

    @Nonnull
    public Biome getBiomeForCoords(@Nonnull BlockPos pos) {
        if (biome != null) {
            return biome;
        }
        return super.getBiomeForCoords(pos);
    }

    public long getSeed() {
        Long seedOverride = WorldProviderSpecialDim.seedOverride;
        if (seedOverride != null) {
            return seedOverride;
        }
        return super.getSeed();
    }

    private static class DigLocationsSaveModule
    extends SaveModule {
        public DigLocationsSaveModule() {
            super("special_dim_dig_positions");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void readFromNBT(NBTTagCompound nbt) {
            NBTSerializable.NBTCollection<ChunkPos, Set<ChunkPos>, NBTTagLong> nBTCollection = diggingChunks;
            synchronized (nBTCollection) {
                diggingChunks.deserializeNBT(nbt.func_150295_c("list", 4));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void writeToNBT(NBTTagCompound nbt) {
            NBTSerializable.NBTCollection<ChunkPos, Set<ChunkPos>, NBTTagLong> nBTCollection = diggingChunks;
            synchronized (nBTCollection) {
                nbt.func_74782_a("list", (NBTBase)diggingChunks.serializeNBT());
            }
        }

        @Override
        public void reset() {
            ((Set)WorldProviderSpecialDim.diggingChunks.collection).clear();
        }
    }

    static enum Dir {
        RIGHT(1, 0),
        UP(0, 1),
        LEFT(-1, 0),
        DOWN(0, -1);

        final int dx;
        final int dz;
        Dir next;

        private Dir(int dx, int dz) {
            this.dx = dx;
            this.dz = dz;
        }

        public Dir getNext() {
            if (this.next == null) {
                this.next = Dir.values()[(this.ordinal() + 1) % 4];
            }
            return this.next;
        }
    }
}

