/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.fairies;

import com.rwtema.extrautils2.fairies.Fairies;
import com.rwtema.extrautils2.network.PacketBuffer;
import com.rwtema.extrautils2.utils.datastructures.NBTSerializable;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.util.INBTSerializable;

public abstract class Fairy
implements INBTSerializable<NBTTagCompound> {
    public static int currentID;
    public final int id = currentID++;
    private final HashMap<String, INBTSerializable> nbtHandlers = new HashMap();
    public NBTSerializable.Vec pos = this.registerNBT("pos", new NBTSerializable.Vec());
    public NBTSerializable.Vec dest = this.registerNBT("dest", new NBTSerializable.Vec());
    public double speed;
    public boolean joinedWorld;
    public boolean dirty = true;
    public boolean dead = false;

    public void moveToDest(Vec3d vec, double speed) {
        this.speed = speed;
        this.dest.set(vec);
        this.dirty = true;
    }

    public void moveTick() {
        if (this.speed == 0.0) {
            return;
        }
        double dx = this.dest.x - this.pos.x;
        double dy = this.dest.y - this.pos.y;
        double dz = this.dest.z - this.pos.z;
        double d = Math.sqrt(dx * dx + dy * dy + dz * dz);
        if (d < this.speed) {
            this.pos.x = this.dest.x;
            this.pos.y = this.dest.y;
            this.pos.z = this.dest.z;
            this.speed = 0.0;
        } else {
            this.pos.x += dx / d * this.speed;
            this.pos.y += dy / d * this.speed;
            this.pos.z += dz / d * this.speed;
        }
    }

    public boolean atDestination() {
        return this.pos.x == this.dest.x && this.pos.y == this.dest.y && this.pos.z == this.dest.z;
    }

    @OverridingMethodsMustInvokeSuper
    public void addToPacket(PacketBuffer buffer) {
        this.pos.writeToPacket(buffer);
        this.dest.writeToPacket(buffer);
        buffer.writeDouble(this.speed);
    }

    @OverridingMethodsMustInvokeSuper
    public void getFromPacket(PacketBuffer buffer) {
        this.pos.readFromPacket(buffer);
        this.dest.readFromPacket(buffer);
        this.speed = buffer.readDouble();
    }

    protected <T extends INBTSerializable> T registerNBT(String key, T t) {
        this.nbtHandlers.put(key, t);
        return t;
    }

    @OverridingMethodsMustInvokeSuper
    public void writeToNBT(NBTTagCompound nbt) {
        for (Map.Entry<String, INBTSerializable> entry2 : this.nbtHandlers.entrySet()) {
            String key = entry2.getKey();
            NBTBase value = entry2.getValue().serializeNBT();
            nbt.func_74782_a(key, value);
        }
        nbt.func_74780_a("speed", this.speed);
    }

    @OverridingMethodsMustInvokeSuper
    public void readFromNBT(NBTTagCompound compound) {
        for (Map.Entry<String, INBTSerializable> entry2 : this.nbtHandlers.entrySet()) {
            NBTBase tag = compound.func_74781_a(entry2.getKey());
            entry2.getValue().deserializeNBT(tag);
        }
        this.speed = compound.func_74769_h("speed");
    }

    public void joinWorld(World world, Vec3d position) {
        this.pos.set(position);
        this.dest.set(position);
        this.dirty = true;
        if (!this.joinedWorld) {
            Fairies.register(world, this);
        }
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.writeToNBT(nbt);
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.readFromNBT(nbt);
    }
}

