/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.fluids;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.rwtema.extrautils2.ExtraUtils2;
import com.rwtema.extrautils2.backend.ClientCallable;
import com.rwtema.extrautils2.utils.datastructures.SidedCacheLoader;
import com.rwtema.extrautils2.utils.helpers.ColorHelper;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class FluidColors {
    public static final LoadingCache<Fluid, Integer> FLUID_COLOR = CacheBuilder.newBuilder().build((CacheLoader)new SidedCacheLoader<Fluid, Integer>(){

        @Override
        @SideOnly(value=Side.SERVER)
        public Integer applyServer(Fluid input) {
            return -1;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public Integer applyClient(Fluid fluid) {
            TextureMap textureMapBlocks = Minecraft.func_71410_x().func_147117_R();
            ResourceLocation fluidStill = fluid.getStill();
            TextureAtlasSprite fluidStillSprite = null;
            if (fluidStill != null) {
                fluidStillSprite = textureMapBlocks.getTextureExtry(fluidStill.toString());
            }
            if (fluidStillSprite == null) {
                return -1;
            }
            if (fluidStillSprite.func_110970_k() == 0) {
                return -1;
            }
            int[][] pixels = fluidStillSprite.func_147965_a(0);
            int pr = 0;
            int pg = 0;
            int pb = 0;
            int pn = 0;
            int[][] nArray = pixels;
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                int[] pixel;
                for (int i2 : pixel = nArray[i]) {
                    if (ColorHelper.getA(i2) < 16) continue;
                    ++pn;
                    pr += ColorHelper.getR(i2);
                    pg += ColorHelper.getG(i2);
                    pb += ColorHelper.getB(i2);
                }
            }
            if (pn == 0) {
                return -1;
            }
            return ColorHelper.color(pr / pn, pg / pn, pb / pn, 255);
        }
    });

    public static int getColor(FluidStack stack) {
        int base_color;
        Fluid fluid;
        if (stack == null || (fluid = stack.getFluid()) == null) {
            return -1;
        }
        int color = fluid.getColor(stack);
        try {
            base_color = (Integer)FLUID_COLOR.get((Object)fluid);
        }
        catch (ExecutionException ignore) {
            FLUID_COLOR.put((Object)fluid, (Object)-1);
            base_color = -1;
        }
        if (color == -1) {
            return base_color;
        }
        float r = ColorHelper.getRF(color) * ColorHelper.getRF(base_color);
        float g = ColorHelper.getGF(color) * ColorHelper.getGF(base_color);
        float b = ColorHelper.getBF(color) * ColorHelper.getBF(base_color);
        return ColorHelper.colorClamp(r, g, b, 1.0f);
    }

    static {
        ExtraUtils2.proxy.run(new ClientCallable(){

            @Override
            @SideOnly(value=Side.CLIENT)
            public void runClient() {
                ((IReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a(new IResourceManagerReloadListener(){

                    public void func_110549_a(@Nonnull IResourceManager resourceManager) {
                        FLUID_COLOR.invalidateAll();
                    }
                });
            }
        });
    }
}

