/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.itemhandler;

import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public abstract class ItemStackHandlerBase
implements IItemHandler,
IItemHandlerModifiable {
    public abstract ItemStack getStack(int var1);

    public abstract void setStack(int var1, ItemStack var2);

    public void setStackInSlot(int slot, ItemStack stack) {
        if (ItemStack.func_77989_b((ItemStack)this.getStack(slot), (ItemStack)stack)) {
            return;
        }
        this.setStack(slot, stack);
        this.onContentsChanged(slot);
    }

    public ItemStack getStackInSlot(int slot) {
        return this.getStack(slot);
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        boolean reachedLimit;
        if (stack == null || stack.field_77994_a == 0) {
            return null;
        }
        ItemStack existing = this.getStack(slot);
        int limit = this.getStackLimit(slot, stack);
        if (existing != null) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)existing)) {
                return stack;
            }
            limit -= existing.field_77994_a;
        }
        if (limit <= 0) {
            return stack;
        }
        boolean bl = reachedLimit = stack.field_77994_a > limit;
        if (!simulate) {
            if (existing == null) {
                this.setStack(slot, reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)limit) : stack);
            } else {
                existing.field_77994_a = existing.field_77994_a + (reachedLimit ? limit : stack.field_77994_a);
            }
            this.onContentsChanged(slot);
        }
        return reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.field_77994_a - limit)) : null;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return null;
        }
        ItemStack existing = this.getStack(slot);
        if (existing == null) {
            return null;
        }
        int toExtract = Math.min(amount, existing.func_77976_d());
        if (existing.field_77994_a <= toExtract) {
            if (!simulate) {
                this.setStack(slot, null);
                this.onContentsChanged(slot);
            }
            return existing;
        }
        if (!simulate) {
            this.setStack(slot, ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)(existing.field_77994_a - toExtract)));
            this.onContentsChanged(slot);
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)toExtract);
    }

    protected int getStackLimit(int slot, ItemStack stack) {
        return stack.func_77976_d();
    }

    protected void onContentsChanged(int slot) {
    }
}

