/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.items;

import com.mojang.realmsclient.gui.ChatFormatting;
import com.rwtema.extrautils2.api.fluids.IFluidFilter;
import com.rwtema.extrautils2.backend.XUItemFlatMetadata;
import com.rwtema.extrautils2.gui.backend.DynamicContainer;
import com.rwtema.extrautils2.gui.backend.IDynamicHandler;
import com.rwtema.extrautils2.gui.backend.IWidget;
import com.rwtema.extrautils2.gui.backend.WidgetClickMCButtonChoices;
import com.rwtema.extrautils2.gui.backend.WidgetSlotGhost;
import com.rwtema.extrautils2.itemhandler.SingleStackHandlerBase;
import com.rwtema.extrautils2.utils.Lang;
import com.rwtema.extrautils2.utils.helpers.CollectionHelper;
import com.rwtema.extrautils2.utils.helpers.NBTHelper;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemFilterFluids
extends XUItemFlatMetadata
implements IFluidFilter,
IDynamicHandler {
    public static final int NUM_SLOTS = 9;
    public static final String NBT_KEY_FLAGS = "Flags";

    public ItemFilterFluids() {
        super("filter_fluid");
    }

    public static boolean getFlag(ItemStack filter, FLAG flag) {
        NBTTagCompound nbt = filter.func_77978_p();
        int i = nbt == null ? 0 : nbt.func_74762_e(NBT_KEY_FLAGS);
        return (i & flag.meta) != 0;
    }

    public static void setFlag(ItemStack filter, FLAG flag, boolean value) {
        if (!value && !filter.func_77942_o()) {
            return;
        }
        NBTTagCompound nbt = NBTHelper.getOrInitTagCompound(filter);
        int flags = nbt.func_74762_e(NBT_KEY_FLAGS);
        flags = value ? (flags ^= flag.meta) : (flags &= ~flag.meta);
        if (flags == 0) {
            nbt.func_82580_o(NBT_KEY_FLAGS);
            if (nbt.func_82582_d()) {
                filter.func_77982_d(null);
            }
        } else if (flags == (byte)flags) {
            nbt.func_74774_a(NBT_KEY_FLAGS, (byte)flags);
        } else {
            nbt.func_74768_a(NBT_KEY_FLAGS, (int)((byte)flags));
        }
    }

    public static ItemStack getGhostStack(ItemStack filter, int i) {
        NBTTagCompound nbt = filter.func_77978_p();
        String stringDigit = CollectionHelper.STRING_DIGITS[i];
        if (nbt == null || !nbt.func_150297_b(stringDigit, 10)) {
            return null;
        }
        return ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l(stringDigit));
    }

    public static void putGhostStack(ItemStack filter, int i, ItemStack result) {
        if (result == null && !filter.func_77942_o()) {
            return;
        }
        NBTTagCompound nbt = NBTHelper.getOrInitTagCompound(filter);
        String stringDigit = CollectionHelper.STRING_DIGITS[i];
        if (result == null) {
            nbt.func_82580_o(stringDigit);
            if (nbt.func_82582_d()) {
                filter.func_77982_d(null);
            }
        } else {
            NBTTagCompound nbtTagCompound = result.serializeNBT();
            nbt.func_74782_a(stringDigit, (NBTBase)nbtTagCompound);
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, @Nonnull ItemStack newStack, boolean slotChanged) {
        return oldStack == null || newStack == null || oldStack.func_77973_b() != this || newStack.func_77973_b() != this;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull ItemStack itemStackIn, World worldIn, EntityPlayer playerIn, EnumHand hand) {
        if (!worldIn.field_72995_K) {
            this.openItemGui(playerIn);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)itemStackIn);
    }

    @Override
    public DynamicContainer getDynamicContainer(int ID2, EntityPlayer player, World world, int x, int y, int z) {
        if (player == null) {
            return null;
        }
        InventoryPlayer inventory = player.field_71071_by;
        int slot = inventory.field_70461_c;
        ItemStack heldItem = player.func_184614_ca();
        if (heldItem == null || heldItem.func_77973_b() != this) {
            return null;
        }
        return new FilterConfigContainer(player, slot, heldItem);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        if (!stack.func_77942_o()) {
            return;
        }
        for (int i = 0; i < 9; ++i) {
            ItemStack ghostStack = ItemFilterFluids.getGhostStack(stack, i);
            if (ghostStack == null) continue;
            List list = ghostStack.func_82840_a(playerIn, false);
            for (int j = 0; j < list.size(); ++j) {
                String s = (String)list.get(j);
                if (j == 0) {
                    tooltip.add(ChatFormatting.GRAY + CollectionHelper.STRING_DIGITS[1 + i] + " -- " + ChatFormatting.WHITE + s);
                    continue;
                }
                tooltip.add(ChatFormatting.GRAY + "      " + s);
            }
        }
        tooltip.add("");
        for (FLAG flag : FLAG.values()) {
            boolean b = ItemFilterFluids.getFlag(stack, flag);
            if (!b) continue;
            tooltip.add(ChatFormatting.BLUE + Lang.translate(flag.name()));
        }
    }

    @Override
    public boolean isFluidFilter(@Nonnull ItemStack filterStack) {
        return true;
    }

    public FluidStack getFluidFromStack(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        Item item = stack.func_77973_b();
        if (item == Items.field_151131_as) {
            return new FluidStack(FluidRegistry.WATER, 1000);
        }
        if (item == Items.field_151129_at) {
            return new FluidStack(FluidRegistry.LAVA, 1000);
        }
        return FluidUtil.getFluidContained((ItemStack)stack);
    }

    @Override
    public boolean matches(@Nonnull ItemStack filterStack, FluidStack target) {
        if (!filterStack.func_77942_o()) {
            return false;
        }
        boolean inverted = ItemFilterFluids.getFlag(filterStack, FLAG.INVERTED);
        if (target == null) {
            return inverted;
        }
        boolean useNBT = !ItemFilterFluids.getFlag(filterStack, FLAG.IGNORE_NBT);
        for (int i = 0; i < 9; ++i) {
            IFluidFilter filter;
            ItemStack ghostStack = ItemFilterFluids.getGhostStack(filterStack, i);
            if (ghostStack == null) continue;
            Item item = ghostStack.func_77973_b();
            if (item instanceof IFluidFilter && (filter = (IFluidFilter)item).matches(ghostStack, target)) {
                return !inverted;
            }
            FluidStack fluid = FluidUtil.getFluidContained((ItemStack)ghostStack);
            if (fluid == null || useNBT && !target.isFluidEqual(fluid) || !useNBT && target.getFluid() != fluid.getFluid()) continue;
            return !inverted;
        }
        return inverted;
    }

    public class FilterConfigContainer
    extends DynamicContainer {
        private final EntityPlayer player;
        private final int slot;
        private final ItemStack heldItem;
        WidgetSlotGhost[] ghostSlots = new WidgetSlotGhost[9];

        public FilterConfigContainer(EntityPlayer player, int slot, final ItemStack heldItem) {
            FLAG[] flagValues;
            this.player = player;
            this.slot = slot;
            this.heldItem = heldItem;
            this.addTitle(Lang.getItemName(ItemFilterFluids.this), false);
            for (int i = 0; i < 9; ++i) {
                int slotX = i % 9;
                int slotY = i / 9;
                final int dSlot = i;
                this.ghostSlots[i] = new WidgetSlotGhost(new SingleStackHandlerBase(){

                    @Override
                    public ItemStack getStack() {
                        return ItemFilterFluids.getGhostStack(heldItem, dSlot);
                    }

                    @Override
                    public void setStack(ItemStack curStack) {
                        ItemFilterFluids.putGhostStack(heldItem, dSlot, curStack);
                    }
                }, dSlot, 5 + slotX * 18, 15 + slotY * 18){

                    @Override
                    public void func_75215_d(ItemStack stack) {
                        FluidStack fluidContained = FluidUtil.getFluidContained((ItemStack)stack);
                        if (fluidContained == null && stack != null && !(stack.func_77973_b() instanceof IFluidFilter)) {
                            return;
                        }
                        super.func_75215_d(stack);
                    }
                };
                this.addWidget(this.ghostSlots[i]);
            }
            this.crop();
            for (final FLAG flag : flagValues = FLAG.values()) {
                int i = flag.ordinal();
                int dx = i % 2;
                int dy = i / 2;
                int x = 5 + dx * this.width / 2;
                int y = this.height + 4 + dy * 18;
                this.addWidget((IWidget)((WidgetClickMCButtonChoices)new WidgetClickMCButtonChoices<Boolean>(x, y){

                    @Override
                    protected void onSelectedServer(Boolean marker) {
                        ItemFilterFluids.setFlag(heldItem, flag, marker);
                    }

                    @Override
                    public Boolean getSelectedValue() {
                        return ItemFilterFluids.getFlag(heldItem, flag);
                    }
                }.addChoice(Boolean.valueOf(false), Lang.translate(flag.OFF_KEY), flag.OFF_KEY)).addChoice((Boolean)true, Lang.translate(flag.ON_KEY), flag.ON_KEY));
            }
            this.cropAndAddPlayerSlots(player.field_71071_by);
            this.validate();
        }

        public boolean func_75145_c(@Nonnull EntityPlayer playerIn) {
            ItemStack heldItem;
            return playerIn == this.player && this.player.field_71071_by.field_70461_c == this.slot && (heldItem = playerIn.func_184614_ca()) != null && heldItem.func_77973_b() == ItemFilterFluids.this;
        }

        @Override
        public ItemStack func_82846_b(EntityPlayer par1EntityPlayer, int par2) {
            Object itemstack = null;
            Slot slot = (Slot)this.field_75151_b.get(par2);
            return super.func_82846_b(par1EntityPlayer, par2);
        }
    }

    static enum FLAG {
        INVERTED,
        IGNORE_NBT;

        public final int meta = 1 << this.ordinal();
        public final String ON_KEY = this.name() + " ON";
        public final String OFF_KEY = this.name() + " OFF";
    }
}

