/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.items;

import com.rwtema.extrautils2.backend.XUItem;
import com.rwtema.extrautils2.backend.model.PassthruModelItem;
import com.rwtema.extrautils2.backend.model.Textures;
import com.rwtema.extrautils2.utils.MCTimer;
import com.rwtema.extrautils2.utils.helpers.QuadHelper;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.Vec3d;

public class ItemKlein
extends XUItem {
    static final double STEM_WIDTH = 0.1;
    static final double STEM_HEIGHT = 0.7;
    static final double LOOP_RADIUS = 0.30000000000000004;
    static final double OFFSET = 0.35;
    static final double OFFSET2 = 0.65;
    static final double OFFSET3 = 0.1;

    public static double getStemRadius(double t) {
        if (t < 0.0) {
            t = (t + 10.0) % 1.0;
        } else if (t > 1.0) {
            t %= 1.0;
        }
        if (t < 0.35) {
            return ItemKlein.getBulbWidth(t / 0.35);
        }
        if (t < 0.44999999999999996) {
            double v = (t - 0.35) / 0.1;
            v = (1.0 + Math.cos(v * Math.PI)) / 2.0;
            return (1.0 - v) * 0.1 + v * ItemKlein.getBulbWidth(1.0);
        }
        if (t > 0.9 && t < 1.0) {
            double v = (t - 0.9) / 0.1;
            if (v > 1.0) {
                v = 1.0;
            }
            v = Math.sqrt(1.0 - v * v);
            return (1.0 - v) * 0.1 + v * ItemKlein.getBulbWidth(0.0);
        }
        return 0.1;
    }

    public static double getBulbWidth(double t) {
        double a = 0.1 + 0.2 * ItemKlein.circle(-1.0 + t * 3.0);
        double v2 = 0.8 * (1.0 - t) + t * 0.1;
        return t * v2 + (1.0 - t) * a;
    }

    public static Vec3d getStemNormal(double t) {
        double y;
        double x;
        boolean isReturning;
        if (t < 0.0) {
            t = (t + 10.0) % 1.0;
        }
        if (t > 1.0) {
            isReturning = true;
            t %= 1.0;
        } else {
            isReturning = false;
        }
        if (t < 0.35) {
            x = -1.0;
            y = 0.0;
        } else if (t < 0.65) {
            double k = (t - 0.35) / 0.30000000000000004 * Math.PI;
            x = -Math.cos(k);
            y = Math.sin(k);
        } else {
            double v;
            double k = (t - 0.65) / 0.35;
            y = -Math.sin(k * Math.PI);
            x = v = 1.0 / Math.sqrt(1.0 + y * y);
            y *= v;
        }
        if (isReturning) {
            x *= -1.0;
            y *= -1.0;
        }
        return new Vec3d(x, y, 0.0);
    }

    public static Vec3d getStemPos(double t) {
        double y;
        double x;
        if (t < 0.0) {
            t = (t + 10.0) % 1.0;
        } else if (t > 1.0) {
            t %= 1.0;
        }
        if (t < 0.35) {
            x = 0.0;
            y = t / 0.35 * 0.7;
        } else if (t < 0.65) {
            double k = (t - 0.35) / 0.30000000000000004 * Math.PI;
            x = 0.30000000000000004 - 0.30000000000000004 * Math.cos(k);
            y = 0.7 + 0.30000000000000004 * Math.sin(k);
        } else {
            double k = (t - 0.65) / 0.35;
            x = 0.30000000000000004 + 0.30000000000000004 * Math.cos(k * Math.PI);
            y = 0.7 * (1.0 - k);
        }
        return new Vec3d(0.34455 + x, -0.05 + y, 0.5);
    }

    public static double circle(double t) {
        if (t < -1.0) {
            return 0.0;
        }
        if (t > 1.0) {
            return 0.0;
        }
        return Math.sqrt(1.0 - t * t);
    }

    public static Vec3d apply(Vec3d a, Vec3d b, dubFunc f) {
        return new Vec3d(f.apply(a.field_72450_a, b.field_72450_a), f.apply(a.field_72448_b, b.field_72448_b), f.apply(a.field_72449_c, b.field_72449_c));
    }

    @Override
    public void registerTextures() {
        Textures.register("klein_lighting");
    }

    @Override
    public TextureAtlasSprite getBaseTexture() {
        return Textures.getSprite("klein_lighting");
    }

    @Override
    public void addQuads(PassthruModelItem.ModelLayer model, ItemStack stack) {
        double time = MCTimer.renderTimer / 30.0f % 2.0f;
        double offset = 0.05;
        int angle_n = 8;
        int height_n = 10;
        double[] ca = new double[8];
        double[] sa = new double[8];
        for (int i = 0; i < 8; ++i) {
            double t = (double)i * Math.PI * 2.0 / 8.0;
            ca[i] = Math.cos(t);
            sa[i] = Math.sin(t);
        }
        TextureAtlasSprite sprite = Textures.sprites.get("klein_lighting");
        double r = 0.55;
        for (int z = -1; z <= 1; z += 2) {
            int i = 0;
            while (z == 1 ? i < 10 : i > -10) {
                double tA = time + 0.05 * (double)i;
                double tB = time + 0.05 * (double)(i + 1);
                Vec3d stemPosA = ItemKlein.getStemPos(tA).func_178786_a(0.5, 0.5, 0.5).func_186678_a(0.55).func_72441_c(0.5, 0.5, 0.5);
                Vec3d stemPosB = ItemKlein.getStemPos(tB).func_178786_a(0.5, 0.5, 0.5).func_186678_a(0.55).func_72441_c(0.5, 0.5, 0.5);
                double radA = ItemKlein.getStemRadius(tA) * 0.55;
                double radB = ItemKlein.getStemRadius(tB) * 0.55;
                Vec3d normA = ItemKlein.getStemNormal(tA);
                Vec3d normB = ItemKlein.getStemNormal(tB);
                for (int j = 0; j < 8; ++j) {
                    int j2 = (j + 1) % 8;
                    float u0 = sprite.func_94214_a(16.0 * (double)j / 8.0);
                    float u1 = sprite.func_94214_a(16.0 * (double)(j + 1) / 8.0);
                    float v0 = sprite.func_94207_b(16.0 * (1.0 + (double)i / 10.0) / 2.0);
                    float v1 = sprite.func_94207_b(16.0 * (1.0 + (double)(i + 1) / 10.0) / 2.0);
                    BakedQuad quad = this.buildQuad(stemPosA.func_178787_e(normA.func_186678_a(radA * ca[j])).func_72441_c(0.0, 0.0, radA * sa[j]), u0, v0, stemPosB.func_178787_e(normB.func_186678_a(radB * ca[j])).func_72441_c(0.0, 0.0, radB * sa[j]), u0, v1, stemPosB.func_178787_e(normB.func_186678_a(radB * ca[j2])).func_72441_c(0.0, 0.0, radB * sa[j2]), u1, v1, stemPosA.func_178787_e(normA.func_186678_a(radA * ca[j2])).func_72441_c(0.0, 0.0, radA * sa[j2]), u1, v0);
                    model.addQuad(quad);
                }
                i += z;
            }
        }
    }

    public BakedQuad buildQuad(Vec3d pos0, float u0, float v0, Vec3d pos1, float u1, float v1, Vec3d pos2, float u2, float v2, Vec3d pos3, float u3, float v3) {
        return QuadHelper.buildBoxQuad(DefaultVertexFormats.field_176599_b, (float)pos0.field_72450_a, (float)pos0.field_72448_b, (float)pos0.field_72449_c, u0, v0, (float)pos1.field_72450_a, (float)pos1.field_72448_b, (float)pos1.field_72449_c, u1, v1, (float)pos2.field_72450_a, (float)pos2.field_72448_b, (float)pos2.field_72449_c, u2, v2, (float)pos3.field_72450_a, (float)pos3.field_72448_b, (float)pos3.field_72449_c, u3, v3);
    }

    @Override
    public int getMaxMetadata() {
        return 0;
    }

    static interface dubFunc {
        public double apply(double var1, double var3);
    }
}

