/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.items;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.rwtema.extrautils2.backend.IXUItem;
import com.rwtema.extrautils2.backend.entries.XU2Entries;
import com.rwtema.extrautils2.backend.model.Box;
import com.rwtema.extrautils2.backend.model.BoxModel;
import com.rwtema.extrautils2.backend.model.PassthruModelItem;
import com.rwtema.extrautils2.backend.model.Textures;
import com.rwtema.extrautils2.backend.model.Transforms;
import com.rwtema.extrautils2.network.NetworkHandler;
import com.rwtema.extrautils2.network.XUPacketServerToClient;
import com.rwtema.extrautils2.utils.Lang;
import com.rwtema.extrautils2.utils.MCTimer;
import com.rwtema.extrautils2.utils.helpers.NBTHelper;
import com.rwtema.extrautils2.utils.helpers.PlayerHelper;
import gnu.trove.set.hash.THashSet;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.vecmath.Matrix4f;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.BaseAttribute;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemLawSword
extends ItemSword
implements IXUItem {
    public static final UUID soulDamageUUID = UUID.fromString("2CCDC290-A885-473A-973F-CDC5C918773B");
    public static final UUID myModifier = UUID.fromString("3D0B4C2D-58EA-439E-83E0-26CFC61D1124");
    public static final Item.ToolMaterial material = EnumHelper.addToolMaterial((String)"Ti-Tema-ian", (int)6, (int)2048, (float)10.0f, (float)10.0f, (int)22);
    public static BaseAttribute godSlayingDamage = new RangedAttribute(null, "extrautils2.godSlayingAttackDamage", 0.0, 0.0, Double.MAX_VALUE);
    public static BaseAttribute armorPiercingDamage = new RangedAttribute(null, "extrautils2.armorPiercingAttackDamage", 0.0, 0.0, Double.MAX_VALUE);
    public static BaseAttribute soulDamage = new RangedAttribute(null, "extrautils2.soulDamage", 0.0, 0.0, Double.MAX_VALUE);
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite sprite;
    private BoxModel sword;

    public ItemLawSword() {
        super(material);
        EventHandlerSword handler = new EventHandlerSword(this);
        MinecraftForge.EVENT_BUS.register((Object)handler);
        this.func_77625_d(1);
        this.func_77656_e(0);
    }

    @Nonnull
    public Multimap<String, AttributeModifier> func_111205_h(EntityEquipmentSlot equipmentSlot) {
        Multimap multimap = super.func_111205_h(equipmentSlot);
        if (equipmentSlot == EntityEquipmentSlot.MAINHAND) {
            multimap.put((Object)armorPiercingDamage.func_111108_a(), (Object)new AttributeModifier(Item.field_111210_e, "Weapon modifier", 3.0, 0));
            multimap.put((Object)godSlayingDamage.func_111108_a(), (Object)new AttributeModifier(Item.field_111210_e, "Weapon modifier", 2.0, 0));
            multimap.put((Object)soulDamage.func_111108_a(), (Object)new AttributeModifier(myModifier, "Weapon modifier", 0.2564102564102564, 0));
        }
        return multimap;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        super.func_77624_a(stack, playerIn, tooltip, advanced);
        tooltip.add(Lang.translate("Cursed Sword"));
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, @Nonnull EntityLivingBase attacker) {
        boolean flag;
        if (target == null || !target.func_70075_an()) {
            return false;
        }
        if (attacker.field_70170_p.field_72995_K) {
            return false;
        }
        if (!(attacker instanceof EntityPlayer)) {
            return false;
        }
        double[] m = new double[]{target.field_70159_w, target.field_70181_x, target.field_70179_y};
        Multimap multimap = stack.func_111283_C(EntityEquipmentSlot.MAINHAND);
        boolean bl = flag = !target.func_180431_b(DamageSource.field_82728_o);
        if (target instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)target;
            if (player.field_71075_bZ.field_75098_d) {
                flag = false;
            }
            if (!PlayerHelper.isPlayerReal(player)) {
                flag = false;
            }
        }
        if (flag) {
            this.drainHealth(target);
        }
        this.attack(stack, target, (Multimap<String, AttributeModifier>)multimap, godSlayingDamage, (DamageSource)new DamageSourceDivine((Entity)attacker, true), attacker);
        this.attack(stack, target, (Multimap<String, AttributeModifier>)multimap, armorPiercingDamage, (DamageSource)new DamageSourceArmorBypass((Entity)attacker), attacker);
        target.field_70159_w = m[0];
        target.field_70181_x = m[1];
        target.field_70179_y = m[2];
        target.field_70133_I = true;
        return false;
    }

    private void drainHealth(EntityLivingBase target) {
        double l = 0.0;
        IAttributeInstance a = target.func_110140_aT().func_111152_a(SharedMonsterAttributes.field_111267_a.func_111108_a());
        AttributeModifier attr = a.func_111127_a(soulDamageUUID);
        if (attr != null && (l = attr.func_111164_d()) == -1.0) {
            return;
        }
        if ((l -= 0.025641025975346565) < -1.0) {
            l = -1.0;
        }
        HashMultimap multimap = HashMultimap.create();
        multimap.put((Object)SharedMonsterAttributes.field_111267_a.func_111108_a(), (Object)new AttributeModifier(soulDamageUUID, "Soul Damage", l, 2));
        target.func_110140_aT().func_111147_b((Multimap)multimap);
        if (l <= -1.0) {
            target.func_70097_a(DamageSource.field_76380_i, Float.MAX_VALUE);
        }
    }

    public void attack(ItemStack stack, EntityLivingBase target, Multimap<String, AttributeModifier> multimap, BaseAttribute attribute, DamageSource source, EntityLivingBase attacker) {
        float amount = this.getAmount(stack, target, multimap, attribute);
        if (amount > 0.0f) {
            target.field_70172_ad = 0;
            target.func_70097_a(source, amount *= ((EntityPlayer)attacker).func_184825_o(0.0f));
        }
    }

    public float getAmount(ItemStack stack, EntityLivingBase target, Multimap<String, AttributeModifier> multimap, BaseAttribute attribute) {
        float amount = 0.0f;
        Collection gsd = multimap.get((Object)attribute.func_111108_a());
        if (gsd != null) {
            for (AttributeModifier t : gsd) {
                float d0 = (float)t.func_111164_d();
                if (t.func_111167_a() == Item.field_111210_e) {
                    d0 = (float)((double)d0 + (double)EnchantmentHelper.func_152377_a((ItemStack)stack, (EnumCreatureAttribute)target.func_70668_bt()));
                }
                amount += d0;
            }
        }
        return amount;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerTextures() {
        Textures.register("rwtema_blade");
    }

    @Override
    public void clearCaches() {
        this.sword = null;
        this.sprite = null;
    }

    @Override
    public boolean allowOverride() {
        return false;
    }

    @Override
    public int getMaxMetadata() {
        return 0;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void postTextureRegister() {
        this.sprite = Textures.sprites.get("rwtema_blade");
    }

    @Override
    public boolean renderAsTool() {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getBaseTexture() {
        return this.sprite;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addQuads(PassthruModelItem.ModelLayer model, ItemStack stack) {
        if (this.sword == null) {
            float sc = 0.5f;
            float[] handleUV = new float[]{0.0f, 0.0f, 5.0f * sc, 16.0f * sc};
            float[] handleBottomUV = new float[]{9.0f * sc, 21.0f * sc, 14.0f * sc, 26.0f * sc};
            float[] fuzzTopUV = new float[]{5.0f * sc, 0.0f, 18.0f * sc, 13.0f * sc};
            float[] fuzzSideUV = new float[]{5.0f * sc, 13.0f * sc, 18.0f * sc, 17.0f * sc};
            float[] fuzzBottomUV = new float[]{5.0f * sc, 17.0f * sc, 18.0f * sc, 30.0f * sc};
            float[] swordUV1 = new float[]{0.0f * sc, 16.0f * sc, 4.0f * sc, 32.0f * sc};
            float[] swordUV2 = new float[]{18.0f * sc, 0.0f * sc, 22.0f * sc, 32.0f * sc};
            float[] swordUV3 = new float[]{24.0f * sc, 0.0f * sc, 28.0f * sc, 16.0f * sc};
            float r = 0.029761905f;
            float dy = -0.25f;
            BoxModel sword = new BoxModel();
            float s = 0.001953125f;
            sword.add(new Box(0.5f - 2.5f * r, dy, 0.5f - 2.5f * r, 0.5f + 2.5f * r, dy + 16.0f * r, 0.5f + 2.5f * r).setTexture("rwtema_blade").setTextureBounds(new float[][]{handleBottomUV, handleBottomUV, handleUV, handleUV, handleUV, handleUV}).setInvisible(2));
            sword.add(new Box(0.5f - 6.5f * r, dy + 16.0f * r, 0.5f - 6.5f * r, 0.5f + 6.5f * r, dy + 20.0f * r, 0.5f + 6.5f * r).setTexture("rwtema_blade").setTextureBounds(new float[][]{fuzzBottomUV, fuzzTopUV, fuzzSideUV, fuzzSideUV, fuzzSideUV, fuzzSideUV}));
            sword.add(new Box(0.5f - s, dy + 20.0f * r, 0.5f - 2.0f * r, 0.5f + s, dy + 36.0f * r, 0.5f + 2.0f * r).setTexture("rwtema_blade").setTextureBounds(new float[][]{null, null, swordUV1, swordUV1, swordUV1, swordUV1}).setInvisible(15).setFlipU(4));
            sword.add(new Box(0.5f - s, dy + 36.0f * r, 0.5f - 2.0f * r, 0.5f + s, dy + 68.0f * r, 0.5f + 2.0f * r).setTexture("rwtema_blade").setTextureBounds(new float[][]{null, null, swordUV2, swordUV2, swordUV2, swordUV2}).setInvisible(15).setFlipU(4));
            sword.add(new Box(0.5f - s, dy + 68.0f * r, 0.5f - 2.0f * r, 0.5f + s, dy + 84.0f * r, 0.5f + 2.0f * r).setTexture("rwtema_blade").setTextureBounds(new float[][]{null, null, swordUV3, swordUV3, swordUV3, swordUV3}).setInvisible(15).setFlipU(4));
            this.sword = sword;
        }
        model.clear();
        model.isGui3D = true;
        model.tex = this.sprite;
        model.addBoxModel(this.sword);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IBakedModel createModel(int metadata) {
        EnumMap<ItemCameraTransforms.TransformType, Matrix4f> enumMap = new EnumMap<ItemCameraTransforms.TransformType, Matrix4f>(Transforms.blockTransforms);
        for (ItemCameraTransforms.TransformType type : ItemCameraTransforms.TransformType.values()) {
            Matrix4f matrix4f = Transforms.itemTransforms.get(type);
            if (matrix4f == null) continue;
            enumMap.put(type, matrix4f);
        }
        return new PassthruModelItem((IXUItem)this, enumMap);
    }

    public void func_77663_a(ItemStack itemstack, World world, Entity entity, int slot, boolean selected) {
        if (world.field_72995_K) {
            return;
        }
        if (!(entity instanceof EntityPlayerMP)) {
            return;
        }
        NBTTagCompound nbt = NBTHelper.getPersistantNBT(entity);
        nbt.func_74774_a("XU|Sword", (byte)20);
        EntityPlayerMP entityPlayerMP = (EntityPlayerMP)entity;
        EventHandlerSword.addPlayer((EntityPlayer)entityPlayerMP, !nbt.func_74764_b("XU|SwordDim") || nbt.func_74762_e("XU|SwordDim") != world.field_73011_w.getDimension());
        nbt.func_74768_a("XU|SwordDim", world.field_73011_w.getDimension());
    }

    public boolean func_77616_k(@Nonnull ItemStack stack) {
        return true;
    }

    @NetworkHandler.XUPacket
    public static class PacketLawSwordNotifier
    extends XUPacketServerToClient {
        String username;
        boolean swordPresent;

        public PacketLawSwordNotifier() {
        }

        public PacketLawSwordNotifier(String player, boolean swordPresent) {
            this.username = player;
            this.swordPresent = swordPresent;
        }

        @Override
        public void writeData() throws Exception {
            this.writeString(this.username);
            this.data.writeBoolean(this.swordPresent);
        }

        @Override
        public void readData(EntityPlayer player) {
            this.username = this.readString();
            this.swordPresent = this.data.readBoolean();
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public Runnable doStuffClient() {
            return new Runnable(){

                @Override
                public void run() {
                    if (swordPresent) {
                        EventHandlerSword.clientLawSwords.add((Object)username);
                    } else {
                        EventHandlerSword.clientLawSwords.remove((Object)username);
                    }
                }
            };
        }
    }

    public static class EventHandlerSword {
        public static THashSet<String> serverLawSwords = new THashSet(5, 0.5f);
        public static THashSet<String> clientLawSwords = new THashSet(5, 0.5f);
        private final ItemLawSword itemLawSword;

        public EventHandlerSword(ItemLawSword itemLawSword) {
            this.itemLawSword = itemLawSword;
        }

        public static void addPlayer(EntityPlayer player, boolean b) {
            String name = player.func_146103_bH().getName();
            if (!serverLawSwords.contains((Object)name) || b) {
                serverLawSwords.add((Object)name);
                NetworkHandler.sendToAllPlayers(new PacketLawSwordNotifier(name, true));
            }
        }

        public static void removePlayer(EntityPlayer player) {
            String name = player.func_146103_bH().getName();
            if (serverLawSwords.contains((Object)name)) {
                serverLawSwords.remove((Object)name);
                NetworkHandler.sendToAllPlayers(new PacketLawSwordNotifier(name, false));
            }
        }

        @SubscribeEvent
        public void anvil(AnvilUpdateEvent event) {
            ItemStack left = event.getLeft();
            ItemStack right = event.getRight();
            if (left == null || left.func_77973_b() != this.itemLawSword || right == null) {
                return;
            }
            Item item = right.func_77973_b();
            if (item != this.itemLawSword && item != Items.field_151134_bR) {
                return;
            }
            Map map1 = EnchantmentHelper.func_82781_a((ItemStack)left);
            Map map2 = EnchantmentHelper.func_82781_a((ItemStack)right);
            HashMap map3 = new HashMap(map1);
            for (Map.Entry entry2 : map2.entrySet()) {
                Enchantment enchantment = (Enchantment)entry2.getKey();
                if (enchantment == null) continue;
                Integer integer = (Integer)map1.get(entry2.getKey());
                if (integer == null) {
                    map3.put(entry2.getKey(), entry2.getValue());
                    continue;
                }
                int value = Math.min(integer + (Integer)entry2.getValue(), enchantment.func_77325_b() * 2);
                map3.put(entry2.getKey(), value);
            }
            int cost = 0;
            for (Integer integer : map3.values()) {
                cost += integer.intValue();
            }
            event.setCost(cost);
            ItemStack copy = left.func_77946_l();
            event.setOutput(copy);
            EnchantmentHelper.func_82782_a(map3, (ItemStack)copy);
        }

        @SubscribeEvent
        public void playerLogin(PlayerEvent.PlayerLoggedInEvent event) {
            if (PlayerHelper.isThisPlayerACheatyBastardOfCheatBastardness(event.player)) {
                InventoryPlayer inventory = event.player.field_71071_by;
                int j = -1;
                for (int i = 0; i < 36; ++i) {
                    ItemStack stack = inventory.func_70301_a(i);
                    if (stack == null) {
                        if (j != -1) continue;
                        j = i;
                        continue;
                    }
                    if (!(stack.func_77973_b() instanceof ItemLawSword)) continue;
                    j = -1;
                    break;
                }
                if (j != -1) {
                    inventory.func_70299_a(j, XU2Entries.lawSword.newStack());
                }
            }
            for (String name : FMLCommonHandler.instance().getMinecraftServerInstance().func_71213_z()) {
                NetworkHandler.sendPacketToPlayer(new PacketLawSwordNotifier(name, serverLawSwords.contains((Object)name)), event.player);
            }
        }

        @SubscribeEvent
        public void entTick(LivingEvent.LivingUpdateEvent event) {
            Byte t;
            IAttributeInstance a;
            AttributeModifier attr;
            if (event.getEntity().field_70170_p.field_72995_K) {
                return;
            }
            if (MCTimer.serverTimer % 200 == 0 && (attr = (a = event.getEntityLiving().func_110140_aT().func_111152_a(SharedMonsterAttributes.field_111267_a.func_111108_a())).func_111127_a(soulDamageUUID)) != null) {
                double l = attr.func_111164_d();
                l = ((double)Math.round(l * 39.0) + 1.0) / 39.0;
                a.func_111124_b(attr);
                if (l < 0.0) {
                    a.func_111121_a(new AttributeModifier(soulDamageUUID, "Soul Damage", l, 2));
                }
            }
            Entity entity = event.getEntity();
            NBTTagCompound tagCompound = NBTHelper.getPersistantNBT(entity);
            if (!NBTHelper.hasPersistantNBT(entity) || !tagCompound.func_150297_b("XU|Sword", 1)) {
                return;
            }
            Byte by = t = Byte.valueOf(tagCompound.func_74771_c("XU|Sword"));
            Byte by2 = t = Byte.valueOf((byte)(t - 1));
            if (t == 0) {
                tagCompound.func_82580_o("XU|Sword");
                if (entity instanceof EntityPlayerMP) {
                    EntityPlayerMP entityPlayer = (EntityPlayerMP)entity;
                    EventHandlerSword.removePlayer((EntityPlayer)entityPlayer);
                    if (!entityPlayer.field_71075_bZ.field_75098_d) {
                        entityPlayer.field_71075_bZ.field_75101_c = false;
                        entityPlayer.field_71075_bZ.field_75100_b = false;
                        entityPlayer.func_71016_p();
                    }
                }
            } else {
                tagCompound.func_74774_a("XU|Sword", t.byteValue());
            }
        }

        public void renderPlayer(RenderPlayerEvent.Pre event) {
        }
    }

    public static class DamageSourceDivine
    extends EntityDamageSource {
        public DamageSourceDivine(Entity entity, boolean creative) {
            super("player", entity);
            this.func_76348_h();
            this.func_151518_m();
            this.func_76359_i();
        }
    }

    public static class DamageSourceArmorBypass
    extends EntityDamageSource {
        public DamageSourceArmorBypass(Entity entity) {
            super("player", entity);
            this.func_76348_h();
            this.func_151518_m();
        }
    }
}

