/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.machine;

import cofh.api.energy.IEnergyProvider;
import com.rwtema.extrautils2.machine.TileMachine;
import com.rwtema.extrautils2.power.energy.PublicEnergyWrapper;
import com.rwtema.extrautils2.transfernodes.Upgrade;
import com.rwtema.extrautils2.utils.CapGetter;
import java.util.LinkedHashSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.IEnergyStorage;

public class TileMachineProvider
extends TileMachine
implements IEnergyProvider {
    PublicEnergyWrapper.Extract extract;

    public TileMachineProvider() {
        this.extract = new PublicEnergyWrapper.Extract((IEnergyStorage)this.storage);
    }

    @Override
    public int extractEnergy(EnumFacing from, int maxExtract, boolean simulate) {
        return this.storage.extractEnergy(maxExtract, simulate);
    }

    @Override
    public void process() {
        this.sendEnergy();
        if (!this.active) {
            this.setInactive();
            return;
        }
        if (this.totalTime > 0) {
            int n = 1 + this.upgrades.getLevel(Upgrade.SPEED);
            int energyAtTime1 = (int)((float)this.energyOutput * (float)this.processTime / (float)this.totalTime);
            int energyAtTime2 = (int)((float)this.energyOutput * (float)Math.min(this.totalTime, this.processTime + n) / (float)this.totalTime);
            if (!this.processEnergy(energyAtTime2 - energyAtTime1)) {
                this.setInactive();
                return;
            }
            this.setActive();
            this.processTime += n;
            if (this.processTime >= this.totalTime) {
                this.processTime = 0;
                this.totalTime = 0;
                this.energyOutput = 0;
            }
        } else {
            this.processRecipeInput();
            if (this.curRecipe == null) {
                this.setInactive();
                return;
            }
            this.totalTime = this.curRecipe.getProcessingTime(this.itemInputMap, this.fluidInputMap);
            this.energyOutput = this.curRecipe.getEnergyOutput(this.itemInputMap, this.fluidInputMap);
            this.processTime = 0;
            if (this.totalTime == 0 && !this.processEnergy(this.energyOutput)) {
                this.setInactive();
                return;
            }
            this.setActive();
            this.consumeInputs();
        }
    }

    @Override
    @Nullable
    public IEnergyStorage getEnergyHandler(EnumFacing facing) {
        return this.machine != null ? this.extract : null;
    }

    public void sendEnergy() {
        if (this.storage.getEnergyStored() <= 0) {
            return;
        }
        int maxSend = Math.min(80 * (1 + this.upgrades.getLevel(Upgrade.SPEED)), this.storage.getEnergyStored());
        if (maxSend <= 0) {
            return;
        }
        LinkedHashSet<IEnergyStorage> receivers = new LinkedHashSet<IEnergyStorage>();
        for (EnumFacing facing : EnumFacing.values()) {
            IEnergyStorage storage;
            TileEntity tileEntity = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing));
            if (tileEntity == null || (storage = CapGetter.energyReceiver.getInterface((ICapabilityProvider)tileEntity, facing.func_176734_d())) == null) continue;
            receivers.add(storage);
        }
        if (receivers.isEmpty()) {
            return;
        }
        int toSend = maxSend / receivers.size();
        if (toSend > 0) {
            for (IEnergyStorage receiver : receivers) {
                int energy = receiver.receiveEnergy(toSend, false);
                this.storage.modifyEnergyStored(-energy);
                if ((maxSend -= energy) > 0) continue;
                break;
            }
        }
        for (IEnergyStorage receiver : receivers) {
            int energy = receiver.receiveEnergy(maxSend, false);
            this.storage.modifyEnergyStored(-energy);
            if ((maxSend -= energy) > 0) continue;
            break;
        }
        this.func_70296_d();
    }

    protected boolean processEnergy(int amount) {
        if (this.storage.receiveEnergy(amount, true) != amount) {
            return false;
        }
        this.storage.receiveEnergy(amount, false);
        return true;
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        NBTTagCompound nbt = super.func_189515_b(compound);
        nbt.func_74768_a("TotalTime", this.totalTime);
        nbt.func_74768_a("EnergyOutput", this.energyOutput);
        return nbt;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.totalTime = nbt.func_74762_e("TotalTime");
        this.energyOutput = nbt.func_74762_e("EnergyOutput");
    }
}

