/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.power;

import com.rwtema.extrautils2.backend.XUBlock;
import com.rwtema.extrautils2.backend.entries.BlockEntry;
import com.rwtema.extrautils2.backend.entries.Entry;
import com.rwtema.extrautils2.backend.entries.EntryHandler;
import com.rwtema.extrautils2.hud.HUDHandler;
import com.rwtema.extrautils2.network.NetworkHandler;
import com.rwtema.extrautils2.power.IPower;
import com.rwtema.extrautils2.power.PacketPowerInfo;
import com.rwtema.extrautils2.utils.Lang;
import com.rwtema.extrautils2.utils.helpers.StringHelper;
import java.util.HashSet;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.client.GuiIngameForge;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ClientPower
implements HUDHandler.IHudHandler {
    private static final HashSet<Item> powerItems = new HashSet();
    static float powerCreated;
    static float powerDrained;
    static BlockPos currentPosition;
    static float currentPositionEnergy;

    public static void init() {
    }

    public static String powerStatusString() {
        return Lang.translatePrefix("Grid Power:") + " " + StringHelper.niceFormat(powerDrained) + " / " + StringHelper.niceFormat(powerCreated);
    }

    public static boolean isPowered() {
        return powerDrained <= powerCreated;
    }

    public static boolean hasNoPower() {
        return powerDrained == 0.0f && powerCreated == 0.0f;
    }

    @SubscribeEvent
    public void clientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        RayTraceResult mop = Minecraft.func_71410_x().field_71476_x;
        if (mop == null || mop.field_72313_a != RayTraceResult.Type.BLOCK) {
            currentPosition = null;
            currentPositionEnergy = Float.NaN;
        } else {
            if (currentPosition != null && !currentPosition.equals((Object)mop.func_178782_a())) {
                currentPositionEnergy = Float.NaN;
            }
            currentPosition = mop.func_178782_a();
            WorldClient theWorld = Minecraft.func_71410_x().field_71441_e;
            if (theWorld != null) {
                TileEntity tileEntity = theWorld.func_175625_s(mop.func_178782_a());
                if (tileEntity instanceof IPower) {
                    NetworkHandler.sendPacketToServer(new PacketPowerInfo(currentPositionEnergy, currentPosition));
                } else {
                    currentPositionEnergy = Float.NaN;
                    currentPosition = null;
                }
            }
        }
    }

    @Override
    public void render(GuiIngameForge hud, ScaledResolution resolution, float partialTicks) {
        boolean flag = currentPosition != null;
        EntityPlayerSP thePlayer = Minecraft.func_71410_x().field_71439_g;
        if (!flag && thePlayer != null && thePlayer.func_184614_ca() != null && powerItems.contains(thePlayer.func_184614_ca().func_77973_b())) {
            flag = true;
        }
        if (!flag) {
            return;
        }
        int y = resolution.func_78328_b() * 7 / 10;
        hud.func_73732_a(hud.func_175179_f(), ClientPower.powerStatusString(), resolution.func_78326_a() / 2, y, -1);
        if (!Float.isNaN(currentPositionEnergy)) {
            String text = currentPositionEnergy == 0.0f ? Lang.translatePrefix("No Power Used/Generated") : (currentPositionEnergy < 0.0f ? Lang.translatePrefix("Power Generating:") + " " + StringHelper.niceFormat(-currentPositionEnergy) : Lang.translatePrefix("Power Drain:") + " " + StringHelper.niceFormat(currentPositionEnergy));
            hud.func_73732_a(hud.func_175179_f(), text, resolution.func_78326_a() / 2, y += hud.func_175179_f().field_78288_b + 1, -1);
        }
    }

    static {
        for (Entry entry2 : EntryHandler.entries) {
            if (!(entry2 instanceof BlockEntry) || !entry2.enabled) continue;
            for (Class<? extends TileEntity> clazz : ((BlockEntry)entry2).teClazzes) {
                if (!IPower.class.isAssignableFrom(clazz)) continue;
                powerItems.add((Item)((XUBlock)((Object)entry2.value)).itemBlock);
            }
        }
        ClientPower handler = new ClientPower();
        MinecraftForge.EVENT_BUS.register((Object)handler);
        HUDHandler.register(handler);
    }
}

