/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.power;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.rwtema.extrautils2.power.IPower;
import com.rwtema.extrautils2.power.IWorldPowerMultiplier;
import com.rwtema.extrautils2.power.PowerManager;
import com.rwtema.extrautils2.power.PowerMultipliers;
import com.rwtema.extrautils2.power.PowerSettings;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.map.hash.TObjectFloatHashMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.util.INBTSerializable;

public class UnloadedChunkPower
implements INBTSerializable<NBTTagList> {
    static BiMap<String, IWorldPowerMultiplier> passiveRegistry = HashBiMap.create();
    static BiMap<IWorldPowerMultiplier, String> passiveRegistryInv = passiveRegistry.inverse();
    public TIntObjectHashMap<FreqData> freqs = new TIntObjectHashMap();
    boolean dirty = true;

    public void rebuild() {
        this.freqs.retainEntries((a, b) -> {
            b.clearLoadedChunks();
            return !b.isEmpty();
        });
        PowerManager instance = PowerManager.instance;
        for (IPower powerHandler : instance.assignedValues.keySet()) {
            float power;
            IWorldPowerMultiplier multiplier;
            if (!powerHandler.isLoaded()) continue;
            World world = powerHandler.world();
            BlockPos location = powerHandler.getLocation();
            if (world == null || location == null || !passiveRegistryInv.containsKey((Object)(multiplier = powerHandler.getMultiplier())) || (power = powerHandler.getPower()) == 0.0f || Float.isNaN(power)) continue;
            int frequency = powerHandler.frequency();
            FreqData freqData = (FreqData)this.freqs.get(frequency);
            if (freqData == null) {
                freqData = new FreqData();
                this.freqs.put(frequency, (Object)freqData);
            }
            freqData.addPowerEntry(world, location, multiplier, power);
        }
        PowerSettings.instance.markDirty();
    }

    public NBTTagList serializeNBT() {
        NBTTagList freqList = new NBTTagList();
        this.freqs.forEachEntry((a, b) -> {
            NBTTagCompound freqData = new NBTTagCompound();
            freqData.func_74768_a("Freq", a);
            freqData.func_74782_a("Data", (NBTBase)b.serializeNBT());
            freqList.func_74742_a((NBTBase)freqData);
            return true;
        });
        return freqList;
    }

    public void deserializeNBT(NBTTagList nbt) {
        this.freqs.clear();
        for (int i = 0; i < nbt.func_74745_c(); ++i) {
            NBTTagCompound freqData = nbt.func_150305_b(i);
            int freq = freqData.func_74762_e("Freq");
            FreqData data = new FreqData();
            data.deserializeNBT(freqData.func_74775_l("Data"));
            this.freqs.put(freq, (Object)data);
        }
    }

    static {
        passiveRegistry.put((Object)"Constant", (Object)IWorldPowerMultiplier.CONSTANT);
        passiveRegistry.put((Object)"Solar", (Object)PowerMultipliers.SOLAR);
        passiveRegistry.put((Object)"Lunar", (Object)PowerMultipliers.LUNAR);
        passiveRegistry.put((Object)"Wind", (Object)PowerMultipliers.WIND);
    }

    public static class FreqData
    implements INBTSerializable<NBTTagCompound> {
        TIntObjectHashMap<HashMap<ChunkPos, TObjectFloatHashMap<IWorldPowerMultiplier>>> worldChunkDataCreators = new TIntObjectHashMap();
        TIntObjectHashMap<HashMap<ChunkPos, TObjectFloatHashMap<IWorldPowerMultiplier>>> worldChunkDataDrainers = new TIntObjectHashMap();
        private TIntObjectHashMap<TObjectFloatHashMap<IWorldPowerMultiplier>> unloadedPowerCreators = new TIntObjectHashMap();
        private TIntObjectHashMap<TObjectFloatHashMap<IWorldPowerMultiplier>> unloadedPowerDrainers = new TIntObjectHashMap();

        public float getPowerCreated() {
            return this.getPower(this.unloadedPowerCreators);
        }

        public float getPowerDrained() {
            return this.getPower(this.unloadedPowerDrainers);
        }

        public float getPower(TIntObjectHashMap<TObjectFloatHashMap<IWorldPowerMultiplier>> unloadedPowerMap) {
            float t = 0.0f;
            for (int dim : unloadedPowerMap.keys()) {
                TObjectFloatHashMap map = (TObjectFloatHashMap)unloadedPowerMap.get(dim);
                WorldServer world = DimensionManager.getWorld((int)dim);
                if (world == null) {
                    if (!map.containsKey((Object)IWorldPowerMultiplier.CONSTANT)) continue;
                    t += map.get((Object)IWorldPowerMultiplier.CONSTANT);
                    continue;
                }
                for (IWorldPowerMultiplier multiplier : map.keySet()) {
                    t += multiplier.multiplier((World)world) * map.get((Object)multiplier);
                }
            }
            return t;
        }

        public void clearLoadedChunks() {
            this.unload(this.worldChunkDataCreators, this.unloadedPowerCreators);
            this.unload(this.worldChunkDataDrainers, this.unloadedPowerDrainers);
        }

        public void unload(TIntObjectHashMap<HashMap<ChunkPos, TObjectFloatHashMap<IWorldPowerMultiplier>>> worldChunkData, TIntObjectHashMap<TObjectFloatHashMap<IWorldPowerMultiplier>> unloadedPower) {
            unloadedPower.clear();
            worldChunkData.retainEntries((dimension, chunkMap) -> {
                WorldServer world = DimensionManager.getWorld((int)dimension);
                if (world == null) {
                    return true;
                }
                ChunkProviderServer chunkProvider = world.func_72863_F();
                Iterator iterator = chunkMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry2 = iterator.next();
                    ChunkPos key = (ChunkPos)entry2.getKey();
                    TObjectFloatHashMap powerMap = (TObjectFloatHashMap)entry2.getValue();
                    long l = ChunkPos.func_77272_a((int)key.field_77276_a, (int)key.field_77275_b);
                    if (chunkProvider.field_73244_f.containsKey(l)) {
                        iterator.remove();
                        continue;
                    }
                    powerMap.forEachEntry((a, b) -> {
                        TObjectFloatHashMap worldMap = (TObjectFloatHashMap)unloadedPower.get(dimension);
                        if (worldMap == null) {
                            worldMap = new TObjectFloatHashMap();
                            unloadedPower.put(dimension, (Object)worldMap);
                        }
                        worldMap.adjustOrPutValue(a, b, b);
                        return true;
                    });
                }
                return !chunkMap.isEmpty();
            });
        }

        public boolean isEmpty() {
            return this.worldChunkDataCreators.isEmpty() && this.worldChunkDataDrainers.isEmpty();
        }

        public void addPowerEntry(World world, BlockPos location, IWorldPowerMultiplier multiplier, float power) {
            TIntObjectHashMap<HashMap<ChunkPos, TObjectFloatHashMap<IWorldPowerMultiplier>>> worldChunkData;
            int dim = world.field_73011_w.getDimension();
            ChunkPos pos = new ChunkPos(location);
            if (power == 0.0f || Float.isNaN(power)) {
                return;
            }
            if (power < 0.0f) {
                power *= -1.0f;
                worldChunkData = this.worldChunkDataCreators;
            } else {
                worldChunkData = this.worldChunkDataDrainers;
            }
            HashMap<ChunkPos, TObjectFloatHashMap> chunkMap = (HashMap<ChunkPos, TObjectFloatHashMap>)worldChunkData.get(dim);
            if (chunkMap == null) {
                chunkMap = new HashMap<ChunkPos, TObjectFloatHashMap>();
                worldChunkData.put(dim, chunkMap);
            }
            TObjectFloatHashMap powers = chunkMap.computeIfAbsent(pos, chunkPos -> new TObjectFloatHashMap());
            powers.adjustOrPutValue((Object)multiplier, power, power);
        }

        public NBTTagCompound serializeNBT() {
            NBTTagCompound data = new NBTTagCompound();
            data.func_74782_a("Creators", (NBTBase)this.serializeList(this.worldChunkDataCreators));
            data.func_74782_a("Drainers", (NBTBase)this.serializeList(this.worldChunkDataDrainers));
            return data;
        }

        @Nonnull
        public NBTTagList serializeList(TIntObjectHashMap<HashMap<ChunkPos, TObjectFloatHashMap<IWorldPowerMultiplier>>> worldChunkDataCreators) {
            NBTTagList worldList = new NBTTagList();
            worldChunkDataCreators.forEachEntry((dimension, chunkMap) -> {
                NBTTagCompound worldData = new NBTTagCompound();
                NBTTagList chunkList = new NBTTagList();
                chunkMap.forEach((chunkCoord, powerMap) -> {
                    NBTTagCompound chunkData = new NBTTagCompound();
                    chunkData.func_74768_a("CoordX", chunkCoord.field_77276_a);
                    chunkData.func_74768_a("CoordZ", chunkCoord.field_77275_b);
                    for (IWorldPowerMultiplier multiplier : powerMap.keySet()) {
                        String s = (String)passiveRegistryInv.get((Object)multiplier);
                        chunkData.func_74776_a(s, powerMap.get((Object)multiplier));
                    }
                    chunkList.func_74742_a((NBTBase)chunkData);
                });
                worldData.func_74782_a("Chunks", (NBTBase)chunkList);
                worldData.func_74768_a("Dim", dimension);
                worldList.func_74742_a((NBTBase)worldData);
                return true;
            });
            return worldList;
        }

        public void deserializeNBT(NBTTagCompound nbt) {
            this.deserialize(nbt, "Creators", this.worldChunkDataCreators);
            this.deserialize(nbt, "Drainers", this.worldChunkDataDrainers);
        }

        public void deserialize(NBTTagCompound nbt, String creators, TIntObjectHashMap<HashMap<ChunkPos, TObjectFloatHashMap<IWorldPowerMultiplier>>> worldChunkData) {
            worldChunkData.clear();
            NBTTagList worldList = nbt.func_150295_c(creators, 10);
            for (int i = 0; i < worldList.func_74745_c(); ++i) {
                NBTTagCompound worldData = worldList.func_150305_b(i);
                int dim = worldData.func_74762_e("Dim");
                NBTTagList chunkList = worldData.func_150295_c("Chunks", 10);
                HashMap<ChunkPos, TObjectFloatHashMap> chunkMap = new HashMap<ChunkPos, TObjectFloatHashMap>();
                for (int j = 0; j < chunkList.func_74745_c(); ++j) {
                    NBTTagCompound chunkData = chunkList.func_150305_b(j);
                    TObjectFloatHashMap multipliers = new TObjectFloatHashMap();
                    for (Map.Entry entry2 : passiveRegistry.entrySet()) {
                        if (!chunkData.func_74764_b((String)entry2.getKey())) continue;
                        multipliers.put(entry2.getValue(), chunkData.func_74760_g((String)entry2.getKey()));
                    }
                    ChunkPos coord = new ChunkPos(chunkData.func_74762_e("CoordX"), chunkData.func_74762_e("CoordZ"));
                    chunkMap.put(coord, multipliers);
                }
                worldChunkData.put(dim, chunkMap);
            }
        }
    }
}

