/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.power.energy;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.rwtema.extrautils2.power.PowerManager;
import com.rwtema.extrautils2.power.energy.TilePowerBattery;
import com.rwtema.extrautils2.power.energy.TilePowerTransmitter;
import com.rwtema.extrautils2.utils.CapGetter;
import com.rwtema.extrautils2.utils.datastructures.WeakLinkedSet;
import gnu.trove.iterator.TIntObjectIterator;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class EnergyTransfer {
    public static final ResourceLocation ENERGY_SYSTEM_STORAGE_KEY = new ResourceLocation("ExtraUtils2", "EnergySystemStorage");
    public static final Collection<ResourceLocation> ENERGY_SYSTEM_STORAGE = ImmutableList.of((Object)ENERGY_SYSTEM_STORAGE_KEY);
    public static final ResourceLocation ENERGY_SYSTEM_TRANSMITTER_KEY = new ResourceLocation("ExtraUtils2", "EnergySystemTransmitters");
    public static final Collection<ResourceLocation> ENERGY_SYSTEM_TRANSMITTERS = ImmutableList.of((Object)ENERGY_SYSTEM_TRANSMITTER_KEY);
    public static final int MAX_TRANSFER = 80;
    public static final int REBUILD_TIME = 100;
    public static int tick = 0;
    static final EnumFacing[] sidesPlusNull = new EnumFacing[]{null, EnumFacing.DOWN, EnumFacing.UP, EnumFacing.NORTH, EnumFacing.SOUTH, EnumFacing.WEST, EnumFacing.EAST};

    public static void init() {
        MinecraftForge.EVENT_BUS.register(EnergyTransfer.class);
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        if (++tick >= 100) {
            tick = 0;
        }
        TIntObjectIterator iterator = PowerManager.instance.frequencyHolders.iterator();
        while (iterator.hasNext()) {
            TilePowerBattery storage;
            Object storage22;
            Collection transmitters;
            Collection storages;
            iterator.advance();
            PowerManager.PowerFreq freq = (PowerManager.PowerFreq)iterator.value();
            if (!freq.isPowered() || (storages = freq.getSubTypes(ENERGY_SYSTEM_STORAGE_KEY)) == null || storages.isEmpty() || (transmitters = freq.getSubTypes(ENERGY_SYSTEM_TRANSMITTER_KEY)) == null || transmitters.isEmpty()) continue;
            int totalEnergyAvailable = 0;
            for (Object storage22 : storages) {
                if (storage22.func_145837_r()) continue;
                totalEnergyAvailable += ((TilePowerBattery)storage22).energy.getEnergyStored();
            }
            if (totalEnergyAvailable == 0) continue;
            HashMultimap targets = HashMultimap.create();
            storage22 = transmitters.iterator();
            while (storage22.hasNext()) {
                List<BlockPos> targetList;
                World world;
                TilePowerTransmitter transmitter = (TilePowerTransmitter)storage22.next();
                if (transmitter.func_145837_r() || (world = transmitter.func_145831_w()) == null || (targetList = transmitter.getTargets(tick == 0)) == null) continue;
                targets.putAll((Object)world, targetList);
            }
            if (targets.isEmpty()) continue;
            WeakLinkedSet<IEnergyStorage> receivers = new WeakLinkedSet<IEnergyStorage>();
            for (World world : targets.keySet()) {
                Set blockPoses = targets.get((Object)world);
                block4: for (BlockPos pos : blockPoses) {
                    TileEntity tile;
                    if (!world.func_175667_e(pos) || !EnergyTransfer.isValidOutput(tile = world.func_175625_s(pos))) continue;
                    for (EnumFacing facing : sidesPlusNull) {
                        IEnergyStorage storage3 = CapGetter.energyReceiver.getInterface((ICapabilityProvider)tile, facing);
                        if (storage3 == null) continue;
                        receivers.add(storage3);
                        if (facing == null) continue block4;
                    }
                }
            }
            if (receivers.isEmpty()) {
                return;
            }
            EnumFacing[] facings = EnumFacing.values();
            int transfer = Math.min(80, totalEnergyAvailable) / receivers.size();
            int toExtract = EnergyTransfer.sendPower(totalEnergyAvailable, receivers, facings, transfer);
            if (receivers.size() > 1) {
                toExtract += EnergyTransfer.sendPower(totalEnergyAvailable - toExtract, receivers, facings, 80 - transfer);
            }
            Iterator<Object> iterator2 = storages.iterator();
            while (iterator2.hasNext() && ((storage = (TilePowerBattery)iterator2.next()).func_145837_r() || (toExtract -= storage.energy.extractEnergy(toExtract, false)) != 0)) {
            }
        }
    }

    private static int sendPower(int totalEnergyAvailable, Collection<IEnergyStorage> receivers, EnumFacing[] facings, int maxTransfer) {
        int sentPower = 0;
        for (IEnergyStorage receiver : receivers) {
            if (totalEnergyAvailable <= 0) break;
            int sendAvailable = Math.min(maxTransfer, totalEnergyAvailable);
            if (sendAvailable <= 0 || !receiver.canReceive()) continue;
            int i = receiver.receiveEnergy(sendAvailable, false);
            totalEnergyAvailable -= i;
            sentPower += i;
        }
        return sentPower;
    }

    public static boolean isValidOutput(TileEntity tile) {
        return !(tile instanceof TilePowerBattery) && CapGetter.energyReceiver.hasInterface((ICapabilityProvider)tile, null);
    }
}

