/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.quarry;

import com.google.common.collect.ComparisonChain;
import com.rwtema.extrautils2.fairies.Fairy;
import com.rwtema.extrautils2.itemhandler.XUTileItemStackHandler;
import com.rwtema.extrautils2.tile.XUTile;
import com.rwtema.extrautils2.utils.PositionPool;
import com.rwtema.extrautils2.utils.datastructures.NBTSerializable;
import com.rwtema.extrautils2.utils.helpers.BlockStates;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.ItemStackHandler;

public class TileQuarryConvoluted
extends XUTile
implements ITickable {
    static final EnumFacing[][] sidePriority = new EnumFacing[][]{{EnumFacing.NORTH, EnumFacing.WEST, EnumFacing.SOUTH, EnumFacing.EAST}, {EnumFacing.WEST, EnumFacing.SOUTH, EnumFacing.EAST, EnumFacing.NORTH}, {EnumFacing.SOUTH, EnumFacing.EAST, EnumFacing.NORTH, EnumFacing.WEST}, {EnumFacing.EAST, EnumFacing.NORTH, EnumFacing.WEST, EnumFacing.SOUTH}};
    final PositionPool pool = new PositionPool();
    final Digger[] diggers;
    final Limits limits = this.registerNBT("limits", new Limits());
    int curLevel = 0;
    boolean initialized;
    ItemStackHandler tools = new XUTileItemStackHandler(9, this){

        protected int getStackLimit(int slot, ItemStack stack) {
            return super.getStackLimit(slot, stack);
        }
    };
    NBTSerializable.NBTCollection<ChunkPos, Set<ChunkPos>, NBTTagLong> deadChunks = this.registerNBT("captured_chunks", new NBTSerializable.NBTCollection(new HashSet(), chunkPos -> new NBTTagLong((long)chunkPos.field_77276_a << 32 | (long)chunkPos.field_77275_b & 0xFFFFFFFFL), nbtTagLong -> {
        long c = nbtTagLong.func_150291_c();
        return new ChunkPos((int)(c >> 32), (int)c);
    }));

    public TileQuarryConvoluted() {
        this.diggers = new Digger[32];
        for (int i = 0; i < this.diggers.length; ++i) {
            this.diggers[i] = this.registerNBT("digger_i", new Digger(i));
        }
    }

    public Block getSludgeBlock() {
        return Blocks.field_150347_e;
    }

    public void func_73660_a() {
        long l;
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.limits.isBlank()) {
            this.limits.x_min = Math.min(this.field_174879_c.func_177958_n() + 1, this.field_174879_c.func_177958_n() + 96);
            this.limits.x_max = Math.max(this.field_174879_c.func_177958_n() + 1, this.field_174879_c.func_177958_n() + 96);
            this.limits.z_min = Math.min(this.field_174879_c.func_177952_p() + 1, this.field_174879_c.func_177952_p() + 96);
            this.limits.z_max = Math.max(this.field_174879_c.func_177952_p() + 1, this.field_174879_c.func_177952_p() + 96);
            this.limits.roof = this.field_174879_c.func_177956_o();
            for (Digger digger : this.diggers) {
                digger.active.value = true;
                this.findGoodChunk(digger);
            }
        }
        if (!this.initialized) {
            for (Digger digger : this.diggers) {
                digger.joinWorld(this.field_145850_b, new Vec3d((Vec3i)this.field_174879_c).func_72441_c(0.5, 0.5, 0.5));
            }
            this.initialized = true;
        }
        if ((l = this.field_145850_b.func_82737_E() % 20L) == 0L) {
            this.pool.clear();
        }
        for (int i = 0; i < 100; ++i) {
            for (Digger digger : this.diggers) {
                if (digger.active.value) {
                    if (digger.atDestination()) {
                        if (!this.dig(digger)) continue;
                        digger.digTime.value = 0;
                        this.findNextDest(digger);
                        if (digger.dead) continue;
                        double curDist = digger.target.func_177954_c(digger.pos.x, digger.pos.y, digger.pos.z);
                        for (Digger digger1 : this.diggers) {
                            double newDistOther;
                            if (!digger.active.value) continue;
                            double curDistOther = digger1.target.func_177954_c(digger1.pos.x, digger1.pos.y, digger1.pos.z);
                            double newDist = digger.target.func_177954_c(digger1.pos.x, digger1.pos.y, digger1.pos.z);
                            if (!(newDist + (newDistOther = digger1.target.func_177954_c(digger.pos.x, digger.pos.y, digger.pos.z)) < curDist + curDistOther)) continue;
                            BlockPos t = digger1.target.func_185334_h();
                            digger1.target.func_189533_g((Vec3i)digger.target);
                            digger.target.func_189533_g((Vec3i)t);
                            curDist = digger.target.func_177954_c(digger.pos.x, digger.pos.y, digger.pos.z);
                        }
                        continue;
                    }
                    digger.moveTick();
                    continue;
                }
                digger.dead = true;
            }
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        for (Digger digger : this.diggers) {
            digger.dead = true;
        }
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        for (Digger digger : this.diggers) {
            digger.dead = true;
        }
    }

    private void findNextDest(Digger digger) {
        int z;
        int x;
        NBTSerializable.NBTMutableBlockPos target = digger.target;
        int y = target.func_177956_o();
        if (!this.findDiggableBlockInChunk(digger, y, x = target.func_177958_n(), z = target.func_177952_p())) {
            ((Set)this.deadChunks.collection).add(new ChunkPos(x >> 4, z >> 4));
            this.findGoodChunk(digger);
        }
    }

    private boolean findDiggableBlockInChunk(Digger digger, int y, int x, int z) {
        HashSet<BlockPos> blacklist = new HashSet<BlockPos>();
        for (Digger digger1 : this.diggers) {
            if (digger == digger1 || !digger1.active.value) continue;
            blacklist.add((BlockPos)digger1.target);
        }
        Chunk chunk = this.field_145850_b.func_72964_e(x >> 4, z >> 4);
        ExtendedBlockStorage[] array = chunk.func_76587_i();
        while (y >= 0) {
            ExtendedBlockStorage storage = array[y >> 4];
            if (storage != Chunk.field_186036_a && !storage.func_76663_a()) {
                if (this.findDiggableBlockInChunkRow(digger, x, y, z, blacklist)) {
                    return true;
                }
                --y;
                continue;
            }
            y = (y >> 4 << 4) - 1;
        }
        return false;
    }

    private void findGoodChunk(Digger digger) {
        final TObjectIntHashMap currentlyAssigned = new TObjectIntHashMap(10, 0.5f, 0);
        ArrayList<ChunkPos> pos = new ArrayList<ChunkPos>();
        for (int x = this.limits.x_min >> 4; x <= this.limits.x_max >> 4; ++x) {
            for (int z = this.limits.z_min >> 4; z <= this.limits.z_max >> 4; ++z) {
                ChunkPos e = new ChunkPos(x, z);
                if (((Set)this.deadChunks.collection).contains(e)) continue;
                pos.add(e);
            }
        }
        for (Digger digger1 : this.diggers) {
            if (digger1 == digger || !digger1.active.value) continue;
            currentlyAssigned.adjustOrPutValue((Object)new ChunkPos((BlockPos)digger1.target), 1, 1);
        }
        Collections.shuffle(pos);
        TreeSet<ChunkPos> orderedSet = new TreeSet<ChunkPos>(new Comparator<ChunkPos>(){

            @Override
            public int compare(ChunkPos o1, ChunkPos o2) {
                return ComparisonChain.start().compare(currentlyAssigned.get((Object)o1), currentlyAssigned.get((Object)o2)).compare(this.getSuitability(o1), this.getSuitability(o2)).result();
            }

            private int getSuitability(ChunkPos o1) {
                return Math.abs(o1.field_77276_a + 8 - TileQuarryConvoluted.this.limits.centerX()) * 8 + Math.abs(o1.field_77275_b + 8 - TileQuarryConvoluted.this.limits.centerZ()) * 8;
            }
        });
        orderedSet.addAll(pos);
        for (ChunkPos p : orderedSet) {
            BlockPos centerBlock = p.func_180619_a(this.limits.roof);
            if (this.findDiggableBlockInChunk(digger, centerBlock.func_177956_o(), MathHelper.func_76125_a((int)centerBlock.func_177958_n(), (int)this.limits.x_min, (int)this.limits.x_max), MathHelper.func_76125_a((int)centerBlock.func_177952_p(), (int)this.limits.z_min, (int)this.limits.z_max))) {
                return;
            }
            ((Set)this.deadChunks.collection).add(p);
        }
        digger.active.value = false;
        digger.dead = true;
    }

    private boolean findDiggableBlockInChunkRow(Digger digger, int x, int y, int z, Set<BlockPos> blacklist) {
        BlockPos t;
        BlockPos.MutableBlockPos test = new BlockPos.MutableBlockPos();
        for (EnumFacing facing : sidePriority[this.field_145850_b.field_73012_v.nextInt(4)]) {
            float hardness;
            int x2 = x + facing.func_82601_c();
            int z2 = z + facing.func_82599_e();
            if (x2 >> 4 != x >> 4 || z2 >> 4 != z >> 4 || !this.limits.contains(x2, y, z2)) continue;
            test.func_181079_c(x2, y, z2);
            if (blacklist.contains(test)) continue;
            IBlockState state = this.field_145850_b.func_180495_p((BlockPos)test);
            if (!this.checkIsValid((BlockPos)test, state = state.func_185899_b((IBlockAccess)this.field_145850_b, this.field_174879_c)) || !((hardness = state.func_185887_b(this.field_145850_b, this.field_174879_c)) >= 0.0f)) continue;
            digger.setTarget((BlockPos)test);
            return true;
        }
        LinkedList<BlockPos> toTest = new LinkedList<BlockPos>();
        HashSet<BlockPos> testedPositions = new HashSet<BlockPos>();
        toTest.add(this.pool.getPos(x, y, z));
        while ((t = (BlockPos)toTest.pollFirst()) != null) {
            testedPositions.add(t);
            for (EnumFacing facing : sidePriority[this.field_145850_b.field_73012_v.nextInt(4)]) {
                BlockPos offset = this.pool.offset(t, facing);
                if (offset.func_177958_n() >> 4 != t.func_177958_n() >> 4 || offset.func_177952_p() >> 4 != t.func_177952_p() >> 4 || !this.limits.contains(offset.func_177958_n(), y, offset.func_177952_p())) continue;
                if (!blacklist.contains(offset)) {
                    float hardness;
                    IBlockState state = this.field_145850_b.func_180495_p(offset);
                    if (this.checkIsValid(offset, state = state.func_185899_b((IBlockAccess)this.field_145850_b, this.field_174879_c)) && (hardness = state.func_185887_b(this.field_145850_b, this.field_174879_c)) >= 0.0f) {
                        digger.setTarget(offset);
                        return true;
                    }
                }
                if (testedPositions.contains(offset)) continue;
                testedPositions.add(offset);
                toTest.add(offset);
            }
        }
        return false;
    }

    private boolean checkIsValid(BlockPos offset, IBlockState state) {
        Block block;
        return state != BlockStates.AIR && !state.func_177230_c().isAir(state, (IBlockAccess)this.field_145850_b, offset) && (block = state.func_177230_c()) != this.getSludgeBlock() && (!state.func_185904_a().func_76224_d() || this.limits.isOnBorder(offset.func_177958_n(), offset.func_177952_p()) && this.isLiquidJustOutside(offset));
    }

    private boolean isLiquidJustOutside(BlockPos target) {
        for (EnumFacing facing : EnumFacing.field_176754_o) {
            BlockPos offset = this.pool.offset(target, facing);
            if (!this.field_145850_b.func_180495_p(offset).func_185904_a().func_76224_d() || !this.limits.isJustOutsideBorder(offset.func_177958_n(), offset.func_177952_p()) || this.field_145850_b.func_180495_p(offset.func_177984_a()).func_185904_a().func_76224_d()) continue;
            return true;
        }
        return false;
    }

    private boolean dig(Digger digger) {
        BlockPos offset;
        NBTSerializable.NBTMutableBlockPos target = digger.target;
        IBlockState state = this.field_145850_b.func_180495_p((BlockPos)target);
        if (!this.checkIsValid((BlockPos)target, state)) {
            return true;
        }
        int digTime = digger.digTime.value++;
        float hardness = state.func_185887_b(this.field_145850_b, (BlockPos)target);
        if (hardness < -1.0f) {
            return true;
        }
        if (state.func_185904_a().func_76224_d()) {
            if (this.limits.isOnBorder(target.func_177958_n(), target.func_177952_p())) {
                for (EnumFacing facing : EnumFacing.field_176754_o) {
                    BlockPos offset2 = this.pool.offset((BlockPos)target, facing);
                    if (!this.field_145850_b.func_180495_p(offset2).func_185904_a().func_76224_d() || !this.limits.isJustOutsideBorder(offset2.func_177958_n(), offset2.func_177952_p()) || this.field_145850_b.func_180495_p(offset2.func_177984_a()).func_185904_a().func_76224_d()) continue;
                    this.field_145850_b.func_175656_a(offset2, Blocks.field_150347_e.func_176223_P());
                }
                BlockPos up = this.pool.offset((BlockPos)target, EnumFacing.UP);
                if (this.field_145850_b.func_180495_p(up).func_185904_a().func_76224_d()) {
                    for (EnumFacing facing : EnumFacing.field_176754_o) {
                        BlockPos offset3 = this.pool.offset(up, facing);
                        if (!this.field_145850_b.func_175623_d(offset3)) continue;
                        this.field_145850_b.func_175656_a(offset3, this.getSludgeBlock().func_176223_P());
                    }
                } else {
                    this.field_145850_b.func_175656_a((BlockPos)target, this.getSludgeBlock().func_176223_P());
                }
            }
            return true;
        }
        if (hardness * 10.0f > (float)digTime) {
            return false;
        }
        boolean flag = true;
        BlockPos up = this.pool.offset((BlockPos)target, EnumFacing.UP);
        if (this.field_145850_b.func_180495_p(up).func_185904_a().func_76224_d()) {
            flag = false;
            for (EnumFacing facing : EnumFacing.field_176754_o) {
                offset = this.pool.offset(up, facing);
                if (!this.field_145850_b.func_175623_d(offset)) continue;
                this.field_145850_b.func_175656_a(offset, this.getSludgeBlock().func_176223_P());
            }
        }
        if (flag) {
            for (EnumFacing facing : EnumFacing.field_176754_o) {
                offset = this.pool.offset((BlockPos)target, facing);
                if (!this.field_145850_b.func_180495_p(offset).func_185904_a().func_76224_d()) continue;
                if (this.limits.isJustOutsideBorder(offset.func_177958_n(), offset.func_177952_p()) && !this.field_145850_b.func_180495_p(offset.func_177984_a()).func_185904_a().func_76224_d()) {
                    this.field_145850_b.func_175656_a(offset, Blocks.field_150347_e.func_176223_P());
                    continue;
                }
                flag = false;
                break;
            }
        }
        if (flag) {
            this.field_145850_b.func_175698_g((BlockPos)target);
        } else {
            this.field_145850_b.func_175656_a((BlockPos)target, this.getSludgeBlock().func_176223_P());
        }
        digger.digTime.value = 0;
        return true;
    }

    public class Limits
    implements INBTSerializable<NBTTagIntArray> {
        int x_min;
        int x_max;
        int z_min;
        int z_max;
        int roof;

        public void setLimits(int x_min, int x_max, int z_min, int z_max, int roof) {
            this.x_min = Math.min(x_min, x_max);
            this.x_max = Math.max(x_min, x_max);
            this.z_min = Math.min(z_min, z_max);
            this.z_max = Math.max(z_min, z_max);
            this.roof = roof;
        }

        public NBTTagIntArray serializeNBT() {
            return new NBTTagIntArray(new int[]{this.x_min, this.x_max, this.z_min, this.z_max, this.roof});
        }

        public void deserializeNBT(NBTTagIntArray nbt) {
            int[] ints = nbt.func_150302_c();
            this.x_min = ints[0];
            this.x_max = ints[1];
            this.z_min = ints[2];
            this.z_max = ints[3];
            this.roof = ints[4];
        }

        public boolean isBlank() {
            return this.x_max == this.x_min && this.roof == 0 && this.z_max == this.z_min;
        }

        public boolean isJustOutsideBorder(int x, int z) {
            return x == this.x_min - 1 || z == this.z_min - 1 || x == this.x_max + 1 || z == this.z_max + 1;
        }

        public boolean isOnBorder(int x, int z) {
            return x == this.x_min || z == this.z_min || x == this.x_max || z == this.z_max;
        }

        public boolean contains(int x, int y, int z) {
            return x >= this.x_min && x <= this.x_max && z >= this.z_min && z <= this.z_max && y >= 0 && y <= this.roof;
        }

        public int centerX() {
            return (this.x_max + this.x_min) / 2;
        }

        public int centerZ() {
            return (this.z_max + this.z_min) / 2;
        }
    }

    public class Digger
    extends Fairy {
        final int index;
        NBTSerializable.NBTBoolean active = this.registerNBT("active", new NBTSerializable.NBTBoolean(false));
        NBTSerializable.NBTMutableBlockPos target = this.registerNBT("target", new NBTSerializable.NBTMutableBlockPos());
        NBTSerializable.Int digTime = this.registerNBT("digging_time", new NBTSerializable.Int());

        public Digger(int index) {
            this.index = index;
        }

        public void setTarget(BlockPos targetPos) {
            this.target.func_189533_g((Vec3i)targetPos);
            Vec3d dest = new Vec3d((Vec3i)targetPos).func_72441_c(0.5, 1.0, 0.5);
            double dx = this.pos.x - dest.field_72450_a;
            double dy = this.pos.y - dest.field_72448_b;
            double dz = this.pos.z - dest.field_72449_c;
            double d = Math.sqrt(dx * dx + dy * dy + dz * dz);
            if (d > 1.2) {
                double d_inv = 1.2 / d;
                dx *= d_inv;
                dy *= d_inv;
                dz *= d_inv;
            }
            dest.func_72441_c(dx, dy, dz);
            this.moveToDest(dest.func_72441_c(0.5, 1.5, 0.5), 0.05);
            this.digTime.value = 0;
        }
    }
}

