/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.tile;

import com.mojang.authlib.GameProfile;
import com.rwtema.extrautils2.backend.IMetaProperty;
import com.rwtema.extrautils2.backend.XUBlock;
import com.rwtema.extrautils2.gui.backend.IDynamicHandler;
import com.rwtema.extrautils2.network.PacketBuffer;
import com.rwtema.extrautils2.network.SpecialChat;
import com.rwtema.extrautils2.power.Freq;
import com.rwtema.extrautils2.power.IPower;
import com.rwtema.extrautils2.power.IWorldPowerMultiplier;
import com.rwtema.extrautils2.power.PowerManager;
import com.rwtema.extrautils2.tile.XUTile;
import com.rwtema.extrautils2.utils.Lang;
import com.rwtema.extrautils2.utils.helpers.NBTHelper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;

public abstract class TilePower
extends XUTile
implements IPower {
    public static final String NBT_FREQUENCY = "Frequency";
    public static final String NBT_OWNER = "Owner";
    public static final String NBT_ACTIVE = "Active";
    public static final int FREQUENCY_CREATIVE = 1337;
    public static final IMetaProperty<Boolean> ENABLED_STATE = new IMetaProperty.WrapTile<Boolean, TilePower>(TilePower.class, (IProperty)PropertyBool.func_177716_a((String)"active")){

        @Override
        public Boolean getValue(TilePower tile) {
            return tile.active;
        }
    };
    public int frequency;
    public boolean active;
    protected GameProfile owner;

    @Override
    public World world() {
        return this.func_145831_w();
    }

    @Override
    public int frequency() {
        return this.frequency;
    }

    @Override
    public void powerChanged(boolean powered) {
        if (this.active != powered) {
            this.active = powered;
            this.func_70296_d();
            this.onPowerChanged();
        }
    }

    public abstract void onPowerChanged();

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a(NBT_FREQUENCY, this.frequency);
        compound.func_74757_a(NBT_ACTIVE, this.active);
        if (this.owner != null) {
            compound.func_74782_a(NBT_OWNER, (NBTBase)NBTHelper.proifleToNBT(this.owner));
        }
        return compound;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.frequency = compound.func_74762_e(NBT_FREQUENCY);
        this.active = compound.func_74767_n(NBT_ACTIVE);
        this.owner = NBTHelper.profileFromNBT(compound.func_74775_l(NBT_OWNER));
    }

    @Override
    public void onBlockPlacedBy(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack, XUBlock xuBlock) {
        if (!this.field_145850_b.field_72995_K && placer instanceof EntityPlayerMP) {
            this.frequency = Freq.getBasePlayerFreq((EntityPlayerMP)placer);
        }
    }

    @Override
    public IWorldPowerMultiplier getMultiplier() {
        return IWorldPowerMultiplier.CONSTANT;
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (!this.field_145850_b.field_72995_K) {
            PowerManager.instance.removePowerHandler(this);
        }
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        if (!this.field_145850_b.field_72995_K) {
            PowerManager.instance.removePowerHandler(this);
        }
    }

    public void onLoad() {
        if (!this.field_145850_b.field_72995_K) {
            PowerManager.instance.addPowerHandler(this);
        }
    }

    public boolean isValidPlayer(EntityPlayer playerIn) {
        return PowerManager.canUse(playerIn, this);
    }

    @Override
    public void addToDescriptionPacket(PacketBuffer packet) {
        super.addToDescriptionPacket(packet);
        packet.writeBoolean(this.active);
    }

    @Override
    public void handleDescriptionPacket(PacketBuffer packet) {
        super.handleDescriptionPacket(packet);
        this.active = packet.readBoolean();
    }

    @Override
    @Nonnull
    public String getName() {
        return this.getBlockState().getUnlocalizedName();
    }

    @Override
    public boolean onBlockActivated(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (this instanceof IDynamicHandler) {
            if (!worldIn.field_72995_K) {
                if (PowerManager.canUse(playerIn, this)) {
                    this.openGUI(playerIn);
                } else {
                    SpecialChat.sendChat(playerIn, (ITextComponent)Lang.chat("Access Denied. Use command /%s to try to ally with the owner.", "xu_powersharing"));
                }
            }
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public BlockPos getLocation() {
        return this.func_174877_v();
    }
}

