/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.tile;

import com.rwtema.extrautils2.gui.backend.DynamicContainer;
import com.rwtema.extrautils2.gui.backend.DynamicContainerTile;
import com.rwtema.extrautils2.gui.backend.IDynamicHandler;
import com.rwtema.extrautils2.gui.backend.WidgetProgressArrow;
import com.rwtema.extrautils2.gui.backend.WidgetSlotItemHandler;
import com.rwtema.extrautils2.gui.backend.WidgetTextData;
import com.rwtema.extrautils2.itemhandler.ConcatItemHandler;
import com.rwtema.extrautils2.itemhandler.PublicWrapper;
import com.rwtema.extrautils2.itemhandler.SingleStackHandler;
import com.rwtema.extrautils2.itemhandler.SingleStackHandlerUpgrades;
import com.rwtema.extrautils2.network.PacketBuffer;
import com.rwtema.extrautils2.power.IWorldPowerMultiplier;
import com.rwtema.extrautils2.power.PowerManager;
import com.rwtema.extrautils2.tile.TilePower;
import com.rwtema.extrautils2.transfernodes.Upgrade;
import com.rwtema.extrautils2.utils.Lang;
import com.rwtema.extrautils2.utils.helpers.CollectionHelper;
import com.rwtema.extrautils2.utils.helpers.NBTHelper;
import com.rwtema.extrautils2.utils.helpers.StringHelper;
import gnu.trove.set.hash.TCustomHashSet;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.oredict.OreDictionary;

public class TileResonator
extends TilePower
implements ITickable,
IWorldPowerMultiplier,
IDynamicHandler {
    public static final ArrayList<ResonatorRecipe> resonatorRecipes = new ArrayList();
    public final float MULTIPLIER = 0.01f;
    public SingleStackHandlerUpgrades upgrades = this.registerNBT("upgrades", new SingleStackHandlerUpgrades(EnumSet.of(Upgrade.SPEED)){

        @Override
        protected void onContentsChanged() {
            TileResonator.this.func_70296_d();
            PowerManager.instance.markDirty(TileResonator.this);
        }
    });
    ResonatorRecipe currentRecipe = null;
    int progress = 0;
    ItemStack displayStack;
    private ItemStackHandler INPUT = new ItemStackHandler(){

        protected void onContentsChanged(int slot) {
            TileResonator.this.onInputChanged();
        }

        protected int getStackLimit(int slot, ItemStack stack) {
            if (stack == null || !ResonatorRecipe.WildCardItems.contains(stack.func_77973_b()) && !ResonatorRecipe.SpecificItems.contains((Object)stack)) {
                return 0;
            }
            return super.getStackLimit(slot, stack);
        }
    };
    private SingleStackHandler OUTPUT = new SingleStackHandler(){

        @Override
        protected void onContentsChanged() {
            TileResonator.this.onInputChanged();
        }
    };
    private IItemHandler handler = ConcatItemHandler.concatNonNull(new PublicWrapper.Insert((IItemHandler)this.INPUT), new PublicWrapper.Extract((IItemHandler)this.OUTPUT));

    public static void register(ItemStack input, ItemStack output, int energy) {
        TileResonator.register(input, output, energy, false);
    }

    public static void register(ItemStack input, ItemStack output, int energy, boolean addOwnerTag) {
        resonatorRecipes.add(new ResonatorRecipe(input, output, energy, addOwnerTag));
        if (input.func_77952_i() == Short.MAX_VALUE || !input.func_77981_g()) {
            ResonatorRecipe.WildCardItems.add(input.func_77973_b());
        } else {
            ResonatorRecipe.SpecificItems.add((Object)new ItemStack(input.func_77973_b(), 1, input.func_77952_i()));
        }
    }

    @Override
    public IItemHandler getItemHandler(EnumFacing facing) {
        return this.handler;
    }

    private void onInputChanged() {
        this.currentRecipe = this.getPotentialOutput();
        this.func_70296_d();
        if (this.currentRecipe == null) {
            this.progress = 0;
            return;
        }
        if (!this.OUTPUT.isEmpty() && this.OUTPUT.insertItem(0, this.getOutputStack(), true) != null) {
            this.currentRecipe = null;
            this.progress = 0;
        }
    }

    public ResonatorRecipe getPotentialOutput() {
        ItemStack input = this.INPUT.getStackInSlot(0);
        if (input != null) {
            for (ResonatorRecipe resonatorRecipe : resonatorRecipes) {
                if (!OreDictionary.itemMatches((ItemStack)resonatorRecipe.input, (ItemStack)input, (boolean)false) || resonatorRecipe.input.field_77994_a > input.field_77994_a) continue;
                return resonatorRecipe;
            }
        }
        return null;
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K || !this.active || this.currentRecipe == null) {
            return;
        }
        this.progress += 4 * (1 + this.upgrades.getLevel(Upgrade.SPEED));
        this.func_70296_d();
        if (this.progress >= this.currentRecipe.energy) {
            ItemStack stack = this.getOutputStack();
            this.INPUT.extractItem(0, this.currentRecipe.input.field_77994_a, false);
            this.OUTPUT.insertItem(0, stack, false);
            this.progress = 0;
        }
    }

    private ItemStack getOutputStack() {
        ItemStack stack = this.currentRecipe.output.func_77946_l();
        if (this.currentRecipe.addOwnerTag) {
            NBTHelper.getOrInitTagCompound(stack).func_74768_a("Freq", this.frequency);
        }
        return stack;
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74782_a("Input", (NBTBase)this.INPUT.serializeNBT());
        compound.func_74782_a("Output", (NBTBase)this.OUTPUT.serializeNBT());
        compound.func_74768_a("Progress", this.progress);
        return compound;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.INPUT.deserializeNBT(compound.func_74775_l("Input"));
        this.OUTPUT.deserializeNBT(compound.func_74775_l("Output"));
        this.progress = compound.func_74762_e("Progress");
        this.onInputChanged();
    }

    @Override
    public void onPowerChanged() {
    }

    @Override
    public float getPower() {
        return 1.0f;
    }

    @Override
    public IWorldPowerMultiplier getMultiplier() {
        return this;
    }

    @Override
    public float multiplier(World world) {
        int level = this.upgrades.getLevel(Upgrade.SPEED);
        if (level == 0) {
            return (float)this.progress * 0.01f;
        }
        return (float)this.progress * 0.01f * (float)(1 + level) + Upgrade.SPEED.getPowerUse(level);
    }

    @Override
    public DynamicContainer getDynamicContainer(int ID2, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerResonator(player.field_71071_by);
    }

    @Override
    public void addToDescriptionPacket(PacketBuffer packet) {
        super.addToDescriptionPacket(packet);
        ResonatorRecipe recipe = this.getPotentialOutput();
        ItemStack outStack = recipe != null ? recipe.output : null;
        packet.writeItemStack(outStack);
    }

    @Override
    public void handleDescriptionPacket(PacketBuffer packet) {
        super.handleDescriptionPacket(packet);
        this.displayStack = packet.readItemStack();
    }

    public class ContainerResonator
    extends DynamicContainerTile {
        public ContainerResonator(InventoryPlayer inventory) {
            super(TileResonator.this, 30, 64);
            this.addTitle(Lang.getItemName(TileResonator.this.getXUBlock()), false);
            this.addWidget(new WidgetProgressArrow(74, 52){

                @Override
                public float getProgress() {
                    ResonatorRecipe recipe = TileResonator.this.currentRecipe;
                    if (recipe == null) {
                        return 0.0f;
                    }
                    return (float)TileResonator.this.progress / (float)recipe.energy;
                }
            });
            this.addWidget(new WidgetSlotItemHandler((IItemHandler)TileResonator.this.INPUT, 0, 50, 52));
            this.addWidget(new WidgetSlotItemHandler((IItemHandler)TileResonator.this.OUTPUT, 0, 102, 52){

                @Override
                public boolean func_75214_a(ItemStack stack) {
                    return false;
                }
            });
            this.addWidget(TileResonator.this.upgrades.getSpeedUpgradeSlot(148, 52));
            this.addWidget(new WidgetTextData(8, 20, 160){

                @Override
                public void addToDescription(PacketBuffer packet) {
                    ResonatorRecipe recipe = TileResonator.this.currentRecipe;
                    if (recipe == null) {
                        packet.writeBoolean(false);
                    } else {
                        packet.writeBoolean(true);
                        packet.writeInt(TileResonator.this.progress);
                        packet.writeInt(recipe.energy);
                    }
                }

                @Override
                protected String constructText(PacketBuffer packet) {
                    this.align = 0;
                    if (packet.readBoolean()) {
                        int progress = packet.readInt();
                        int level = TileResonator.this.upgrades.getLevel(Upgrade.SPEED);
                        TileResonator.this.progress = progress;
                        return Lang.translateArgs("Power: %s / %s GP", String.format(Locale.ENGLISH, "%.2f", Float.valueOf((float)progress * 0.01f * (float)(1 + level))), StringHelper.niceFormat((float)packet.readInt() * 0.01f * (float)(1 + level)));
                    }
                    return null;
                }
            });
            this.cropAndAddPlayerSlots(inventory);
            this.validate();
        }
    }

    public static class ResonatorRecipe {
        public static HashSet<Item> WildCardItems = new HashSet();
        public static TCustomHashSet<ItemStack> SpecificItems = new TCustomHashSet(CollectionHelper.HASHING_STRATEGY_ITEMSTACK);
        public ItemStack input;
        public ItemStack output;
        public int energy;
        public boolean addOwnerTag;

        public ResonatorRecipe(ItemStack input, ItemStack output, int energy, boolean addOwnerTag) {
            this.input = input;
            this.output = output;
            this.energy = energy;
            this.addOwnerTag = addOwnerTag;
        }

        public String toString() {
            return "ResonatorRecipe{input=" + this.input + ", output=" + this.output + ", energy=" + this.energy + '}';
        }
    }
}

