/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.tile;

import com.google.common.collect.Lists;
import com.rwtema.extrautils2.backend.XUBlock;
import com.rwtema.extrautils2.backend.entries.XU2Entries;
import com.rwtema.extrautils2.blocks.BlockCursedEarth;
import com.rwtema.extrautils2.gui.backend.DynamicContainer;
import com.rwtema.extrautils2.gui.backend.DynamicContainerTile;
import com.rwtema.extrautils2.gui.backend.IWidget;
import com.rwtema.extrautils2.gui.backend.WidgetTextData;
import com.rwtema.extrautils2.network.PacketBuffer;
import com.rwtema.extrautils2.tile.TileAdvInteractor;
import com.rwtema.extrautils2.tile.tesr.ITESRHook;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.StringUtils;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.WeightedSpawnerEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.storage.AnvilChunkLoader;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.event.ForgeEventFactory;

public class TileSuperMobSpawner
extends TileAdvInteractor
implements ITESRHook {
    MyMobSpawnerBaseLogic logic = this.registerNBT("spawner", new MyMobSpawnerBaseLogic(){

        @Override
        public void broadcastEvent(int id) {
            TileSuperMobSpawner.this.func_145831_w().func_175641_c(TileSuperMobSpawner.this.func_174877_v(), Blocks.field_150474_ac, id, 0);
        }

        @Override
        public World getSpawnerWorld() {
            return TileSuperMobSpawner.this.func_145831_w();
        }

        @Override
        public BlockPos getSpawnerPosition() {
            return TileSuperMobSpawner.this.func_174877_v();
        }
    });

    @Override
    public void render(IBlockAccess world, BlockPos pos, double x, double y, double z, float partialTicks, int destroyStage, VertexBuffer renderer, BlockRendererDispatcher blockRenderer) {
    }

    @Override
    public DynamicContainer getDynamicContainer(int ID2, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerSpawner(this, player);
    }

    @Override
    protected void operate() {
        this.logic.updateSpawner();
    }

    @Override
    public void onBlockPlacedBy(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack, XUBlock xuBlock) {
        super.onBlockPlacedBy(worldIn, pos, state, placer, stack, xuBlock);
        if (stack == null || !stack.func_77942_o()) {
            return;
        }
        this.logic.readFromNBT(stack.func_77978_p());
    }

    public ItemStack createDropStack() {
        ItemStack stack = new ItemStack((Block)XU2Entries.mobSpawner.value);
        stack.func_77982_d(this.logic.serializeNBT());
        return stack;
    }

    @Override
    public boolean harvestBlock(World worldIn, EntityPlayer player, BlockPos pos, XUBlock xuBlock, IBlockState state) {
        ItemStack itemStack = this.createDropStack();
        Block.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)itemStack);
        return true;
    }

    @Override
    public Optional<ItemStack> getPickBlock(EntityPlayer player, RayTraceResult target) {
        return Optional.of(this.createDropStack());
    }

    public void loadFromVanillaSpawner(TileEntityMobSpawner spawner) {
        NBTTagCompound nbt = spawner.func_189515_b(new NBTTagCompound());
        this.logic.readFromNBT(nbt);
    }

    @Override
    public void addToDescriptionPacket(PacketBuffer packet) {
        NBTTagCompound tag = this.logic.serializeNBT();
        tag.func_82580_o("SpawnPotentials");
        packet.writeNBT(tag);
    }

    @Override
    public void handleDescriptionPacket(PacketBuffer packet) {
        this.logic.readFromNBT(packet.readNBT());
    }

    @Override
    public float getPower() {
        return super.getPower();
    }

    public static abstract class MyMobSpawnerBaseLogic
    implements INBTSerializable<NBTTagCompound> {
        private final List<WeightedSpawnerEntity> toSpawnList = Lists.newArrayList();
        private int spawnDelay = 20;
        private WeightedSpawnerEntity randomEntity = new WeightedSpawnerEntity();
        private int minSpawnDelay = 200;
        private int maxSpawnDelay = 800;
        private int spawnCount = 4;
        private Entity cachedEntity;
        private int maxNearbyEntities = 6;
        private int spawnRange = 4;

        private String getEntityNameToSpawn() {
            return this.randomEntity.func_185277_b().func_74779_i("id");
        }

        public void updateSpawner() {
            if (this.spawnDelay > 0) {
                this.spawnDelay -= 20;
                return;
            }
            BlockPos blockpos = this.getSpawnerPosition();
            boolean flag = false;
            int i = 0;
            World world = this.getSpawnerWorld();
            Random rand = world.field_73012_v;
            while (true) {
                EntityLiving entityliving;
                double d2;
                double d1;
                NBTTagCompound nbttagcompound;
                if (i >= this.spawnCount) {
                    if (!flag) break;
                    this.resetTimer();
                    break;
                }
                NBTTagList nbttaglist = (nbttagcompound = this.randomEntity.func_185277_b()).func_150295_c("Pos", 6);
                int j = nbttaglist.func_74745_c();
                double d0 = j >= 1 ? nbttaglist.func_150309_d(0) : (double)blockpos.func_177958_n() + (rand.nextDouble() - rand.nextDouble()) * (double)this.spawnRange + 0.5;
                Entity entity = AnvilChunkLoader.func_186054_a((NBTTagCompound)nbttagcompound, (World)world, (double)d0, (double)(d1 = j >= 2 ? nbttaglist.func_150309_d(1) : (double)(blockpos.func_177956_o() + rand.nextInt(3) - 1)), (double)(d2 = j >= 3 ? nbttaglist.func_150309_d(2) : (double)blockpos.func_177952_p() + (rand.nextDouble() - rand.nextDouble()) * (double)this.spawnRange + 0.5), (boolean)false);
                if (entity == null) {
                    return;
                }
                int k = world.func_72872_a(entity.getClass(), new AxisAlignedBB((double)blockpos.func_177958_n(), (double)blockpos.func_177956_o(), (double)blockpos.func_177952_p(), (double)(blockpos.func_177958_n() + 1), (double)(blockpos.func_177956_o() + 1), (double)(blockpos.func_177952_p() + 1)).func_186662_g((double)this.spawnRange)).size();
                if (k >= this.maxNearbyEntities) {
                    this.resetTimer();
                    return;
                }
                EntityLiving entityLiving = entityliving = entity instanceof EntityLiving ? (EntityLiving)entity : null;
                if (entityliving == null) continue;
                entity.func_70012_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, rand.nextFloat() * 360.0f, 0.0f);
                if (!ForgeEventFactory.canEntitySpawnSpawner((EntityLiving)entityliving, (World)world, (float)((float)entity.field_70165_t), (float)((float)entity.field_70163_u), (float)((float)entity.field_70161_v))) {
                    ++i;
                    continue;
                }
                if (this.randomEntity.func_185277_b().func_186856_d() == 1 && this.randomEntity.func_185277_b().func_150297_b("id", 8) && !ForgeEventFactory.doSpecialSpawn((EntityLiving)entityliving, (World)world, (float)((float)entity.field_70165_t), (float)((float)entity.field_70163_u), (float)((float)entity.field_70161_v))) {
                    entityliving.func_180482_a(world.func_175649_E(new BlockPos(entity)), null);
                }
                BlockCursedEarth.spawnMobAsCursed(entity);
                world.func_175718_b(2004, blockpos, 0);
                entityliving.func_70656_aK();
                flag = true;
                ++i;
            }
            this.resetTimer();
        }

        private void resetTimer() {
            if (this.maxSpawnDelay <= this.minSpawnDelay) {
                this.spawnDelay = this.minSpawnDelay;
            } else {
                int i = this.maxSpawnDelay - this.minSpawnDelay;
                this.spawnDelay = this.minSpawnDelay + this.getSpawnerWorld().field_73012_v.nextInt(i);
            }
            if (!this.toSpawnList.isEmpty()) {
                this.setNextSpawnData((WeightedSpawnerEntity)WeightedRandom.func_76271_a((Random)this.getSpawnerWorld().field_73012_v, this.toSpawnList));
            }
            this.broadcastEvent(1);
        }

        public void readFromNBT(NBTTagCompound nbt) {
            NBTTagCompound var4;
            this.spawnDelay = nbt.func_74765_d("Delay");
            this.toSpawnList.clear();
            if (nbt.func_150297_b("SpawnPotentials", 9)) {
                NBTTagList nbttagcompound = nbt.func_150295_c("SpawnPotentials", 10);
                for (int i = 0; i < nbttagcompound.func_74745_c(); ++i) {
                    this.toSpawnList.add(new WeightedSpawnerEntity(nbttagcompound.func_150305_b(i)));
                }
            }
            if (!(var4 = nbt.func_74775_l("SpawnData")).func_150297_b("id", 8)) {
                var4.func_74778_a("id", "Pig");
            }
            this.loadSpawnData(new WeightedSpawnerEntity(1, var4));
            if (nbt.func_150297_b("MinSpawnDelay", 99)) {
                this.minSpawnDelay = nbt.func_74765_d("MinSpawnDelay");
                this.maxSpawnDelay = nbt.func_74765_d("MaxSpawnDelay");
                this.spawnCount = nbt.func_74765_d("SpawnCount");
            }
            if (nbt.func_150297_b("MaxNearbyEntities", 99)) {
                this.maxNearbyEntities = nbt.func_74765_d("MaxNearbyEntities");
            }
            if (nbt.func_150297_b("SpawnRange", 99)) {
                this.spawnRange = nbt.func_74765_d("SpawnRange");
            }
            if (this.getSpawnerWorld() != null) {
                this.cachedEntity = null;
            }
        }

        protected void loadSpawnData(WeightedSpawnerEntity entry2) {
            this.randomEntity = entry2;
        }

        public NBTTagCompound writeToNBT(NBTTagCompound p_189530_1_) {
            String s = this.getEntityNameToSpawn();
            if (StringUtils.func_151246_b((String)s)) {
                return p_189530_1_;
            }
            p_189530_1_.func_74777_a("Delay", (short)this.spawnDelay);
            p_189530_1_.func_74777_a("MinSpawnDelay", (short)this.minSpawnDelay);
            p_189530_1_.func_74777_a("MaxSpawnDelay", (short)this.maxSpawnDelay);
            p_189530_1_.func_74777_a("SpawnCount", (short)this.spawnCount);
            p_189530_1_.func_74777_a("MaxNearbyEntities", (short)this.maxNearbyEntities);
            p_189530_1_.func_74777_a("SpawnRange", (short)this.spawnRange);
            p_189530_1_.func_74782_a("SpawnData", (NBTBase)this.randomEntity.func_185277_b().func_74737_b());
            NBTTagList nbttaglist = new NBTTagList();
            if (this.toSpawnList.isEmpty()) {
                nbttaglist.func_74742_a((NBTBase)this.randomEntity.func_185278_a());
            } else {
                for (WeightedSpawnerEntity weightedspawnerentity : this.toSpawnList) {
                    nbttaglist.func_74742_a((NBTBase)weightedspawnerentity.func_185278_a());
                }
            }
            p_189530_1_.func_74782_a("SpawnPotentials", (NBTBase)nbttaglist);
            return p_189530_1_;
        }

        public Entity getCachedEntity() {
            if (this.cachedEntity == null) {
                this.cachedEntity = AnvilChunkLoader.func_186051_a((NBTTagCompound)this.randomEntity.func_185277_b(), (World)this.getSpawnerWorld(), (boolean)false);
                if (this.randomEntity.func_185277_b().func_186856_d() == 1 && this.randomEntity.func_185277_b().func_150297_b("id", 8) && this.cachedEntity instanceof EntityLiving) {
                    ((EntityLiving)this.cachedEntity).func_180482_a(this.getSpawnerWorld().func_175649_E(new BlockPos(this.cachedEntity)), null);
                }
            }
            return this.cachedEntity;
        }

        public void setNextSpawnData(WeightedSpawnerEntity p_184993_1_) {
            this.randomEntity = p_184993_1_;
        }

        public abstract void broadcastEvent(int var1);

        public abstract World getSpawnerWorld();

        public abstract BlockPos getSpawnerPosition();

        public NBTTagCompound serializeNBT() {
            return this.writeToNBT(new NBTTagCompound());
        }

        public void deserializeNBT(NBTTagCompound nbt) {
            this.readFromNBT(nbt);
        }
    }

    public static class ContainerSpawner
    extends DynamicContainerTile {
        public ContainerSpawner(final TileSuperMobSpawner spawner, EntityPlayer player) {
            super(spawner);
            this.addTitle("Resturbed Spawner");
            this.crop();
            IWidget widget = spawner.getRSWidget(4, this.height + 4);
            this.addWidget(widget);
            widget = spawner.upgrades.getSpeedUpgradeSlot(4 + widget.getX() + widget.getW(), widget.getY());
            this.addWidget(widget);
            this.addWidget(new WidgetTextData(4 + widget.getX() + widget.getW(), widget.getY(), 64){

                @Override
                public void addToDescription(PacketBuffer packet) {
                }

                @Override
                protected String constructText(PacketBuffer packet) {
                    return spawner.logic.getCachedEntity().func_70005_c_();
                }
            });
            this.cropAndAddPlayerSlots(player.field_71071_by);
            this.validate();
        }
    }
}

