/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.tile;

import com.google.common.collect.Lists;
import com.rwtema.extrautils2.ExtraUtils2;
import com.rwtema.extrautils2.backend.XUBlock;
import com.rwtema.extrautils2.backend.model.XUBlockState;
import com.rwtema.extrautils2.gui.backend.IDynamicHandler;
import com.rwtema.extrautils2.itemhandler.InventoryHelper;
import com.rwtema.extrautils2.network.PacketBuffer;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public abstract class XUTile
extends TileEntity {
    XUBlock xuBlock;
    XUBlockState state;
    @Nullable
    private HashMap<String, INBTSerializable> nbtHandlers;

    public static boolean isLoaded(TileEntity tile) {
        World world;
        if (!tile.func_145837_r() && (world = tile.func_145831_w()) != null && tile.func_174877_v() != null && world.func_175667_e(tile.func_174877_v())) {
            Chunk chunk = world.func_175726_f(tile.func_174877_v());
            if (chunk == null) {
                return false;
            }
            if (chunk.func_177424_a(tile.func_174877_v(), Chunk.EnumCreateEntityType.CHECK) == tile) {
                return true;
            }
        }
        return false;
    }

    public static <T extends TileEntity> List<T> searchAABBForTiles(World world, AxisAlignedBB area, Class<T> tileClazz, boolean firstOnly, List<T> list) {
        int x0 = (int)Math.floor(area.field_72340_a) >> 4;
        int x1 = (int)Math.ceil(area.field_72336_d) >> 4;
        int z0 = (int)Math.floor(area.field_72339_c) >> 4;
        int z1 = (int)Math.ceil(area.field_72334_f) >> 4;
        if (list == null) {
            list = Lists.newArrayList();
        }
        for (int x = x0; x <= x1; ++x) {
            for (int z = z0; z <= z1; ++z) {
                Chunk chunk = world.func_72964_e(x, z);
                for (Map.Entry entry2 : chunk.func_177434_r().entrySet()) {
                    BlockPos pos = (BlockPos)entry2.getKey();
                    if (tileClazz != ((TileEntity)entry2.getValue()).getClass() || !area.func_72318_a(new Vec3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5))) continue;
                    list.add((TileEntity)entry2.getValue());
                    if (!firstOnly) continue;
                    return list;
                }
            }
        }
        return list;
    }

    public static EnumFacing getSafeFacing(int i) {
        if (i == 6) {
            return null;
        }
        return EnumFacing.values()[i];
    }

    public static int getSafeOrdinal(@Nullable EnumFacing facing) {
        return facing == null ? 6 : facing.ordinal();
    }

    protected <T extends INBTSerializable> T registerNBT(String key, T t) {
        if (this.nbtHandlers == null) {
            this.nbtHandlers = new HashMap();
        }
        this.nbtHandlers.put(key, t);
        return t;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (this.nbtHandlers != null) {
            for (Map.Entry<String, INBTSerializable> entry2 : this.nbtHandlers.entrySet()) {
                NBTBase tag = compound.func_74781_a(entry2.getKey());
                if (tag == null) continue;
                entry2.getValue().deserializeNBT(tag);
            }
        }
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        if (this.nbtHandlers != null) {
            for (Map.Entry<String, INBTSerializable> entry2 : this.nbtHandlers.entrySet()) {
                String key = entry2.getKey();
                NBTBase value = entry2.getValue().serializeNBT();
                compound.func_74782_a(key, value);
            }
        }
        return compound;
    }

    public boolean isLoaded() {
        return XUTile.isLoaded(this);
    }

    public void onBlockPlacedBy(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack, XUBlock xuBlock) {
    }

    public void onNeighborBlockChange(World worldIn, BlockPos pos, IBlockState state, Block neighborBlock) {
    }

    public void breakBlock(World worldIn, BlockPos pos, IBlockState state) {
        Iterable<ItemStack> itemHandler = this.getDropHandler();
        if (itemHandler != null) {
            InventoryHelper.dropAll(worldIn, pos, itemHandler);
        }
    }

    protected Iterable<ItemStack> getDropHandler() {
        IItemHandler itemHandler = this.getItemHandler(null);
        if (itemHandler == null) {
            return null;
        }
        return InventoryHelper.getItemHandlerIterator(itemHandler);
    }

    public boolean harvestBlock(World worldIn, EntityPlayer player, BlockPos pos, XUBlock xuBlock, IBlockState state) {
        return false;
    }

    public void func_145836_u() {
        super.func_145836_u();
        this.xuBlock = null;
        this.state = null;
    }

    public XUBlockState getBlockState() {
        if (this.state == null) {
            this.state = (XUBlockState)this.field_145850_b.func_180495_p(this.field_174879_c);
        }
        return this.state;
    }

    public XUBlock getXUBlock() {
        if (this.xuBlock == null) {
            this.xuBlock = (XUBlock)this.getBlockState().func_177230_c();
        }
        return this.xuBlock;
    }

    public boolean onBlockActivated(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (this instanceof IDynamicHandler) {
            if (!worldIn.field_72995_K) {
                this.openGUI(playerIn);
            }
            return true;
        }
        return false;
    }

    public void openGUI(EntityPlayer player) {
        this.openGUI(player, 0);
    }

    public void openGUI(EntityPlayer player, int modGuiId) {
        player.openGui((Object)ExtraUtils2.instance, modGuiId, this.field_145850_b, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p());
    }

    public IItemHandler getItemHandler(EnumFacing facing) {
        return null;
    }

    @Nonnull
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nonnull EnumFacing facing) {
        IItemHandler handler;
        if (CapabilityItemHandler.ITEM_HANDLER_CAPABILITY == capability && (handler = this.getItemHandler(facing)) != null) {
            return (T)handler;
        }
        if (CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY == capability && (handler = this.getFluidHandler(facing)) != null) {
            return (T)handler;
        }
        if (CapabilityEnergy.ENERGY == capability && (handler = this.getEnergyHandler(facing)) != null) {
            return (T)handler;
        }
        return (T)super.getCapability(capability, facing);
    }

    @Nullable
    public IFluidHandler getFluidHandler(EnumFacing facing) {
        return null;
    }

    @Nullable
    public IEnergyStorage getEnergyHandler(EnumFacing facing) {
        return null;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nonnull EnumFacing facing) {
        return this.getCapability(capability, facing) != null;
    }

    public void addToDescriptionPacket(PacketBuffer packet) {
    }

    public void handleDescriptionPacket(PacketBuffer packet) {
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        ByteBuf buffer = Unpooled.buffer();
        this.addToDescriptionPacket(new PacketBuffer(buffer));
        int readableBytes = buffer.readableBytes();
        if (readableBytes == 0) {
            return null;
        }
        byte[] b = new byte[readableBytes];
        buffer.readBytes(b);
        NBTTagCompound tags = new NBTTagCompound();
        tags.func_74773_a("a", b);
        return new SPacketUpdateTileEntity(this.field_174879_c, -1, this.func_189517_E_());
    }

    public final void handleUpdateTag(@Nonnull NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (tag.func_150297_b("a", 7)) {
            this.handleDescriptionPacket(new PacketBuffer(Unpooled.wrappedBuffer((byte[])tag.func_74770_j("a"))));
        }
    }

    @Nonnull
    public final NBTTagCompound func_189517_E_() {
        ByteBuf buffer = Unpooled.buffer();
        this.addToDescriptionPacket(new PacketBuffer(buffer));
        int readableBytes = buffer.readableBytes();
        if (readableBytes == 0) {
            return super.func_189515_b(new NBTTagCompound());
        }
        byte[] b = new byte[readableBytes];
        buffer.readBytes(b);
        NBTTagCompound tags = super.func_189515_b(new NBTTagCompound());
        tags.func_74773_a("a", b);
        return tags;
    }

    public final void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        NBTTagCompound nbtCompound = pkt.func_148857_g();
        this.handleUpdateTag(nbtCompound);
    }

    @SideOnly(value=Side.CLIENT)
    public void renderBakedModel(IBlockAccess world, VertexBuffer renderer, BlockRendererDispatcher blockRenderer, IBakedModel model) {
        blockRenderer.func_175019_b().func_178267_a(world, model, (IBlockState)this.getBlockState(), this.func_174877_v(), renderer, false);
    }

    public void markForUpdate() {
        if (this.field_145850_b == null || this.field_174879_c == null) {
            return;
        }
        XUBlockState state = this.getBlockState();
        this.field_145850_b.func_184138_a(this.field_174879_c, (IBlockState)state, (IBlockState)state, 0);
    }

    public Optional<ItemStack> getPickBlock(EntityPlayer player, RayTraceResult target) {
        return null;
    }

    public boolean hasComparatorLevels() {
        return false;
    }

    public int getComparatorLevel() {
        throw new IllegalStateException();
    }

    public void func_70296_d() {
        super.func_70296_d();
    }
}

