/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.transfernodes;

import com.rwtema.extrautils2.backend.IXUItem;
import com.rwtema.extrautils2.backend.XUItem;
import com.rwtema.extrautils2.backend.model.BoxModel;
import com.rwtema.extrautils2.backend.model.PassthruModelItem;
import com.rwtema.extrautils2.backend.model.Transforms;
import com.rwtema.extrautils2.transfernodes.BlockTransferHolder;
import com.rwtema.extrautils2.transfernodes.GrocketType;
import java.util.EnumMap;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.SoundType;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemGrocket
extends XUItem {
    public static ItemGrocket instance;
    private EnumMap<GrocketType, BoxModel> models;
    @SideOnly(value=Side.CLIENT)
    private TextureAtlasSprite sprite;

    public ItemGrocket() {
        this.func_77627_a(true);
        instance = this;
    }

    public void func_150895_a(@Nonnull Item itemIn, CreativeTabs tab, List<ItemStack> subItems) {
        for (int i = 0; i < GrocketType.values().length; ++i) {
            subItems.add(new ItemStack(itemIn, 1, i));
        }
    }

    @Nonnull
    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (stack == null || stack.field_77994_a == 0) {
            return EnumActionResult.FAIL;
        }
        if (!playerIn.func_175151_a(pos, facing, stack)) {
            return EnumActionResult.FAIL;
        }
        if (worldIn.field_72995_K) {
            return EnumActionResult.SUCCESS;
        }
        GrocketType type = this.getGrocketType(stack);
        if (BlockTransferHolder.placeGrocket(playerIn, worldIn, pos, type.create(), facing) || BlockTransferHolder.placeGrocket(playerIn, worldIn, pos.func_177972_a(facing), type.create(), facing.func_176734_d())) {
            SoundType soundtype = Blocks.field_150348_b.func_185467_w();
            worldIn.func_184133_a(playerIn, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
            --stack.field_77994_a;
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerTextures() {
        this.sprite = null;
        GrocketType[] values = GrocketType.values();
        this.models = new EnumMap(GrocketType.class);
        for (GrocketType type : values) {
            BoxModel baseModel = type.createBaseModel();
            baseModel.moveToCenterForInventoryRendering();
            baseModel.registerTextures();
            this.models.put(type, baseModel);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getBaseTexture() {
        if (this.sprite == null) {
            for (BoxModel boxes : this.models.values()) {
                this.sprite = boxes.getTex();
                if (this.sprite == null) continue;
                return this.sprite;
            }
        }
        return this.sprite;
    }

    public GrocketType getGrocketType(ItemStack stack) {
        GrocketType[] values = GrocketType.values();
        int i = stack.func_77952_i();
        if (i < 0 || i >= values.length) {
            i = 0;
        }
        return values[i];
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IBakedModel createModel(int metadata) {
        return new PassthruModelItem((IXUItem)this, Transforms.blockTransforms);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addQuads(PassthruModelItem.ModelLayer model, ItemStack stack) {
        GrocketType type = this.getGrocketType(stack);
        BoxModel m = this.models.get((Object)type);
        model.clear();
        model.isGui3D = true;
        model.tex = m.getTex();
        model.addBoxModel(m);
    }

    @Override
    public int getMaxMetadata() {
        return GrocketType.values().length;
    }

    @Override
    public boolean allowOverride() {
        return true;
    }

    @Nonnull
    public String func_77667_c(ItemStack stack) {
        return super.func_77667_c(stack) + "." + stack.func_77952_i();
    }
}

