/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.transfernodes;

import com.rwtema.extrautils2.backend.entries.XU2Entries;
import com.rwtema.extrautils2.backend.model.BoxModel;
import com.rwtema.extrautils2.gui.backend.DynamicContainer;
import com.rwtema.extrautils2.gui.backend.IDynamicHandler;
import com.rwtema.extrautils2.network.PacketBuffer;
import com.rwtema.extrautils2.tile.TilePower;
import com.rwtema.extrautils2.transfernodes.BlockTransferPipe;
import com.rwtema.extrautils2.transfernodes.Grocket;
import com.rwtema.extrautils2.transfernodes.GrocketType;
import com.rwtema.extrautils2.transfernodes.IPipe;
import com.rwtema.extrautils2.transfernodes.TransferHelper;
import com.rwtema.extrautils2.utils.CapGetter;
import com.rwtema.extrautils2.utils.helpers.ItemStackHelper;
import com.rwtema.extrautils2.utils.helpers.PlayerHelper;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class TileTransferHolder
extends TilePower
implements ITickable,
IPipe,
IDynamicHandler {
    public BoxModel worldModel;
    IBlockState centerPipe = null;
    Grocket[] grockets = new Grocket[6];

    @Nullable
    public static IBlockState getCenterPipeState(byte b) {
        return b == -1 ? null : BlockTransferPipe.stateBuilder.meta2states[b];
    }

    public void addGrocket(EntityPlayer player, Grocket grocket, EnumFacing facing) {
        this.loadGrocket(grocket, facing.ordinal());
        if (player != null) {
            grocket.onPlaced(player);
        }
        grocket.validate();
        this.markForUpdate();
    }

    public void loadGrocket(Grocket grocket, int ordinal) {
        this.grockets[ordinal] = grocket;
        grocket.holder = this;
        grocket.side = EnumFacing.values()[ordinal];
    }

    public void func_73660_a() {
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return;
        }
        boolean shouldStay = this.centerPipe != null;
        for (Grocket grocket : this.grockets) {
            if (grocket == null) continue;
            grocket.func_73660_a();
            shouldStay = true;
        }
        if (!shouldStay) {
            this.field_145850_b.func_175698_g(this.field_174879_c);
        }
    }

    @Override
    protected Iterable<ItemStack> getDropHandler() {
        return null;
    }

    @Override
    public boolean onBlockActivated(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        RayTraceResult rayTrace = PlayerHelper.rayTrace(playerIn);
        if (rayTrace == null) {
            return false;
        }
        int subHit = rayTrace.subHit;
        if (subHit < 6) {
            EnumFacing facing;
            BlockPos offset;
            if (!ItemStackHelper.holdingWrench(playerIn)) {
                return false;
            }
            if (subHit < 0) {
                subHit = side.ordinal();
            }
            if (!TransferHelper.isInputtingPipe((IBlockAccess)worldIn, offset = pos.func_177972_a(facing = EnumFacing.values()[subHit]), facing.func_176734_d()) && !TransferHelper.hasValidCapability((IBlockAccess)worldIn, offset, facing.func_176734_d())) {
                return false;
            }
            this.centerPipe = this.centerPipe.func_177231_a(BlockTransferPipe.SIDE_BLOCKED.get(facing));
            this.markForUpdate();
            return true;
        }
        Grocket grocket = this.grockets[subHit %= 6];
        if (grocket == null) {
            return false;
        }
        if (ItemStackHelper.holdingWrench(playerIn) && playerIn.func_70093_af()) {
            grocket.invalidate();
            for (ItemStack itemStack : grocket.getDrops()) {
                if (itemStack == null) continue;
                Block.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)itemStack);
            }
            this.grockets[subHit] = null;
            for (Grocket g : this.grockets) {
                if (g == null) continue;
                this.markForUpdate();
                return true;
            }
            IBlockState centerPipe = this.centerPipe;
            if (centerPipe == null) {
                centerPipe = Blocks.field_150350_a.func_176223_P();
            }
            worldIn.func_175656_a(pos, centerPipe);
            return true;
        }
        return grocket.onActivated(playerIn, side, hitX, hitY, hitZ);
    }

    @Override
    public void onPowerChanged() {
    }

    @Override
    public Optional<ItemStack> getPickBlock(EntityPlayer player, RayTraceResult target) {
        if (player == null) {
            return null;
        }
        RayTraceResult rayTrace = PlayerHelper.rayTrace(player);
        if (rayTrace == null) {
            return Optional.empty();
        }
        int subHit = rayTrace.subHit;
        if (subHit < 6) {
            return Optional.of(XU2Entries.pipe.newStack());
        }
        Grocket grocket = this.grockets[subHit %= 6];
        if (grocket == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(grocket.getBaseDrop());
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74774_a("CenterPipeState", this.getCenterPipeIndex());
        for (int i = 0; i < 6; ++i) {
            Grocket grocket = this.grockets[i];
            NBTTagCompound subTag = new NBTTagCompound();
            if (grocket == null) continue;
            grocket.writeToNBT(subTag);
            nbt.func_74768_a("Type", grocket.getType().ordinal());
            nbt.func_74782_a("Grocket_" + i, (NBTBase)subTag);
        }
        return nbt;
    }

    public byte getCenterPipeIndex() {
        return this.centerPipe == null ? (byte)-1 : (byte)BlockTransferPipe.stateBuilder.states2meta.get((Object)this.centerPipe);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        byte b = nbt.func_74771_c("CenterPipeState");
        this.centerPipe = TileTransferHolder.getCenterPipeState(b);
        for (int i = 0; i < 6; ++i) {
            String key = "Grocket_" + i;
            if (nbt.func_150297_b(key, 10)) {
                int type = nbt.func_74762_e("Type");
                if (type < 0 || type >= GrocketType.values().length) {
                    this.grockets[i] = null;
                    continue;
                }
                NBTTagCompound tag = nbt.func_74775_l(key);
                Grocket grocket = GrocketType.values()[type].create();
                this.loadGrocket(grocket, i);
                grocket.readFromNBT(tag);
                continue;
            }
            this.grockets[i] = null;
        }
    }

    @Override
    public void addToDescriptionPacket(PacketBuffer packet) {
        super.addToDescriptionPacket(packet);
        packet.writeByte(this.getCenterPipeIndex());
        int mask = 0;
        for (int i = 0; i < 6; ++i) {
            if (this.grockets[i] == null) continue;
            mask |= 1 << i;
        }
        packet.writeByte(mask);
        for (Grocket grocket : this.grockets) {
            if (grocket == null) continue;
            packet.writeInt(grocket.getType().ordinal());
        }
    }

    @Override
    public void handleDescriptionPacket(PacketBuffer packet) {
        if (!this.field_145850_b.field_72995_K) {
            return;
        }
        super.handleDescriptionPacket(packet);
        this.centerPipe = TileTransferHolder.getCenterPipeState(packet.readByte());
        short mask = packet.readUnsignedByte();
        for (int i = 0; i < 6; ++i) {
            if ((mask & 1 << i) != 0) {
                this.loadGrocket(GrocketType.values()[packet.readInt()].create(), i);
                continue;
            }
            this.grockets[i] = null;
        }
        this.markForUpdate();
    }

    @Override
    public boolean canInput(IBlockAccess world, BlockPos pos, EnumFacing dir) {
        return this.centerPipe != null;
    }

    @Override
    public boolean canOutput(IBlockAccess world, BlockPos pos, EnumFacing dir) {
        return this.centerPipe != null && BlockTransferPipe.isUnblocked(this.centerPipe, dir) && TransferHelper.isInputtingPipe(world, pos.func_177972_a(dir), dir.func_176734_d());
    }

    @Override
    public boolean canOutputTile(IBlockAccess world, BlockPos pos, EnumFacing side) {
        if (this.centerPipe == null || !BlockTransferPipe.isUnblocked(this.centerPipe, side)) {
            return false;
        }
        TileEntity tileEntity = world.func_175625_s(pos.func_177972_a(side));
        Grocket grocket = this.grockets[side.ordinal()];
        for (CapGetter<?> cap : CapGetter.caps) {
            if (grocket == null || !grocket.hasInterface(tileEntity, cap)) continue;
            return true;
        }
        if (tileEntity == null) {
            return false;
        }
        for (CapGetter<?> cap : CapGetter.caps) {
            if (!cap.hasInterface((ICapabilityProvider)tileEntity, side.func_176734_d())) continue;
            return true;
        }
        return false;
    }

    @Override
    public <T> boolean hasCapability(IBlockAccess world, BlockPos pos, EnumFacing side, CapGetter<T> capability) {
        if (this.centerPipe == null || !BlockTransferPipe.isUnblocked(this.centerPipe, side)) {
            return false;
        }
        TileEntity tileEntity = world.func_175625_s(pos.func_177972_a(side));
        Grocket grocket = this.grockets[side.ordinal()];
        if (grocket != null) {
            return grocket.hasInterface(tileEntity, capability);
        }
        return tileEntity != null && capability.hasInterface((ICapabilityProvider)tileEntity, side.func_176734_d());
    }

    @Override
    public <T> T getCapability(IBlockAccess world, BlockPos pos, EnumFacing side, CapGetter<T> capability) {
        if (this.centerPipe == null || !BlockTransferPipe.isUnblocked(this.centerPipe, side)) {
            return null;
        }
        TileEntity tileEntity = world.func_175625_s(pos.func_177972_a(side));
        if (tileEntity == null) {
            return null;
        }
        Grocket grocket = this.grockets[side.ordinal()];
        if (grocket != null) {
            return grocket.getInterface(tileEntity, capability);
        }
        return capability.getInterface((ICapabilityProvider)tileEntity, side.func_176734_d());
    }

    @Override
    public boolean shouldTileConnectionShowNozzle(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        Grocket grocket = this.grockets[facing.ordinal()];
        return grocket == null || grocket.shouldPipeHaveNozzle(facing);
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        for (Grocket grocket : this.grockets) {
            if (grocket == null) continue;
            grocket.invalidate();
        }
    }

    @Override
    public void onChunkUnload() {
        super.onChunkUnload();
        for (Grocket grocket : this.grockets) {
            if (grocket == null) continue;
            grocket.invalidate();
        }
    }

    @Override
    public void onLoad() {
        super.onLoad();
        for (Grocket grocket : this.grockets) {
            if (grocket == null) continue;
            grocket.validate();
        }
    }

    public void openGui(EntityPlayer player, Grocket grocket) {
        this.openGui(player, grocket.side);
    }

    public void openGui(EntityPlayer player, EnumFacing side) {
        this.openGUI(player, side.ordinal());
    }

    @Override
    public DynamicContainer getDynamicContainer(int ID2, EntityPlayer player, World world, int x, int y, int z) {
        if (ID2 < 0 || ID2 >= 6) {
            return null;
        }
        Grocket grocket = this.grockets[ID2];
        if (grocket instanceof IDynamicHandler) {
            return ((IDynamicHandler)((Object)grocket)).getDynamicContainer(ID2, player, world, x, y, z);
        }
        return null;
    }

    @Override
    public float getPower() {
        float t = Float.NaN;
        for (Grocket grocket : this.grockets) {
            float power;
            if (grocket == null || Float.isNaN(power = grocket.getPower())) continue;
            if (Float.isNaN(t)) {
                t = 0.0f;
            }
            t += power;
        }
        return t;
    }
}

