/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.worldgen;

import com.rwtema.extrautils2.utils.datastructures.ThreadLocalBoolean;
import com.rwtema.extrautils2.utils.helpers.NBTHelper;
import com.rwtema.extrautils2.worldgen.SingleChunkGen;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class SingleChunkWorldGenManager
implements IWorldGenerator {
    public static SingleChunkWorldGenManager INSTANCE = new SingleChunkWorldGenManager();
    public static ThreadLocal<Boolean> isRetrogen = new ThreadLocalBoolean(false);
    List<SingleChunkGen> chunkGens = new ArrayList<SingleChunkGen>();

    private SingleChunkWorldGenManager() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public static void register(SingleChunkGen singleChunkGen) {
        SingleChunkWorldGenManager.INSTANCE.chunkGens.add(singleChunkGen);
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        Chunk chunk = world.func_72964_e(chunkX, chunkZ);
        isRetrogen.set(false);
        for (SingleChunkGen chunkGen : this.chunkGens) {
            chunkGen.genChunk(chunk, chunkGenerator, random);
        }
    }

    @SubscribeEvent
    public void saveChunk(ChunkDataEvent.Save event) {
        if (!event.getChunk().func_177419_t()) {
            return;
        }
        NBTTagCompound data = event.getData();
        NBTTagCompound tag = NBTHelper.getOrInitTagCompound(data, "XU2Generation");
        for (SingleChunkGen chunkGen : this.chunkGens) {
            tag.func_74768_a(chunkGen.name, chunkGen.version);
        }
    }

    @SubscribeEvent
    public void loadChunk(ChunkDataEvent.Load event) {
        World world = event.getWorld();
        if (world.field_72995_K) {
            return;
        }
        long chunkSeed = -1L;
        Chunk chunk = event.getChunk();
        Random random = null;
        IChunkGenerator chunkProvider = null;
        NBTTagCompound data = event.getData();
        NBTTagCompound tag = NBTHelper.getOrInitTagCompound(data, "XU2Generation");
        for (SingleChunkGen chunkGen : this.chunkGens) {
            int v;
            if (chunkGen == null || tag.func_150297_b(chunkGen.name, 3) && ((v = tag.func_74762_e(chunkGen.name)) == chunkGen.version || !chunkGen.shouldRegenOldVersion(v))) continue;
            if (chunkSeed == -1L) {
                long worldSeed = world.func_72905_C();
                random = new Random(worldSeed);
                long xSeed = random.nextLong() >> 3;
                long zSeed = random.nextLong() >> 3;
                chunkSeed = xSeed * (long)chunk.field_76635_g + zSeed * (long)chunk.field_76647_h ^ worldSeed;
                chunkProvider = ((WorldServer)world).func_72863_F().field_186029_c;
            }
            isRetrogen.set(true);
            random.setSeed(chunkSeed);
            chunkGen.genChunk(chunk, chunkProvider, random);
        }
    }
}

