/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.blocks.absorbers;

import java.util.List;
import mcjty.lib.container.EmptyContainer;
import mcjty.rftoolsdim.blocks.GenericRFToolsBlock;
import mcjty.rftoolsdim.blocks.absorbers.FeatureAbsorberTileEntity;
import mcjty.rftoolsdim.config.DimletConstructionConfiguration;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class FeatureAbsorberBlock
extends GenericRFToolsBlock<FeatureAbsorberTileEntity, EmptyContainer> {
    public FeatureAbsorberBlock() {
        super(Material.field_151573_f, FeatureAbsorberTileEntity.class, EmptyContainer.class, "feature_absorber", false);
    }

    public boolean hasNoRotation() {
        return true;
    }

    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        FeatureAbsorberTileEntity tileEntity;
        super.addProbeInfo(mode, probeInfo, player, world, blockState, data);
        TileEntity te = world.func_175625_s(data.getPos());
        if (te instanceof FeatureAbsorberTileEntity && (tileEntity = (FeatureAbsorberTileEntity)te).getFeatureName() != null) {
            int absorbing = tileEntity.getAbsorbing();
            int pct = (DimletConstructionConfiguration.maxFeatureAbsorbtion - absorbing) * 100 / DimletConstructionConfiguration.maxFeatureAbsorbtion;
            probeInfo.text(TextFormatting.GREEN + "Unknown feature").progress(pct, 100, probeInfo.defaultProgressStyle().suffix("%"));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.getWailaBody(itemStack, currenttip, accessor, config);
        FeatureAbsorberTileEntity tileEntity = (FeatureAbsorberTileEntity)accessor.getTileEntity();
        if (tileEntity != null && tileEntity.getFeatureName() != null) {
            int absorbing = tileEntity.getAbsorbing();
            int pct = (DimletConstructionConfiguration.maxFeatureAbsorbtion - absorbing) * 100 / DimletConstructionConfiguration.maxFeatureAbsorbtion;
            currenttip.add(TextFormatting.GREEN + "Unknown feature (" + pct + "%)");
        }
        return currenttip;
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack itemStack, EntityPlayer player, List list, boolean whatIsThis) {
        super.addInformation(itemStack, player, list, whatIsThis);
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound != null && tagCompound.func_74764_b("feature")) {
            list.add(TextFormatting.GREEN + "Unknown Feature");
            int absorbing = tagCompound.func_74762_e("absorbing");
            int pct = (DimletConstructionConfiguration.maxFeatureAbsorbtion - absorbing) * 100 / DimletConstructionConfiguration.maxFeatureAbsorbtion;
            list.add(TextFormatting.GREEN + "Absorbed: " + pct + "%");
        }
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            list.add(TextFormatting.WHITE + "Place this block in an area and it will");
            list.add(TextFormatting.WHITE + "gradually absorb the essence of a random feature of");
            list.add(TextFormatting.WHITE + "this dimension.");
            list.add(TextFormatting.WHITE + "You can use the end result in the Dimlet Workbench.");
        } else {
            list.add(TextFormatting.WHITE + "<Press Shift>");
        }
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase entityLivingBase, ItemStack itemStack) {
        this.restoreBlockFromNBT(world, pos, itemStack);
        if (!world.field_72995_K) {
            FeatureAbsorberTileEntity tileEntity = (FeatureAbsorberTileEntity)world.func_175625_s(pos);
            tileEntity.placeDown();
        }
        this.setOwner(world, pos, entityLivingBase);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_149637_q(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public int getGuiID() {
        return -1;
    }
}

