/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.blocks.absorbers;

import java.util.ArrayList;
import java.util.Random;
import java.util.Set;
import mcjty.lib.entity.GenericTileEntity;
import mcjty.rftoolsdim.config.DimletConstructionConfiguration;
import mcjty.rftoolsdim.dimensions.DimensionInformation;
import mcjty.rftoolsdim.dimensions.RfToolsDimensionManager;
import mcjty.rftoolsdim.dimensions.types.FeatureType;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;

public class FeatureAbsorberTileEntity
extends GenericTileEntity
implements ITickable {
    private int absorbing = 0;
    private String featureName = null;

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            this.checkStateClient();
        } else {
            this.checkStateServer();
        }
    }

    protected void checkStateClient() {
        if (this.absorbing > 0) {
            Random rand = this.field_145850_b.field_73012_v;
            double u = rand.nextFloat() * 2.0f - 1.0f;
            double v = (float)((double)(rand.nextFloat() * 2.0f) * Math.PI);
            double x = Math.sqrt(1.0 - u * u) * Math.cos(v);
            double y = Math.sqrt(1.0 - u * u) * Math.sin(v);
            double z = u;
            double r = 1.0;
            this.field_145850_b.func_175688_a(EnumParticleTypes.PORTAL, (double)((float)this.func_174877_v().func_177958_n() + 0.5f) + x * r, (double)((float)this.func_174877_v().func_177956_o() + 0.5f) + y * r, (double)((float)this.func_174877_v().func_177952_p() + 0.5f) + z * r, -x, -y, -z, new int[0]);
        }
    }

    protected void checkStateServer() {
        if (this.absorbing > 0) {
            int dim = this.field_145850_b.field_73011_w.getDimension();
            DimensionInformation information = RfToolsDimensionManager.getDimensionManager(this.field_145850_b).getDimensionInformation(dim);
            if (information == null || !information.hasFeatureType(FeatureType.getFeatureById(this.featureName))) {
                return;
            }
            --this.absorbing;
            this.markDirtyClient();
        }
    }

    private String getRandomFeature(int dim) {
        DimensionInformation information = RfToolsDimensionManager.getDimensionManager(this.field_145850_b).getDimensionInformation(dim);
        if (information == null) {
            return null;
        }
        Set<FeatureType> featureTypes = information.getFeatureTypes();
        if (featureTypes.isEmpty()) {
            return null;
        }
        ArrayList<FeatureType> list = new ArrayList<FeatureType>(featureTypes);
        return ((FeatureType)((Object)list.get(this.field_145850_b.field_73012_v.nextInt(list.size())))).getId();
    }

    public int getAbsorbing() {
        return this.absorbing;
    }

    public String getFeatureName() {
        return this.featureName;
    }

    public void placeDown() {
        if (this.featureName == null) {
            int dim = this.field_145850_b.field_73011_w.getDimension();
            String feature = this.getRandomFeature(dim);
            if (feature == null) {
                this.featureName = null;
                this.absorbing = 0;
            } else if (!feature.equals(this.featureName)) {
                this.featureName = feature;
                this.absorbing = DimletConstructionConfiguration.maxFeatureAbsorbtion;
            }
            this.func_70296_d();
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        return tagCompound;
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        tagCompound.func_74768_a("absorbing", this.absorbing);
        if (this.featureName != null) {
            tagCompound.func_74778_a("feature", this.featureName);
        }
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.absorbing = tagCompound.func_74762_e("absorbing");
        this.featureName = tagCompound.func_74764_b("feature") ? tagCompound.func_74779_i("feature") : null;
    }
}

