/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.blocks.workbench;

import java.util.Map;
import mcjty.lib.container.DefaultSidedInventory;
import mcjty.lib.container.InventoryHelper;
import mcjty.lib.entity.GenericEnergyReceiverTileEntity;
import mcjty.lib.network.Argument;
import mcjty.lib.network.PacketRequestIntegerFromServer;
import mcjty.lib.varia.BlockTools;
import mcjty.rftoolsdim.blocks.workbench.DimletWorkbenchContainer;
import mcjty.rftoolsdim.config.MachineConfiguration;
import mcjty.rftoolsdim.config.Settings;
import mcjty.rftoolsdim.dimensions.dimlets.DimletKey;
import mcjty.rftoolsdim.dimensions.dimlets.KnownDimletConfiguration;
import mcjty.rftoolsdim.dimensions.dimlets.types.DimletCraftingTools;
import mcjty.rftoolsdim.dimensions.dimlets.types.DimletType;
import mcjty.rftoolsdim.dimensions.dimlets.types.IDimletType;
import mcjty.rftoolsdim.items.ModItems;
import mcjty.rftoolsdim.network.RFToolsDimMessages;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class DimletWorkbenchTileEntity
extends GenericEnergyReceiverTileEntity
implements ITickable,
DefaultSidedInventory {
    public static final String CMD_STARTEXTRACT = "startExtract";
    public static final String CMD_SUGGESTPARTS = "suggestParts";
    public static final String CMD_CHEATDIMLET = "cheatDimlet";
    public static final String CMD_GETEXTRACTING = "getExtracting";
    public static final String CLIENTCMD_GETEXTRACTING = "getExtracting";
    private InventoryHelper inventoryHelper = new InventoryHelper((TileEntity)this, DimletWorkbenchContainer.factory, 45);
    private int extracting = 0;
    private DimletKey idToExtract = null;
    private int inhibitCrafting = 0;

    public int getExtracting() {
        return this.extracting;
    }

    public DimletWorkbenchTileEntity() {
        super(MachineConfiguration.WORKBENCH_MAXENERGY, MachineConfiguration.WORKBENCH_RECEIVEPERTICK);
    }

    protected boolean needsCustomInvWrapper() {
        return true;
    }

    public int[] func_180463_a(EnumFacing side) {
        return DimletWorkbenchContainer.factory.getAccessibleSlots();
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return index == 1;
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return index == 0;
    }

    public InventoryHelper getInventoryHelper() {
        return this.inventoryHelper;
    }

    private void checkCrafting() {
        if (this.inhibitCrafting == 0 && !this.checkDimletCrafting() && this.inventoryHelper.getStackInSlot(1) != null) {
            this.inventoryHelper.setInventorySlotContents(0, 1, null);
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.canPlayerAccess(player);
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return true;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.checkStateServer();
        }
    }

    private void checkStateServer() {
        if (this.extracting > 0) {
            --this.extracting;
            if (this.extracting == 0 && !this.doExtract()) {
                this.extracting = 10;
            }
            this.func_70296_d();
        }
    }

    private boolean checkDimletCrafting() {
        ItemStack stackBase = this.inventoryHelper.getStackInSlot(2);
        if (stackBase == null) {
            return false;
        }
        ItemStack stackController = this.inventoryHelper.getStackInSlot(3);
        if (stackController == null) {
            return false;
        }
        ItemStack stackTypeController = this.inventoryHelper.getStackInSlot(6);
        if (stackTypeController == null) {
            return false;
        }
        ItemStack stackMemory = this.inventoryHelper.getStackInSlot(5);
        if (stackMemory == null) {
            return false;
        }
        ItemStack stackEnergy = this.inventoryHelper.getStackInSlot(4);
        if (stackEnergy == null) {
            return false;
        }
        ItemStack stackEssence = this.inventoryHelper.getStackInSlot(7);
        if (stackEssence == null) {
            return false;
        }
        DimletType type = DimletType.values()[stackTypeController.func_77952_i()];
        IDimletType itype = type.dimletType;
        DimletKey key = itype.attemptDimletCrafting(stackController, stackMemory, stackEnergy, stackEssence);
        if (key != null) {
            this.inventoryHelper.setInventorySlotContents(1, 1, KnownDimletConfiguration.getDimletStack(key));
            return true;
        }
        return false;
    }

    public ItemStack func_70298_a(int index, int amount) {
        ItemStack s = this.inventoryHelper.decrStackSize(index, amount);
        this.checkCrafting();
        return s;
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.inventoryHelper.setInventorySlotContents(this.func_70297_j_(), index, stack);
        if (index < 2 || index > 7) {
            return;
        }
        this.checkCrafting();
    }

    public void craftDimlet() {
        ++this.inhibitCrafting;
        this.inventoryHelper.decrStackSize(2, 1);
        this.inventoryHelper.decrStackSize(3, 1);
        this.inventoryHelper.decrStackSize(6, 1);
        this.inventoryHelper.decrStackSize(4, 1);
        this.inventoryHelper.decrStackSize(5, 1);
        this.inventoryHelper.decrStackSize(7, 1);
        --this.inhibitCrafting;
        this.checkCrafting();
    }

    private void startExtracting() {
        DimletKey key;
        Settings settings;
        if (this.extracting > 0) {
            return;
        }
        ItemStack stack = this.inventoryHelper.getStackInSlot(0);
        if (stack != null && ((Object)((Object)ModItems.knownDimletItem)).equals(stack.func_77973_b()) && (settings = KnownDimletConfiguration.getSettings(key = KnownDimletConfiguration.getDimletKey(stack))) != null && settings.isDimlet() && !KnownDimletConfiguration.isCraftable(key)) {
            this.extracting = 64;
            this.idToExtract = key;
            this.inventoryHelper.decrStackSize(0, 1);
            this.func_70296_d();
        }
    }

    private boolean doExtract() {
        int rf = MachineConfiguration.workbenchRfPerDimlet;
        if (this.getEnergyStored(EnumFacing.DOWN) < rf) {
            return false;
        }
        this.consumeEnergy(rf);
        float factor = this.getInfusedFactor();
        Settings entry = KnownDimletConfiguration.getSettings(this.idToExtract);
        if (this.extractSuccess(factor)) {
            this.mergeItemOrThrowInWorld(new ItemStack((Item)ModItems.dimletBaseItem));
        }
        int rarity = entry.getRarity();
        if (this.extractSuccess(factor)) {
            this.mergeItemOrThrowInWorld(new ItemStack((Item)ModItems.dimletTypeControllerItem, 1, this.idToExtract.getType().ordinal()));
        }
        int level = DimletCraftingTools.calculateItemLevelFromRarity(rarity);
        if (this.extractSuccess(factor)) {
            this.mergeItemOrThrowInWorld(new ItemStack((Item)ModItems.dimletMemoryUnitItem, 1, level));
        } else {
            factor += 0.1f;
        }
        if (this.extractSuccess(factor)) {
            this.mergeItemOrThrowInWorld(new ItemStack((Item)ModItems.dimletEnergyModuleItem, 1, level));
        } else {
            factor += 0.1f;
        }
        if (this.extractSuccess(factor)) {
            this.mergeItemOrThrowInWorld(new ItemStack((Item)ModItems.dimletControlCircuitItem, 1, rarity));
        }
        this.idToExtract = null;
        this.func_70296_d();
        return true;
    }

    private boolean extractSuccess(float factor) {
        return this.field_145850_b.field_73012_v.nextFloat() <= 0.61f + factor * 0.4f;
    }

    private void cheatDimlet(EntityPlayerMP player, DimletKey key) {
        ItemStack dimlet = KnownDimletConfiguration.getDimletStack(key);
        if (!player.field_71071_by.func_70441_a(dimlet)) {
            player.func_70099_a(dimlet, 1.05f);
        }
    }

    private void suggestParts(EntityPlayerMP playerMP, DimletKey key) {
        this.setAsideIfPossible(playerMP, 2);
        this.setAsideIfPossible(playerMP, 3);
        this.setAsideIfPossible(playerMP, 4);
        this.setAsideIfPossible(playerMP, 5);
        this.setAsideIfPossible(playerMP, 6);
        this.setAsideIfPossible(playerMP, 7);
        Settings entry = KnownDimletConfiguration.getSettings(key);
        int rarity = entry.getRarity();
        int level = DimletCraftingTools.calculateItemLevelFromRarity(rarity);
        this.tryPlaceIfPossible(playerMP, 2, new ItemStack((Item)ModItems.dimletBaseItem, 1));
        this.tryPlaceIfPossible(playerMP, 6, new ItemStack((Item)ModItems.dimletTypeControllerItem, 1, key.getType().ordinal()));
        this.tryPlaceIfPossible(playerMP, 5, new ItemStack((Item)ModItems.dimletMemoryUnitItem, 1, level));
        this.tryPlaceIfPossible(playerMP, 4, new ItemStack((Item)ModItems.dimletEnergyModuleItem, 1, level));
        this.tryPlaceIfPossible(playerMP, 3, new ItemStack((Item)ModItems.dimletControlCircuitItem, 1, rarity));
        this.tryPlaceEssenceIfPossible(playerMP, 7, key, key.getType().dimletType);
        this.markDirtyClient();
        this.checkCrafting();
    }

    private void setAsideIfPossible(EntityPlayerMP playerMP, int slot) {
        ItemStack stack = this.inventoryHelper.getStackInSlot(slot);
        if (stack != null) {
            int result = InventoryHelper.mergeItemStack((IInventory)this, (boolean)false, (ItemStack)stack, (int)8, (int)44, null);
            if (result > 0) {
                stack.field_77994_a = result;
                if (playerMP.field_71071_by.func_70441_a(stack)) {
                    this.inventoryHelper.setInventorySlotContents(64, slot, null);
                }
            } else {
                this.inventoryHelper.setInventorySlotContents(64, slot, null);
            }
        }
    }

    private void tryPlaceIfPossible(EntityPlayerMP playerMP, int slot, ItemStack part) {
        ItemStack partStack;
        ItemStack stack;
        int i;
        if (this.inventoryHelper.containsItem(slot)) {
            return;
        }
        for (i = 8; i < 44; ++i) {
            stack = this.inventoryHelper.getStackInSlot(i);
            if (stack == null || !stack.func_77969_a(part) || (partStack = this.inventoryHelper.decrStackSize(i, 1)) == null) continue;
            this.inventoryHelper.setInventorySlotContents(64, slot, partStack);
            return;
        }
        for (i = 0; i < playerMP.field_71071_by.func_70302_i_(); ++i) {
            stack = playerMP.field_71071_by.func_70301_a(i);
            if (stack == null || !stack.func_77969_a(part) || (partStack = playerMP.field_71071_by.func_70298_a(i, 1)) == null) continue;
            this.inventoryHelper.setInventorySlotContents(64, slot, partStack);
            playerMP.field_71070_bA.func_75142_b();
            return;
        }
    }

    private void tryPlaceEssenceIfPossible(EntityPlayerMP playerMP, int slot, DimletKey key, IDimletType type) {
        ItemStack partStack;
        ItemStack stack;
        int i;
        if (this.inventoryHelper.containsItem(slot)) {
            return;
        }
        for (i = 8; i < 44; ++i) {
            stack = this.inventoryHelper.getStackInSlot(i);
            if (stack == null || !key.equals(type.isValidEssence(stack)) || (partStack = this.inventoryHelper.decrStackSize(i, 1)) == null) continue;
            this.inventoryHelper.setInventorySlotContents(64, slot, partStack);
            return;
        }
        for (i = 0; i < playerMP.field_71071_by.func_70302_i_(); ++i) {
            stack = playerMP.field_71071_by.func_70301_a(i);
            if (stack == null || !key.equals(type.isValidEssence(stack)) || (partStack = playerMP.field_71071_by.func_70298_a(i, 1)) == null) continue;
            this.inventoryHelper.setInventorySlotContents(64, slot, partStack);
            playerMP.field_71070_bA.func_75142_b();
            return;
        }
    }

    private void mergeItemOrThrowInWorld(ItemStack stack) {
        int notInserted = InventoryHelper.mergeItemStack((IInventory)this, (boolean)false, (ItemStack)stack, (int)8, (int)44, null);
        if (notInserted > 0) {
            BlockTools.spawnItemStack((World)this.field_145850_b, (int)this.func_174877_v().func_177958_n(), (int)this.func_174877_v().func_177956_o(), (int)this.func_174877_v().func_177952_p(), (ItemStack)stack);
        }
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.readBufferFromNBT(tagCompound, this.inventoryHelper);
        this.extracting = tagCompound.func_74762_e("extracting");
        this.idToExtract = null;
        if (tagCompound.func_74764_b("extKtype")) {
            DimletType type = DimletType.getTypeByOpcode(tagCompound.func_74779_i("extKtype"));
            this.idToExtract = new DimletKey(type, tagCompound.func_74779_i("extDkey"));
        } else {
            this.idToExtract = null;
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        return tagCompound;
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        this.writeBufferToNBT(tagCompound, this.inventoryHelper);
        tagCompound.func_74768_a("extracting", this.extracting);
        if (this.idToExtract != null) {
            tagCompound.func_74778_a("extKtype", this.idToExtract.getType().dimletType.getOpcode());
            tagCompound.func_74778_a("extDkey", this.idToExtract.getId());
        }
    }

    public boolean execute(EntityPlayerMP playerMP, String command, Map<String, Argument> args) {
        boolean rc = super.execute(playerMP, command, args);
        if (rc) {
            return true;
        }
        if (CMD_STARTEXTRACT.equals(command)) {
            this.startExtracting();
            return true;
        }
        if (CMD_SUGGESTPARTS.equals(command)) {
            String type = args.get("type").getString();
            String id = args.get("id").getString();
            this.suggestParts(playerMP, new DimletKey(DimletType.getTypeByName(type), id));
            return true;
        }
        if (CMD_CHEATDIMLET.equals(command)) {
            String type = args.get("type").getString();
            String id = args.get("id").getString();
            this.cheatDimlet(playerMP, new DimletKey(DimletType.getTypeByName(type), id));
            return true;
        }
        return false;
    }

    public void requestExtractingFromServer() {
        RFToolsDimMessages.INSTANCE.sendToServer((IMessage)new PacketRequestIntegerFromServer("rftoolsdim", this.func_174877_v(), "getExtracting", "getExtracting", new Argument[0]));
    }

    public Integer executeWithResultInteger(String command, Map<String, Argument> args) {
        Integer rc = super.executeWithResultInteger(command, args);
        if (rc != null) {
            return rc;
        }
        if ("getExtracting".equals(command)) {
            return this.extracting;
        }
        return null;
    }

    public boolean execute(String command, Integer result) {
        boolean rc = super.execute(command, result);
        if (rc) {
            return true;
        }
        if ("getExtracting".equals(command)) {
            this.extracting = result;
            return true;
        }
        return false;
    }
}

