/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.dimensions.world;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import mcjty.rftoolsdim.config.WorldgenConfiguration;
import mcjty.rftoolsdim.dimensions.DimensionInformation;
import mcjty.rftoolsdim.dimensions.RfToolsDimensionManager;
import mcjty.rftoolsdim.dimensions.description.MobDescriptor;
import mcjty.rftoolsdim.dimensions.types.FeatureType;
import mcjty.rftoolsdim.dimensions.types.StructureType;
import mcjty.rftoolsdim.dimensions.types.TerrainType;
import mcjty.rftoolsdim.dimensions.world.mapgen.MapGenCanyons;
import mcjty.rftoolsdim.dimensions.world.mapgen.MapGenDenseCaves;
import mcjty.rftoolsdim.dimensions.world.mapgen.MapGenDesertTemple;
import mcjty.rftoolsdim.dimensions.world.mapgen.MapGenIgloo;
import mcjty.rftoolsdim.dimensions.world.mapgen.MapGenJungleTemple;
import mcjty.rftoolsdim.dimensions.world.mapgen.MapGenLiquidOrbs;
import mcjty.rftoolsdim.dimensions.world.mapgen.MapGenOrbs;
import mcjty.rftoolsdim.dimensions.world.mapgen.MapGenPyramids;
import mcjty.rftoolsdim.dimensions.world.mapgen.MapGenRuinedCities;
import mcjty.rftoolsdim.dimensions.world.mapgen.MapGenSwampHut;
import mcjty.rftoolsdim.dimensions.world.mapgen.MapGenTendrils;
import mcjty.rftoolsdim.dimensions.world.terrain.AmplifiedTerrainGenerator;
import mcjty.rftoolsdim.dimensions.world.terrain.BaseTerrainGenerator;
import mcjty.rftoolsdim.dimensions.world.terrain.CavernTerrainGenerator;
import mcjty.rftoolsdim.dimensions.world.terrain.FlatTerrainGenerator;
import mcjty.rftoolsdim.dimensions.world.terrain.GridTerrainGenerator;
import mcjty.rftoolsdim.dimensions.world.terrain.IslandTerrainGenerator;
import mcjty.rftoolsdim.dimensions.world.terrain.LiquidTerrainGenerator;
import mcjty.rftoolsdim.dimensions.world.terrain.NearlandsTerrainGenerator;
import mcjty.rftoolsdim.dimensions.world.terrain.NormalTerrainGenerator;
import mcjty.rftoolsdim.dimensions.world.terrain.RoughTerrainGenerator;
import mcjty.rftoolsdim.dimensions.world.terrain.VoidTerrainGenerator;
import mcjty.rftoolsdim.dimensions.world.terrain.WavesTerrainGenerator;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.IAnimals;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldEntitySpawner;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraft.world.gen.ChunkProviderSettings;
import net.minecraft.world.gen.MapGenBase;
import net.minecraft.world.gen.MapGenCaves;
import net.minecraft.world.gen.MapGenRavine;
import net.minecraft.world.gen.feature.WorldGenDungeons;
import net.minecraft.world.gen.feature.WorldGenLakes;
import net.minecraft.world.gen.structure.ComponentScatteredFeaturePieces;
import net.minecraft.world.gen.structure.MapGenMineshaft;
import net.minecraft.world.gen.structure.MapGenNetherBridge;
import net.minecraft.world.gen.structure.MapGenScatteredFeature;
import net.minecraft.world.gen.structure.MapGenStronghold;
import net.minecraft.world.gen.structure.MapGenVillage;
import net.minecraft.world.gen.structure.StructureOceanMonument;
import net.minecraft.world.gen.structure.StructureStart;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.InitMapGenEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.minecraftforge.fml.common.eventhandler.Event;

public class GenericChunkGenerator
implements IChunkGenerator {
    public Random rand;
    public long seed;
    private World worldObj;
    public DimensionInformation dimensionInformation;
    public WorldType worldType;
    private final BaseTerrainGenerator terrainGenerator;
    private ChunkProviderSettings settings = new ChunkProviderSettings.Factory().func_177864_b();
    private List<Biome.SpawnListEntry> extraSpawns;
    private List<Integer> extraSpawnsMax;
    public Biome[] biomesForGeneration;
    private MapGenBase caveGenerator = new MapGenCaves();
    private MapGenTendrils tendrilGenerator = new MapGenTendrils(this);
    private MapGenCanyons canyonGenerator = new MapGenCanyons(this);
    private MapGenPyramids pyramidGenerator = new MapGenPyramids(this);
    private MapGenOrbs sphereGenerator = new MapGenOrbs(this, false);
    private MapGenOrbs hugeSphereGenerator = new MapGenOrbs(this, true);
    private MapGenRuinedCities ruinedCitiesGenerator = new MapGenRuinedCities(this);
    private MapGenLiquidOrbs liquidSphereGenerator = new MapGenLiquidOrbs(this, false);
    private MapGenLiquidOrbs hugeLiquidSphereGenerator = new MapGenLiquidOrbs(this, true);
    private MapGenBase denseCaveGenerator = new MapGenDenseCaves(this);
    private MapGenStronghold strongholdGenerator = new MapGenStronghold(){

        protected boolean func_75047_a(int chunkX, int chunkZ) {
            return GenericChunkGenerator.this.canSpawnStructureIgnoringBiomes(chunkX, chunkZ, 10387313);
        }
    };
    private StructureOceanMonument oceanMonumentGenerator = new StructureOceanMonument(){

        protected boolean func_75047_a(int chunkX, int chunkZ) {
            return GenericChunkGenerator.this.canSpawnStructureIgnoringBiomes(chunkX, chunkZ, 10387313);
        }
    };
    private MapGenVillage villageGenerator = new MapGenVillage(){

        protected boolean func_75047_a(int chunkX, int chunkZ) {
            return GenericChunkGenerator.this.canSpawnStructureIgnoringBiomes(chunkX, chunkZ, 10387312);
        }
    };
    private MapGenMineshaft mineshaftGenerator = new MapGenMineshaft();
    private MapGenNetherBridge genNetherBridge = new MapGenNetherBridge();
    private MapGenSwampHut genSwampHut = new MapGenSwampHut();
    private MapGenDesertTemple genDesertTemple = new MapGenDesertTemple();
    private MapGenJungleTemple genJungleTemple = new MapGenJungleTemple();
    private MapGenIgloo genIgloo = new MapGenIgloo();
    private MapGenScatteredFeature scatteredFeatureGenerator = new MapGenScatteredFeature(){

        protected boolean func_75047_a(int chunkX, int chunkZ) {
            return GenericChunkGenerator.this.canSpawnStructureIgnoringBiomes(chunkX, chunkZ, 14357617);
        }

        protected StructureStart func_75049_b(int chunkX, int chunkZ) {
            StructureStart start = super.func_75049_b(chunkX, chunkZ);
            if (start.func_186161_c().isEmpty()) {
                switch (this.field_75038_b.nextInt(4)) {
                    case 0: {
                        start.func_186161_c().add(new ComponentScatteredFeaturePieces.SwampHut(this.field_75038_b, chunkX * 16, chunkZ * 16));
                        break;
                    }
                    case 1: {
                        start.func_186161_c().add(new ComponentScatteredFeaturePieces.Igloo(this.field_75038_b, chunkX * 16, chunkZ * 16));
                        break;
                    }
                    case 2: {
                        start.func_186161_c().add(new ComponentScatteredFeaturePieces.DesertPyramid(this.field_75038_b, chunkX * 16, chunkZ * 16));
                        break;
                    }
                    case 3: {
                        start.func_186161_c().add(new ComponentScatteredFeaturePieces.JunglePyramid(this.field_75038_b, chunkX * 16, chunkZ * 16));
                    }
                }
                start.func_75072_c();
            }
            return start;
        }
    };
    private MapGenBase ravineGenerator = new MapGenRavine();

    private boolean canSpawnStructureIgnoringBiomes(int chunkX, int chunkZ, int randseed) {
        int i = chunkX;
        int j = chunkZ;
        int distance = 16;
        int seperation = 8;
        if (chunkX < 0) {
            chunkX -= distance - 1;
        }
        if (chunkZ < 0) {
            chunkZ -= distance - 1;
        }
        int k = chunkX / distance;
        int l = chunkZ / distance;
        Random random = this.worldObj.func_72843_D(k, l, randseed);
        k *= distance;
        l *= distance;
        return i == (k += random.nextInt(distance - seperation)) && j == (l += random.nextInt(distance - seperation));
    }

    public ChunkProviderSettings getSettings() {
        return this.settings;
    }

    public GenericChunkGenerator(World world, long seed) {
        this.caveGenerator = TerrainGen.getModdedMapGen((MapGenBase)this.caveGenerator, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.CAVE);
        this.strongholdGenerator = (MapGenStronghold)TerrainGen.getModdedMapGen((MapGenBase)this.strongholdGenerator, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.STRONGHOLD);
        this.villageGenerator = (MapGenVillage)TerrainGen.getModdedMapGen((MapGenBase)this.villageGenerator, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.VILLAGE);
        this.mineshaftGenerator = (MapGenMineshaft)TerrainGen.getModdedMapGen((MapGenBase)this.mineshaftGenerator, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.MINESHAFT);
        this.scatteredFeatureGenerator = (MapGenScatteredFeature)TerrainGen.getModdedMapGen((MapGenBase)this.scatteredFeatureGenerator, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.SCATTERED_FEATURE);
        this.ravineGenerator = TerrainGen.getModdedMapGen((MapGenBase)this.ravineGenerator, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.RAVINE);
        this.genNetherBridge = (MapGenNetherBridge)TerrainGen.getModdedMapGen((MapGenBase)this.genNetherBridge, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.NETHER_BRIDGE);
        this.oceanMonumentGenerator = (StructureOceanMonument)TerrainGen.getModdedMapGen((MapGenBase)this.oceanMonumentGenerator, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.OCEAN_MONUMENT);
        this.worldObj = world;
        this.dimensionInformation = RfToolsDimensionManager.getDimensionManager(world).getDimensionInformation(world.field_73011_w.getDimension());
        this.worldType = world.func_72912_H().func_76067_t();
        if (this.dimensionInformation.getTerrainType() == TerrainType.TERRAIN_AMPLIFIED) {
            this.worldType = WorldType.field_151360_e;
        } else if (this.dimensionInformation.getTerrainType() == TerrainType.TERRAIN_NORMAL && !WorldgenConfiguration.normalTerrainInheritsOverworld) {
            this.worldType = WorldType.field_77137_b;
        } else if (this.dimensionInformation.getTerrainType() == TerrainType.TERRAIN_FLAT) {
            this.worldType = WorldType.field_77138_c;
        }
        this.seed = seed;
        this.rand = new Random((seed + 516L) * 314L);
        switch (this.dimensionInformation.getTerrainType()) {
            case TERRAIN_VOID: {
                this.terrainGenerator = new VoidTerrainGenerator();
                break;
            }
            case TERRAIN_FLAT: {
                this.terrainGenerator = new FlatTerrainGenerator(63);
                break;
            }
            case TERRAIN_AMPLIFIED: {
                this.terrainGenerator = new AmplifiedTerrainGenerator();
                break;
            }
            case TERRAIN_NEARLANDS: {
                this.terrainGenerator = new NearlandsTerrainGenerator();
                break;
            }
            case TERRAIN_NORMAL: {
                this.terrainGenerator = new NormalTerrainGenerator();
                break;
            }
            case TERRAIN_ISLAND: {
                this.terrainGenerator = new IslandTerrainGenerator(0);
                break;
            }
            case TERRAIN_ISLANDS: {
                this.terrainGenerator = new IslandTerrainGenerator(4);
                break;
            }
            case TERRAIN_CHAOTIC: {
                this.terrainGenerator = new IslandTerrainGenerator(1);
                break;
            }
            case TERRAIN_PLATEAUS: {
                this.terrainGenerator = new IslandTerrainGenerator(3);
                break;
            }
            case TERRAIN_GRID: {
                this.terrainGenerator = new GridTerrainGenerator();
                break;
            }
            case TERRAIN_CAVERN: {
                this.terrainGenerator = new CavernTerrainGenerator(null);
                break;
            }
            case TERRAIN_LOW_CAVERN: {
                this.terrainGenerator = new CavernTerrainGenerator(CavernTerrainGenerator.CavernHeight.HEIGHT_128);
                break;
            }
            case TERRAIN_FLOODED_CAVERN: {
                this.terrainGenerator = new CavernTerrainGenerator(CavernTerrainGenerator.CavernHeight.HEIGHT_128);
                break;
            }
            case TERRAIN_LIQUID: {
                this.terrainGenerator = new LiquidTerrainGenerator();
                break;
            }
            case TERRAIN_SOLID: {
                this.terrainGenerator = new FlatTerrainGenerator(127);
                break;
            }
            case TERRAIN_WAVES: {
                this.terrainGenerator = new WavesTerrainGenerator(false);
                break;
            }
            case TERRAIN_FILLEDWAVES: {
                this.terrainGenerator = new WavesTerrainGenerator(true);
                break;
            }
            case TERRAIN_ROUGH: {
                this.terrainGenerator = new RoughTerrainGenerator(false);
                break;
            }
            default: {
                this.terrainGenerator = new VoidTerrainGenerator();
            }
        }
        this.terrainGenerator.setup(world, this);
        this.extraSpawns = new ArrayList<Biome.SpawnListEntry>();
        this.extraSpawnsMax = new ArrayList<Integer>();
        for (MobDescriptor mob : this.dimensionInformation.getExtraMobs()) {
            Class<? extends Entity> entityClass = mob.getEntityClass();
            this.extraSpawns.add(new Biome.SpawnListEntry(entityClass, mob.getSpawnChance(), mob.getMinGroup(), mob.getMaxGroup()));
            this.extraSpawnsMax.add(mob.getMaxLoaded());
        }
    }

    public Chunk func_185932_a(int chunkX, int chunkZ) {
        this.rand.setSeed((long)chunkX * 341873128712L + (long)chunkZ * 132897987541L);
        ChunkPrimer chunkprimer = new ChunkPrimer();
        this.biomesForGeneration = this.worldObj.func_72959_q().func_76937_a(this.biomesForGeneration, chunkX * 4 - 2, chunkZ * 4 - 2, 10, 10);
        this.terrainGenerator.generate(chunkX, chunkZ, chunkprimer);
        this.biomesForGeneration = this.worldObj.func_72959_q().func_76933_b(this.biomesForGeneration, chunkX * 16, chunkZ * 16, 16, 16);
        this.terrainGenerator.replaceBlocksForBiome(chunkX, chunkZ, chunkprimer, this.biomesForGeneration);
        if (this.dimensionInformation.hasFeatureType(FeatureType.FEATURE_TENDRILS)) {
            this.tendrilGenerator.generate(this.worldObj, chunkX, chunkZ, chunkprimer);
        }
        if (this.dimensionInformation.hasFeatureType(FeatureType.FEATURE_CANYONS)) {
            this.canyonGenerator.generate(this.worldObj, chunkX, chunkZ, chunkprimer);
        }
        if (this.dimensionInformation.hasFeatureType(FeatureType.FEATURE_PYRAMIDS)) {
            this.pyramidGenerator.generate(this.worldObj, chunkX, chunkZ, chunkprimer);
        }
        if (this.dimensionInformation.hasFeatureType(FeatureType.FEATURE_ORBS)) {
            this.sphereGenerator.generate(this.worldObj, chunkX, chunkZ, chunkprimer);
        }
        if (this.dimensionInformation.hasFeatureType(FeatureType.FEATURE_HUGEORBS)) {
            this.hugeSphereGenerator.generate(this.worldObj, chunkX, chunkZ, chunkprimer);
        }
        if (this.dimensionInformation.hasFeatureType(FeatureType.FEATURE_LIQUIDORBS)) {
            this.liquidSphereGenerator.generate(this.worldObj, chunkX, chunkZ, chunkprimer);
        }
        if (this.dimensionInformation.hasFeatureType(FeatureType.FEATURE_HUGELIQUIDORBS)) {
            this.hugeLiquidSphereGenerator.generate(this.worldObj, chunkX, chunkZ, chunkprimer);
        }
        if (this.dimensionInformation.hasFeatureType(FeatureType.FEATURE_CAVES)) {
            this.caveGenerator.func_186125_a(this.worldObj, chunkX, chunkZ, chunkprimer);
        }
        if (this.dimensionInformation.hasFeatureType(FeatureType.FEATURE_DENSE_CAVES)) {
            this.denseCaveGenerator.func_186125_a(this.worldObj, chunkX, chunkZ, chunkprimer);
        }
        if (this.dimensionInformation.hasFeatureType(FeatureType.FEATURE_RAVINES)) {
            this.ravineGenerator.func_186125_a(this.worldObj, chunkX, chunkZ, chunkprimer);
        }
        if (this.dimensionInformation.hasStructureType(StructureType.STRUCTURE_MINESHAFT)) {
            this.mineshaftGenerator.func_186125_a(this.worldObj, chunkX, chunkZ, chunkprimer);
        }
        if (this.dimensionInformation.hasStructureType(StructureType.STRUCTURE_VILLAGE)) {
            this.villageGenerator.func_186125_a(this.worldObj, chunkX, chunkZ, chunkprimer);
        }
        if (this.dimensionInformation.hasStructureType(StructureType.STRUCTURE_STRONGHOLD)) {
            this.strongholdGenerator.func_186125_a(this.worldObj, chunkX, chunkZ, chunkprimer);
        }
        if (this.dimensionInformation.hasStructureType(StructureType.STRUCTURE_FORTRESS)) {
            this.genNetherBridge.func_186125_a(this.worldObj, chunkX, chunkZ, chunkprimer);
        }
        if (this.dimensionInformation.hasStructureType(StructureType.STRUCTURE_SCATTERED)) {
            this.scatteredFeatureGenerator.func_186125_a(this.worldObj, chunkX, chunkZ, chunkprimer);
        }
        if (this.dimensionInformation.hasStructureType(StructureType.STRUCTURE_SWAMPHUT)) {
            this.genSwampHut.func_186125_a(this.worldObj, chunkX, chunkZ, chunkprimer);
        }
        if (this.dimensionInformation.hasStructureType(StructureType.STRUCTURE_DESERTTEMPLE)) {
            this.genDesertTemple.func_186125_a(this.worldObj, chunkX, chunkZ, chunkprimer);
        }
        if (this.dimensionInformation.hasStructureType(StructureType.STRUCTURE_JUNGLETEMPLE)) {
            this.genJungleTemple.func_186125_a(this.worldObj, chunkX, chunkZ, chunkprimer);
        }
        if (this.dimensionInformation.hasStructureType(StructureType.STRUCTURE_IGLOO)) {
            this.genIgloo.func_186125_a(this.worldObj, chunkX, chunkZ, chunkprimer);
        }
        if (this.dimensionInformation.hasStructureType(StructureType.STRUCTURE_OCEAN_MONUMENT)) {
            this.oceanMonumentGenerator.func_186125_a(this.worldObj, chunkX, chunkZ, chunkprimer);
        }
        Chunk chunk = new Chunk(this.worldObj, chunkprimer, chunkX, chunkZ);
        byte[] abyte = chunk.func_76605_m();
        for (int i = 0; i < abyte.length; ++i) {
            abyte[i] = (byte)Biome.func_185362_a((Biome)this.biomesForGeneration[i]);
        }
        chunk.func_76603_b();
        return chunk;
    }

    public void func_185931_b(int chunkX, int chunkZ) {
        int i2;
        int l1;
        int k1;
        boolean flag;
        Biome Biome2;
        int z;
        int x;
        block18: {
            block19: {
                BlockFalling.field_149832_M = true;
                x = chunkX * 16;
                z = chunkZ * 16;
                Biome2 = this.worldObj.getBiomeForCoordsBody(new BlockPos(x + 16, 0, z + 16));
                this.rand.setSeed(this.worldObj.func_72905_C());
                long i1 = this.rand.nextLong() / 2L * 2L + 1L;
                long j1 = this.rand.nextLong() / 2L * 2L + 1L;
                this.rand.setSeed((long)chunkX * i1 + (long)chunkZ * j1 ^ this.worldObj.func_72905_C());
                flag = false;
                MinecraftForge.EVENT_BUS.post((Event)new PopulateChunkEvent.Pre((IChunkGenerator)this, this.worldObj, this.rand, chunkX, chunkZ, flag));
                ChunkPos cp = new ChunkPos(chunkX, chunkZ);
                if (this.dimensionInformation.hasStructureType(StructureType.STRUCTURE_MINESHAFT)) {
                    this.mineshaftGenerator.func_175794_a(this.worldObj, this.rand, cp);
                }
                if (this.dimensionInformation.hasStructureType(StructureType.STRUCTURE_VILLAGE)) {
                    flag = this.villageGenerator.func_175794_a(this.worldObj, this.rand, cp);
                }
                if (this.dimensionInformation.hasStructureType(StructureType.STRUCTURE_STRONGHOLD)) {
                    this.strongholdGenerator.func_175794_a(this.worldObj, this.rand, cp);
                }
                if (this.dimensionInformation.hasStructureType(StructureType.STRUCTURE_FORTRESS)) {
                    this.genNetherBridge.func_175794_a(this.worldObj, this.rand, cp);
                }
                if (this.dimensionInformation.hasStructureType(StructureType.STRUCTURE_SCATTERED)) {
                    this.scatteredFeatureGenerator.func_175794_a(this.worldObj, this.rand, cp);
                }
                if (this.dimensionInformation.hasStructureType(StructureType.STRUCTURE_SWAMPHUT)) {
                    this.genSwampHut.func_175794_a(this.worldObj, this.rand, cp);
                }
                if (this.dimensionInformation.hasStructureType(StructureType.STRUCTURE_DESERTTEMPLE)) {
                    this.genDesertTemple.func_175794_a(this.worldObj, this.rand, cp);
                }
                if (this.dimensionInformation.hasStructureType(StructureType.STRUCTURE_JUNGLETEMPLE)) {
                    this.genJungleTemple.func_175794_a(this.worldObj, this.rand, cp);
                }
                if (this.dimensionInformation.hasStructureType(StructureType.STRUCTURE_IGLOO)) {
                    this.genIgloo.func_175794_a(this.worldObj, this.rand, cp);
                }
                if (this.dimensionInformation.hasStructureType(StructureType.STRUCTURE_OCEAN_MONUMENT)) {
                    this.oceanMonumentGenerator.func_175794_a(this.worldObj, this.rand, cp);
                }
                if (!this.dimensionInformation.hasFeatureType(FeatureType.FEATURE_LAKES)) break block18;
                if (this.dimensionInformation.getFluidsForLakes().length != 0) break block19;
                if (Biome2 != Biomes.field_76769_d && Biome2 != Biomes.field_76786_s && !flag && this.rand.nextInt(4) == 0 && TerrainGen.populate((IChunkGenerator)this, (World)this.worldObj, (Random)this.rand, (int)chunkX, (int)chunkZ, (boolean)flag, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.LAKE)) {
                    k1 = x + this.rand.nextInt(16) + 8;
                    l1 = this.rand.nextInt(256);
                    i2 = z + this.rand.nextInt(16) + 8;
                    new WorldGenLakes((Block)Blocks.field_150355_j).func_180709_b(this.worldObj, this.rand, new BlockPos(k1, l1, i2));
                }
                if (!TerrainGen.populate((IChunkGenerator)this, (World)this.worldObj, (Random)this.rand, (int)chunkX, (int)chunkZ, (boolean)flag, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.LAVA) || flag || this.rand.nextInt(8) != 0) break block18;
                k1 = x + this.rand.nextInt(16) + 8;
                l1 = this.rand.nextInt(this.rand.nextInt(248) + 8);
                i2 = z + this.rand.nextInt(16) + 8;
                if (l1 >= 63 && this.rand.nextInt(10) != 0) break block18;
                new WorldGenLakes((Block)Blocks.field_150353_l).func_180709_b(this.worldObj, this.rand, new BlockPos(k1, l1, i2));
                break block18;
            }
            for (Block liquid : this.dimensionInformation.getFluidsForLakes()) {
                if (flag || this.rand.nextInt(4) != 0 || !TerrainGen.populate((IChunkGenerator)this, (World)this.worldObj, (Random)this.rand, (int)chunkX, (int)chunkZ, (boolean)flag, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.LAKE)) continue;
                k1 = x + this.rand.nextInt(16) + 8;
                l1 = this.rand.nextInt(256);
                i2 = z + this.rand.nextInt(16) + 8;
                new WorldGenLakes(liquid).func_180709_b(this.worldObj, this.rand, new BlockPos(k1, l1, i2));
            }
        }
        boolean doGen = false;
        if (this.dimensionInformation.hasStructureType(StructureType.STRUCTURE_DUNGEON)) {
            doGen = TerrainGen.populate((IChunkGenerator)this, (World)this.worldObj, (Random)this.rand, (int)chunkX, (int)chunkZ, (boolean)flag, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.DUNGEON);
            for (k1 = 0; doGen && k1 < 8; ++k1) {
                l1 = x + this.rand.nextInt(16) + 8;
                i2 = this.rand.nextInt(256);
                int j2 = z + this.rand.nextInt(16) + 8;
                new WorldGenDungeons().func_180709_b(this.worldObj, this.rand, new BlockPos(l1, i2, j2));
            }
        }
        Biome2.func_180624_a(this.worldObj, this.rand, new BlockPos(x, 0, z));
        if (TerrainGen.populate((IChunkGenerator)this, (World)this.worldObj, (Random)this.rand, (int)chunkX, (int)chunkZ, (boolean)flag, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.ANIMALS)) {
            WorldEntitySpawner.func_77191_a((World)this.worldObj, (Biome)Biome2, (int)(x + 8), (int)(z + 8), (int)16, (int)16, (Random)this.rand);
        }
        x += 8;
        z += 8;
        doGen = TerrainGen.populate((IChunkGenerator)this, (World)this.worldObj, (Random)this.rand, (int)chunkX, (int)chunkZ, (boolean)flag, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.ICE);
        for (k1 = 0; doGen && k1 < 16; ++k1) {
            for (l1 = 0; l1 < 16; ++l1) {
                i2 = this.worldObj.func_175725_q(new BlockPos(x + k1, 0, z + l1)).func_177956_o();
                if (this.worldObj.func_175670_e(new BlockPos(k1 + x, i2 - 1, l1 + z), false)) {
                    this.worldObj.func_180501_a(new BlockPos(k1 + x, i2 - 1, l1 + z), Blocks.field_150432_aD.func_176223_P(), 2);
                }
                if (!this.worldObj.func_175708_f(new BlockPos(k1 + x, i2, l1 + z), true)) continue;
                this.worldObj.func_180501_a(new BlockPos(k1 + x, i2, l1 + z), Blocks.field_150431_aC.func_176223_P(), 2);
            }
        }
        MinecraftForge.EVENT_BUS.post((Event)new PopulateChunkEvent.Post((IChunkGenerator)this, this.worldObj, this.rand, chunkX, chunkZ, flag));
        BlockFalling.field_149832_M = false;
    }

    public boolean func_185933_a(Chunk chunkIn, int x, int z) {
        boolean flag = false;
        if (this.dimensionInformation.hasStructureType(StructureType.STRUCTURE_OCEAN_MONUMENT) && chunkIn.func_177416_w() < 3600L) {
            flag |= this.oceanMonumentGenerator.func_175794_a(this.worldObj, this.rand, new ChunkPos(x, z));
        }
        return flag;
    }

    public List<Biome.SpawnListEntry> func_177458_a(EnumCreatureType creatureType, BlockPos pos) {
        ArrayList<Biome.SpawnListEntry> creatures;
        block4: {
            block3: {
                creatures = this.getDefaultCreatures(creatureType, pos);
                if (this.extraSpawns.isEmpty()) {
                    return creatures;
                }
                if (creatureType != EnumCreatureType.AMBIENT) break block3;
                creatures = new ArrayList<Biome.SpawnListEntry>(creatures);
                for (int i = 0; i < this.extraSpawns.size(); ++i) {
                    int count;
                    Class entityClass = this.extraSpawns.get((int)i).field_76300_b;
                    if (entityClass == null || !IAnimals.class.isAssignableFrom(entityClass) || (count = this.worldObj.func_72907_a(entityClass)) >= this.extraSpawnsMax.get(i)) continue;
                    creatures.add(this.extraSpawns.get(i));
                }
                break block4;
            }
            if (creatureType != EnumCreatureType.MONSTER) break block4;
            creatures = new ArrayList<Biome.SpawnListEntry>(creatures);
            for (int i = 0; i < this.extraSpawns.size(); ++i) {
                int count;
                Class entityClass = this.extraSpawns.get((int)i).field_76300_b;
                if (entityClass == null || !IMob.class.isAssignableFrom(entityClass) || (count = this.worldObj.func_72907_a(entityClass)) >= this.extraSpawnsMax.get(i)) continue;
                creatures.add(this.extraSpawns.get(i));
            }
        }
        return creatures;
    }

    private List getDefaultCreatures(EnumCreatureType creatureType, BlockPos pos) {
        Biome Biome2 = this.worldObj.getBiomeForCoordsBody(pos);
        if (creatureType == EnumCreatureType.MONSTER) {
            if (this.dimensionInformation.isPeaceful()) {
                return Collections.emptyList();
            }
            if (this.dimensionInformation.hasStructureType(StructureType.STRUCTURE_SCATTERED) && this.scatteredFeatureGenerator.func_175795_b(pos)) {
                return this.scatteredFeatureGenerator.func_82667_a();
            }
            if (this.dimensionInformation.hasStructureType(StructureType.STRUCTURE_SWAMPHUT) && this.genSwampHut.func_175798_a(pos)) {
                return this.genSwampHut.getScatteredFeatureSpawnList();
            }
            if (this.dimensionInformation.hasStructureType(StructureType.STRUCTURE_DESERTTEMPLE) && this.genDesertTemple.func_175798_a(pos)) {
                return this.genDesertTemple.getScatteredFeatureSpawnList();
            }
            if (this.dimensionInformation.hasStructureType(StructureType.STRUCTURE_JUNGLETEMPLE) && this.genJungleTemple.func_175798_a(pos)) {
                return this.genJungleTemple.getScatteredFeatureSpawnList();
            }
            if (this.dimensionInformation.hasStructureType(StructureType.STRUCTURE_IGLOO) && this.genIgloo.func_175798_a(pos)) {
                return this.genIgloo.getScatteredFeatureSpawnList();
            }
            if (this.dimensionInformation.hasStructureType(StructureType.STRUCTURE_FORTRESS)) {
                if (this.genNetherBridge.func_175795_b(pos)) {
                    return this.genNetherBridge.func_75059_a();
                }
                if (this.genNetherBridge.func_175796_a(this.worldObj, pos) && this.worldObj.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150385_bj) {
                    return this.genNetherBridge.func_75059_a();
                }
            }
            if (this.dimensionInformation.hasStructureType(StructureType.STRUCTURE_OCEAN_MONUMENT) && this.oceanMonumentGenerator.func_175796_a(this.worldObj, pos)) {
                return this.oceanMonumentGenerator.func_175799_b();
            }
        } else if (creatureType == EnumCreatureType.AMBIENT && this.dimensionInformation.isNoanimals()) {
            return Collections.emptyList();
        }
        return Biome2.func_76747_a(creatureType);
    }

    public BlockPos func_180513_a(World worldIn, String structureName, BlockPos position) {
        return "Stronghold".equals(structureName) && this.strongholdGenerator != null ? this.strongholdGenerator.func_180706_b(worldIn, position) : null;
    }

    public void func_180514_a(Chunk chunkIn, int x, int z) {
        if (this.dimensionInformation.hasStructureType(StructureType.STRUCTURE_FORTRESS)) {
            this.genNetherBridge.func_186125_a(this.worldObj, x, z, null);
        }
        if (this.dimensionInformation.hasStructureType(StructureType.STRUCTURE_MINESHAFT)) {
            this.mineshaftGenerator.func_186125_a(this.worldObj, x, z, null);
        }
        if (this.dimensionInformation.hasStructureType(StructureType.STRUCTURE_VILLAGE)) {
            this.villageGenerator.func_186125_a(this.worldObj, x, z, null);
        }
        if (this.dimensionInformation.hasStructureType(StructureType.STRUCTURE_STRONGHOLD)) {
            this.strongholdGenerator.func_186125_a(this.worldObj, x, z, null);
        }
        if (this.dimensionInformation.hasStructureType(StructureType.STRUCTURE_SCATTERED)) {
            this.scatteredFeatureGenerator.func_186125_a(this.worldObj, x, z, null);
        }
        if (this.dimensionInformation.hasStructureType(StructureType.STRUCTURE_SWAMPHUT)) {
            this.genSwampHut.func_186125_a(this.worldObj, x, z, null);
        }
        if (this.dimensionInformation.hasStructureType(StructureType.STRUCTURE_DESERTTEMPLE)) {
            this.genDesertTemple.func_186125_a(this.worldObj, x, z, null);
        }
        if (this.dimensionInformation.hasStructureType(StructureType.STRUCTURE_JUNGLETEMPLE)) {
            this.genJungleTemple.func_186125_a(this.worldObj, x, z, null);
        }
        if (this.dimensionInformation.hasStructureType(StructureType.STRUCTURE_IGLOO)) {
            this.genIgloo.func_186125_a(this.worldObj, x, z, null);
        }
        if (this.dimensionInformation.hasStructureType(StructureType.STRUCTURE_OCEAN_MONUMENT)) {
            this.oceanMonumentGenerator.func_186125_a(this.worldObj, x, z, null);
        }
    }
}

