/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.dimensions.world;

import java.util.Random;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.WeightedRandomSelector;
import mcjty.rftoolsdim.RFToolsDim;
import mcjty.rftoolsdim.blocks.ModBlocks;
import mcjty.rftoolsdim.blocks.shards.AbstractDirectionalBlock;
import mcjty.rftoolsdim.config.WorldgenConfiguration;
import mcjty.rftoolsdim.dimensions.DimensionInformation;
import mcjty.rftoolsdim.dimensions.RfToolsDimensionManager;
import mcjty.rftoolsdim.dimensions.dimlets.DimletKey;
import mcjty.rftoolsdim.dimensions.dimlets.DimletRandomizer;
import mcjty.rftoolsdim.dimensions.dimlets.KnownDimletConfiguration;
import mcjty.rftoolsdim.dimensions.dimlets.types.Patreons;
import mcjty.rftoolsdim.dimensions.types.FeatureType;
import mcjty.rftoolsdim.dimensions.types.TerrainType;
import mcjty.rftoolsdim.dimensions.world.WorldGenerationTools;
import mcjty.rftoolsdim.items.ModItems;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class GenericWorldGenerator
implements IWorldGenerator {
    private static int[][] puppeteerSpawnPlatform = new int[][]{{-1, -1, -1, -1, -1, -1, -1, -1, 15, 15, 15, 15, 15, 15, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, -1, -1, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, -1, -1, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, -1, -1, -1, -1, -1}, {-1, -1, -1, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, -1, -1, -1, -1}, {-1, -1, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, -1, -1, -1}, {-1, -1, 15, 15, 15, 15, 0, 0, 0, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, -1, -1, -1}, {-1, 15, 15, 15, 15, 0, 0, 0, 0, 0, 15, 15, 15, 0, 15, 15, 15, 0, 15, 15, 15, 15, -1, -1}, {-1, 15, 15, 15, 0, 0, 15, 0, 15, 0, 0, 15, 15, 15, 0, 15, 0, 15, 15, 15, 15, 15, -1, -1}, {15, 15, 15, 15, 0, 0, 0, 0, 0, 0, 0, 15, 15, 15, 15, 0, 15, 15, 15, 15, 15, 15, 15, -1}, {15, 15, 15, 15, 0, 0, 15, 0, 15, 0, 0, 15, 15, 15, 0, 15, 0, 15, 15, 15, 15, 15, 15, -1}, {15, 15, 15, 15, 15, 0, 0, 0, 0, 0, 15, 15, 15, 0, 15, 15, 15, 0, 15, 15, 15, 15, 15, -1}, {15, 15, 15, 15, 15, 15, 0, 0, 0, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, -1}, {15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, -1}, {15, 15, 15, 15, 15, 15, 15, 15, 15, 15, -2, 15, 0, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, -1}, {15, 15, 15, 15, 15, 15, 15, 15, 0, 15, 0, 15, 0, 15, 0, 15, 15, 15, 15, 15, 15, 15, 15, -1}, {-1, 15, 15, 15, 15, 15, 0, 15, 0, 15, 0, 15, 0, 15, 0, 15, 0, 15, 15, 15, 15, 15, -1, -1}, {-1, 15, 15, 15, 15, 15, 0, 15, 0, 15, 0, 15, 0, 15, 0, 15, 0, 15, 15, 15, 15, 15, -1, -1}, {-1, -1, 15, 15, 15, 15, 0, 15, 0, 15, 0, 15, 0, 15, 0, 15, 0, 15, 15, 15, 15, -1, -1, -1}, {-1, -1, 15, 15, 15, 15, 15, 15, 0, 15, 0, 15, 0, 15, 0, 15, 15, 15, 15, 15, 15, -1, -1, -1}, {-1, -1, -1, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, -1, -1, -1, -1}, {-1, -1, -1, -1, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, -1, -1, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, -1, -1, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, -1, -1, -1, -1, 15, 15, 15, 15, 15, 15, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}};

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        RfToolsDimensionManager manager = RfToolsDimensionManager.getDimensionManager(world);
        if (manager.getDimensionDescriptor(world.field_73011_w.getDimension()) == null) {
            return;
        }
        DimensionInformation information = manager.getDimensionInformation(world.field_73011_w.getDimension());
        IBlockState baseBlock = information.getBaseBlockForTerrain();
        if (information.hasFeatureType(FeatureType.FEATURE_OREGEN)) {
            for (IBlockState block : information.getExtraOregen()) {
                this.addOreSpawn(block, baseBlock, world, random, chunkX * 16, chunkZ * 16, 7, 10, 12, 2, 60);
            }
        }
        Block dimensionalShardBlock = GameRegistry.findBlock((String)"rftools", (String)"dimensional_shard_ore");
        this.addOreSpawn(dimensionalShardBlock.func_176223_P(), Blocks.field_150348_b.func_176223_P(), world, random, chunkX * 16, chunkZ * 16, WorldgenConfiguration.oreMinimumVeinSize, WorldgenConfiguration.oreMaximumVeinSize, WorldgenConfiguration.oreMaximumVeinCount, WorldgenConfiguration.oreMinimumHeight, WorldgenConfiguration.oreMaximumHeight);
        if (information.isPatreonBitSet(Patreons.PATREON_PUPPETEER) && Math.abs(chunkX) <= 1 && Math.abs(chunkZ) <= 1) {
            this.generateBigSpawnPlatform(world, chunkX, chunkZ, puppeteerSpawnPlatform);
        } else if (chunkX == 0 && chunkZ == 0) {
            this.generateSpawnPlatform(world);
        } else if (!(Math.abs(chunkX) <= 6 && Math.abs(chunkZ) <= 6 || information.hasFeatureType(FeatureType.FEATURE_NODIMLETBUILDINGS) || random.nextInt(WorldgenConfiguration.dungeonChance) != 1)) {
            this.generateDimletDungeon(random, chunkX, chunkZ, world);
        }
        if ((Math.abs(chunkX) >= 2 || Math.abs(chunkZ) >= 2) && information.isPatreonBitSet(Patreons.PATREON_COLOREDPRISMS) && random.nextInt(10) == 1) {
            this.generatePrism(chunkX, chunkZ, world);
        }
        if ((Math.abs(chunkX) >= 1 || Math.abs(chunkZ) >= 1) && information.isPatreonBitSet(Patreons.PATREON_PINKPILLARS) && random.nextInt(2) == 1) {
            this.generatePillar(random, chunkX, chunkZ, world);
        }
        if ((Math.abs(chunkX) >= 3 || Math.abs(chunkZ) >= 3) && information.hasFeatureType(FeatureType.FEATURE_VOLCANOES) && random.nextInt(WorldgenConfiguration.volcanoChance) == 1) {
            this.generateVolcano(random, chunkX, chunkZ, world);
        }
    }

    private void generateDimletDungeon(Random random, int chunkX, int chunkZ, World world) {
        int starty4;
        int starty3;
        int starty2;
        int midx = chunkX * 16 + 8;
        int midz = chunkZ * 16 + 8;
        int starty1 = WorldGenerationTools.findSuitableEmptySpot(world, midx - 3, midz - 3);
        int starty = (starty1 + (starty2 = WorldGenerationTools.findSuitableEmptySpot(world, midx + 3, midz - 3)) + (starty3 = WorldGenerationTools.findSuitableEmptySpot(world, midx - 3, midz + 3)) + (starty4 = WorldGenerationTools.findSuitableEmptySpot(world, midx + 3, midz + 3))) / 4;
        if (starty > 1 && starty < world.func_72800_K() - 20) {
            this.generateDungeon(world, random, midx, starty, midz);
        }
    }

    private void generateVolcano(Random random, int chunkX, int chunkZ, World world) {
        int x = chunkX * 16 + random.nextInt(16);
        int z = chunkZ * 16 + random.nextInt(16);
        int cntsolid = 0;
        for (int y = world.func_175672_r(new BlockPos(x, 0, z)).func_177956_o(); y > 3; --y) {
            if (WorldGenerationTools.isSolid(world, x, y, z)) {
                if (++cntsolid <= 5) continue;
                Logging.log((String)("Spawned volcano block at " + x + "," + y + "," + z));
                break;
            }
            cntsolid = 0;
        }
    }

    private void generatePrism(int chunkX, int chunkZ, World world) {
        int x = chunkX * 16 + 8;
        int z = chunkZ * 16 + 8;
        int y = world.func_175672_r(new BlockPos(x, 0, z)).func_177956_o();
        int y1 = world.func_175672_r(new BlockPos(x - 7, 0, z - 7)).func_177956_o();
        if (y1 < y) {
            y = y1;
        }
        if ((y1 = world.func_175672_r(new BlockPos(x + 7, 0, z - 7)).func_177956_o()) < y) {
            y = y1;
        }
        if ((y1 = world.func_175672_r(new BlockPos(x - 7, 0, z + 7)).func_177956_o()) < y) {
            y = y1;
        }
        if ((y1 = world.func_175672_r(new BlockPos(x + 7, 0, z + 7)).func_177956_o()) < y) {
            y = y1;
        }
        if (y > 10 && y < 230) {
            for (int i = 7; i >= 0; --i) {
                if (i == 0) {
                    this.setStainedGlassIfAir(world, x, y, z, i);
                } else {
                    for (int j = -i; j <= i - 1; ++j) {
                        this.setStainedGlassIfAir(world, x + j + 1, y, z + i, i);
                        this.setStainedGlassIfAir(world, x + i, y, z + j, i);
                        this.setStainedGlassIfAir(world, x - j - 1, y, z - i, i);
                        this.setStainedGlassIfAir(world, x - i, y, z - j, i);
                    }
                }
                ++y;
            }
        }
    }

    private void setStainedGlassIfAir(World world, int x, int y, int z, int i) {
        if (world.func_175623_d(new BlockPos(x, y, z))) {
            world.func_180501_a(new BlockPos(x, y, z), Blocks.field_150399_cn.func_176203_a(i), 2);
        }
    }

    private void generatePillar(Random random, int chunkX, int chunkZ, World world) {
        int z;
        int x = chunkX * 16 + random.nextInt(16);
        int y = world.func_175672_r(new BlockPos(x, 0, z = chunkZ * 16 + random.nextInt(16))).func_177956_o();
        if (y > 10 && y < 240) {
            for (int i = 0; i < random.nextInt(3) + 2; ++i) {
                world.func_180501_a(new BlockPos(x, y++, z), Blocks.field_150406_ce.func_176203_a(6), 2);
            }
            world.func_180501_a(new BlockPos(x, y, z), Blocks.field_150399_cn.func_176203_a(6), 2);
        }
    }

    private boolean isReceiverPresent(World world, int midx, int midz, int starty, int[][] platform) {
        int r = platform.length;
        int sx = -r / 2;
        int sz = -r / 2;
        for (int x = sx; x < sx + r; ++x) {
            for (int z = sz; z < sz + r; ++z) {
                int color = platform[r - x - r / 2 - 1][z + r / 2];
                if (color != -2 || RFToolsDim.teleportationManager.getReceiverName(world, new BlockPos(x + midx, starty, z + midz)) == null) continue;
                return true;
            }
        }
        return false;
    }

    private void generateBigSpawnPlatform(World world, int chunkX, int chunkZ, int[][] platform) {
        RfToolsDimensionManager dimensionManager = RfToolsDimensionManager.getDimensionManager(world);
        DimensionInformation information = dimensionManager.getDimensionInformation(world.field_73011_w.getDimension());
        int midx = 8;
        int midz = 8;
        int starty = WorldGenerationTools.findSuitableEmptySpot(world, midx, midz);
        starty = starty == -1 ? 64 : ++starty;
        if (this.isReceiverPresent(world, midx, midz, starty - 1, platform)) {
            --starty;
        }
        int r = platform.length;
        int sx = -r / 2;
        int sz = -r / 2;
        for (int x = sx; x < sx + r; ++x) {
            int cx = x + midx >> 4;
            if (chunkX != cx) continue;
            for (int z = sz; z < sz + r; ++z) {
                int cz = z + midz >> 4;
                if (chunkZ != cz) continue;
                int color = platform[r - x - r / 2 - 1][z + r / 2];
                if (color == -2) {
                    RFToolsDim.teleportationManager.createReceiver(world, new BlockPos(x + midx, starty, z + midz), information.getName(), -1);
                } else if (color != -1) {
                    world.func_180501_a(new BlockPos(x + midx, starty, z + midz), Blocks.field_150406_ce.func_176203_a(color), 2);
                } else {
                    world.func_175698_g(new BlockPos(x + midx, starty, z + midz));
                }
                for (int y = 1; y <= 3; ++y) {
                    world.func_175698_g(new BlockPos(x + midx, starty + y, z + midz));
                }
            }
        }
        if (chunkX == 0 && chunkZ == 0) {
            this.registerReceiver(world, dimensionManager, information, midx, midz, starty);
        }
    }

    private void generateSpawnPlatform(World world) {
        int z;
        int x;
        System.out.println("GenericWorldGenerator.generateSpawnPlatform");
        RfToolsDimensionManager dimensionManager = RfToolsDimensionManager.getDimensionManager(world);
        DimensionInformation information = dimensionManager.getDimensionInformation(world.field_73011_w.getDimension());
        int midx = 8;
        int midz = 8;
        int starty = information.getTerrainType() == TerrainType.TERRAIN_SOLID ? 64 : WorldGenerationTools.findSuitableEmptySpot(world, midx, midz);
        starty = starty == -1 ? 64 : ++starty;
        boolean shelter = information.isShelter();
        if (information.getTerrainType() == TerrainType.TERRAIN_LIQUID) {
            shelter = true;
        }
        int bounds = 3;
        if (shelter) {
            bounds = 4;
        }
        for (x = -bounds; x <= bounds; ++x) {
            for (z = -bounds; z <= bounds; ++z) {
                if (x == 0 && z == 0) {
                    RFToolsDim.teleportationManager.createReceiver(world, new BlockPos(x + midx, starty, z + midz), information.getName(), -1);
                } else if (x == 0 && (z == 2 || z == -2)) {
                    world.func_180501_a(new BlockPos(x + midx, starty, z + midz), Blocks.field_150426_aN.func_176223_P(), 3);
                } else {
                    world.func_180501_a(new BlockPos(x + midx, starty, z + midz), Blocks.field_150406_ce.func_176203_a(3), 2);
                }
                for (int y = 1; y <= 3; ++y) {
                    world.func_175698_g(new BlockPos(x + midx, starty + y, z + midz));
                }
                if (world.func_175623_d(new BlockPos(x + midx, starty + 4, z + midz))) continue;
                world.func_180501_a(new BlockPos(x + midx, starty + 4, z + midz), Blocks.field_150406_ce.func_176203_a(3), 2);
            }
        }
        if (shelter) {
            for (int y = 1; y <= 3; ++y) {
                for (int x2 = -bounds; x2 <= bounds; ++x2) {
                    for (int z2 = -bounds; z2 <= bounds; ++z2) {
                        if (x2 != -bounds && x2 != bounds && z2 != -bounds && z2 != bounds) continue;
                        if (z2 == 0 && y >= 2 && y <= 3 || x2 == 0 && y >= 2 && y <= 3 && z2 == bounds) {
                            world.func_180501_a(new BlockPos(x2 + midx, starty + y, z2 + midz), Blocks.field_150410_aZ.func_176203_a(0), 2);
                            continue;
                        }
                        if (x2 == 0 && y == 1 && z2 == -bounds) {
                            world.func_180501_a(new BlockPos(x2 + midx, starty + y, z2 + midz), Blocks.field_150454_av.func_176203_a(1), 2);
                            continue;
                        }
                        if (x2 == 0 && y == 2 && z2 == -bounds) {
                            world.func_180501_a(new BlockPos(x2 + midx, starty + y, z2 + midz), Blocks.field_150454_av.func_176203_a(8), 2);
                            continue;
                        }
                        world.func_180501_a(new BlockPos(x2 + midx, starty + y, z2 + midz), Blocks.field_150406_ce.func_176203_a(9), 2);
                    }
                }
            }
            for (x = -bounds; x <= bounds; ++x) {
                for (z = -bounds; z <= bounds; ++z) {
                    world.func_180501_a(new BlockPos(x + midx, starty + 4, z + midz), Blocks.field_150406_ce.func_176203_a(9), 2);
                }
            }
            world.func_180501_a(new BlockPos(midx - 1, starty + 2, midz - bounds - 1), Blocks.field_150430_aB.func_176203_a(4), 2);
            world.func_180501_a(new BlockPos(midx + 1, starty + 2, midz - bounds + 1), Blocks.field_150430_aB.func_176203_a(3), 2);
            world.func_180501_a(new BlockPos(midx + 1, starty, midz - bounds - 1), Blocks.field_150406_ce.func_176203_a(3), 2);
            world.func_180501_a(new BlockPos(midx, starty, midz - bounds - 1), Blocks.field_150406_ce.func_176203_a(3), 2);
            world.func_180501_a(new BlockPos(midx - 1, starty, midz - bounds - 1), Blocks.field_150406_ce.func_176203_a(3), 2);
            world.func_180501_a(new BlockPos(midx + 1, starty, midz - bounds - 2), Blocks.field_150406_ce.func_176203_a(3), 2);
            world.func_180501_a(new BlockPos(midx, starty, midz - bounds - 2), Blocks.field_150406_ce.func_176203_a(3), 2);
            world.func_180501_a(new BlockPos(midx - 1, starty, midz - bounds - 2), Blocks.field_150406_ce.func_176203_a(3), 2);
        }
        this.registerReceiver(world, dimensionManager, information, midx, midz, starty);
    }

    private void registerReceiver(World world, RfToolsDimensionManager dimensionManager, DimensionInformation information, int midx, int midz, int starty) {
        information.setSpawnPoint(new BlockPos(midx, starty, midz));
        dimensionManager.save(world);
    }

    private void generateDungeon(World world, Random random, int midx, int starty, int midz) {
        int i;
        int x;
        AbstractDirectionalBlock cornerBlock;
        boolean doSmallAntenna = random.nextInt(4) == 0;
        boolean doExtraFeature = random.nextInt(4) == 0;
        switch (random.nextInt(3)) {
            case 0: {
                cornerBlock = ModBlocks.dimensionalCrossBlock;
                break;
            }
            case 1: {
                cornerBlock = ModBlocks.dimensionalPattern1Block;
                break;
            }
            case 2: {
                cornerBlock = ModBlocks.dimensionalPattern2Block;
                break;
            }
            default: {
                cornerBlock = ModBlocks.dimensionalCross2Block;
            }
        }
        Block buildingBlock = Blocks.field_150406_ce;
        int color = random.nextInt(5);
        if (color == 0) {
            color = 3;
        } else if (color == 1) {
            color = 9;
        } else if (color == 2) {
            color = 11;
        } else {
            color = 0;
            buildingBlock = ModBlocks.dimensionalBlankBlock;
        }
        for (x = midx - 3; x <= midx + 3; ++x) {
            for (int z = midz - 3; z <= midz + 3; ++z) {
                boolean corner = !(x != midx - 3 && x != midx + 3 || z != midz - 3 && z != midz + 3);
                boolean xside = x == midx - 3 || x == midx + 3;
                boolean zside = z == midz - 3 || z == midz + 3;
                boolean antenna = x == midx - 2 && z == midz - 2;
                boolean smallAntenna = doSmallAntenna && x == midx + 2 && z == midz + 2;
                world.func_180501_a(new BlockPos(x, starty, z), Blocks.field_150334_T.func_176223_P(), 2);
                if (corner) {
                    world.func_180501_a(new BlockPos(x, starty + 1, z), cornerBlock.func_176203_a(1), 2);
                    world.func_180501_a(new BlockPos(x, starty + 2, z), cornerBlock.func_176203_a(1), 2);
                    world.func_180501_a(new BlockPos(x, starty + 3, z), cornerBlock.func_176203_a(1), 2);
                } else if (xside) {
                    world.func_180501_a(new BlockPos(x, starty + 1, z), buildingBlock.func_176203_a(color), 2);
                    if (z >= midz - 1 && z <= midz + 1) {
                        world.func_180501_a(new BlockPos(x, starty + 2, z), Blocks.field_150410_aZ.func_176203_a(0), 2);
                    } else {
                        world.func_180501_a(new BlockPos(x, starty + 2, z), buildingBlock.func_176203_a(color), 2);
                    }
                    world.func_180501_a(new BlockPos(x, starty + 3, z), buildingBlock.func_176203_a(color), 2);
                } else if (zside) {
                    world.func_180501_a(new BlockPos(x, starty + 1, z), buildingBlock.func_176203_a(color), 2);
                    world.func_180501_a(new BlockPos(x, starty + 2, z), buildingBlock.func_176203_a(color), 2);
                    world.func_180501_a(new BlockPos(x, starty + 3, z), buildingBlock.func_176203_a(color), 2);
                } else {
                    world.func_175698_g(new BlockPos(x, starty + 1, z));
                    world.func_175698_g(new BlockPos(x, starty + 2, z));
                    world.func_175698_g(new BlockPos(x, starty + 3, z));
                }
                if (antenna) {
                    world.func_180501_a(new BlockPos(x, starty + 4, z), Blocks.field_150334_T.func_176223_P(), 2);
                    world.func_180501_a(new BlockPos(x, starty + 5, z), Blocks.field_150411_aY.func_176223_P(), 2);
                    world.func_180501_a(new BlockPos(x, starty + 6, z), Blocks.field_150411_aY.func_176223_P(), 2);
                    world.func_180501_a(new BlockPos(x, starty + 7, z), Blocks.field_150411_aY.func_176223_P(), 2);
                    world.func_180501_a(new BlockPos(x, starty + 8, z), Blocks.field_150426_aN.func_176223_P(), 3);
                } else if (smallAntenna) {
                    world.func_180501_a(new BlockPos(x, starty + 4, z), Blocks.field_150334_T.func_176223_P(), 2);
                    world.func_180501_a(new BlockPos(x, starty + 5, z), Blocks.field_150411_aY.func_176223_P(), 2);
                    world.func_175698_g(new BlockPos(x, starty + 6, z));
                    world.func_175698_g(new BlockPos(x, starty + 7, z));
                    world.func_175698_g(new BlockPos(x, starty + 8, z));
                } else {
                    world.func_180501_a(new BlockPos(x, starty + 4, z), Blocks.field_150333_U.func_176223_P(), 2);
                    world.func_175698_g(new BlockPos(x, starty + 5, z));
                    world.func_175698_g(new BlockPos(x, starty + 6, z));
                    world.func_175698_g(new BlockPos(x, starty + 7, z));
                    world.func_175698_g(new BlockPos(x, starty + 8, z));
                }
                WorldGenerationTools.fillEmptyWithStone(world, x, starty - 1, z);
            }
        }
        if (doExtraFeature) {
            if (!WorldGenerationTools.isSolid(world, midx + 4, starty, midz - 3)) {
                world.func_180501_a(new BlockPos(midx + 4, starty, midz - 3), Blocks.field_150411_aY.func_176223_P(), 2);
            }
            world.func_180501_a(new BlockPos(midx + 4, starty + 1, midz - 3), Blocks.field_150411_aY.func_176223_P(), 2);
            world.func_180501_a(new BlockPos(midx + 4, starty + 2, midz - 3), Blocks.field_150411_aY.func_176223_P(), 2);
            if (!WorldGenerationTools.isSolid(world, midx + 5, starty, midz - 3)) {
                world.func_180501_a(new BlockPos(midx + 5, starty, midz - 3), buildingBlock.func_176203_a(color), 2);
            }
            world.func_180501_a(new BlockPos(midx + 5, starty + 1, midz - 3), buildingBlock.func_176203_a(color), 2);
            world.func_180501_a(new BlockPos(midx + 5, starty + 2, midz - 3), buildingBlock.func_176203_a(color), 2);
            WorldGenerationTools.fillEmptyWithStone(world, midx + 4, starty - 1, midz - 3);
            WorldGenerationTools.fillEmptyWithStone(world, midx + 5, starty - 1, midz - 3);
        }
        for (x = midx - 3; x <= midx + 3; ++x) {
            for (int y = starty + 1; y <= starty + 3; ++y) {
                world.func_175698_g(new BlockPos(x, y, midz - 4));
            }
        }
        world.func_180501_a(new BlockPos(midx - 1, starty, midz - 4), Blocks.field_150334_T.func_176223_P(), 2);
        world.func_180501_a(new BlockPos(midx, starty, midz - 4), Blocks.field_150334_T.func_176223_P(), 2);
        world.func_180501_a(new BlockPos(midx + 1, starty, midz - 4), Blocks.field_150334_T.func_176223_P(), 2);
        world.func_180501_a(new BlockPos(midx, starty + 1, midz - 3), Blocks.field_150454_av.func_176203_a(1), 2);
        world.func_180501_a(new BlockPos(midx, starty + 2, midz - 3), Blocks.field_150454_av.func_176203_a(8), 2);
        world.func_180501_a(new BlockPos(midx - 1, starty + 2, midz - 4), Blocks.field_150430_aB.func_176203_a(4), 2);
        world.func_180501_a(new BlockPos(midx + 1, starty + 2, midz - 2), Blocks.field_150430_aB.func_176203_a(3), 2);
        world.func_180501_a(new BlockPos(midx, starty + 3, midz + 3), Blocks.field_150379_bu.func_176223_P(), 2);
        world.func_180501_a(new BlockPos(midx, starty + 3, midz + 2), Blocks.field_150442_at.func_176203_a(4), 2);
        world.func_180501_a(new BlockPos(midx + 2, starty + 1, midz - 2), Blocks.field_150486_ae.func_176223_P(), 2);
        WeightedRandomSelector.Distribution bestDistribution = DimletRandomizer.getRandomDimlets().createDistribution(0.2f);
        TileEntityChest chest = (TileEntityChest)world.func_175625_s(new BlockPos(midx + 2, starty + 1, midz - 2));
        for (i = 0; i < random.nextInt(4) + 3; ++i) {
            ItemStack stack = DimletRandomizer.getRandomPart(random);
            chest.func_70299_a(random.nextInt(chest.func_70302_i_()), stack);
        }
        if (WorldgenConfiguration.enableDimletsInRFToolsDungeons > 0) {
            for (i = 0; i < random.nextInt(WorldgenConfiguration.enableDimletsInRFToolsDungeons); ++i) {
                DimletKey key = (DimletKey)DimletRandomizer.getRandomDimlets().select(bestDistribution, random);
                ItemStack stack = KnownDimletConfiguration.getDimletStack(key);
                chest.func_70299_a(random.nextInt(chest.func_70302_i_()), stack);
            }
        }
        for (i = 0; i < random.nextInt(2); ++i) {
            chest.func_70299_a(random.nextInt(chest.func_70302_i_()), new ItemStack((Item)ModItems.dimletParcelItem));
        }
        EntityItemFrame frame1 = this.spawnItemFrame(world, midx - 1, starty + 2, midz + 2);
        EntityItemFrame frame2 = this.spawnItemFrame(world, midx, starty + 2, midz + 2);
        EntityItemFrame frame3 = this.spawnItemFrame(world, midx + 1, starty + 2, midz + 2);
        if (WorldgenConfiguration.enableDimletsInRFToolsFrames) {
            DimletKey rd1 = (DimletKey)DimletRandomizer.getRandomDimlets().select(bestDistribution, random);
            frame1.func_82334_a(KnownDimletConfiguration.getDimletStack(rd1));
            DimletKey rd2 = (DimletKey)DimletRandomizer.getRandomDimlets().select(bestDistribution, random);
            frame2.func_82334_a(KnownDimletConfiguration.getDimletStack(rd2));
            DimletKey rd3 = (DimletKey)DimletRandomizer.getRandomDimlets().select(bestDistribution, random);
            frame3.func_82334_a(KnownDimletConfiguration.getDimletStack(rd3));
        } else {
            frame1.func_82334_a(DimletRandomizer.getRandomPart(random));
            frame2.func_82334_a(DimletRandomizer.getRandomPart(random));
            frame3.func_82334_a(DimletRandomizer.getRandomPart(random));
        }
    }

    private EntityItemFrame spawnItemFrame(World world, int x, int y, int z) {
        EntityItemFrame frame = new EntityItemFrame(world, new BlockPos(x, y, z + 1), EnumFacing.NORTH);
        world.func_72838_d((Entity)frame);
        frame.func_70107_b((double)x, (double)y, (double)z);
        return frame;
    }

    public void addOreSpawn(IBlockState block, IBlockState targetBlock, World world, Random random, int blockXPos, int blockZPos, int minVeinSize, int maxVeinSize, int chancesToSpawn, int minY, int maxY) {
        WorldGenMinable minable = new WorldGenMinable(block, minVeinSize - random.nextInt(maxVeinSize - minVeinSize), p -> p == targetBlock);
        for (int i = 0; i < chancesToSpawn; ++i) {
            int posX = blockXPos + random.nextInt(16);
            int posY = minY + random.nextInt(maxY - minY);
            int posZ = blockZPos + random.nextInt(16);
            minable.func_180709_b(world, random, new BlockPos(posX, posY, posZ));
        }
    }
}

