/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.dimensions.world.terrain;

import java.util.Random;
import mcjty.lib.varia.Logging;
import mcjty.rftoolsdim.dimensions.types.FeatureType;
import mcjty.rftoolsdim.dimensions.types.TerrainType;
import mcjty.rftoolsdim.dimensions.world.GenericChunkGenerator;
import mcjty.rftoolsdim.dimensions.world.terrain.BaseTerrainGenerator;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraft.world.gen.ChunkProviderSettings;
import net.minecraft.world.gen.NoiseGeneratorOctaves;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.ChunkGeneratorEvent;
import net.minecraftforge.event.terraingen.InitNoiseGensEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.minecraftforge.fml.common.eventhandler.Event;

public class NormalTerrainGenerator
implements BaseTerrainGenerator {
    private World world;
    protected GenericChunkGenerator provider;
    private final double[] heightMap;
    private double[] mainNoiseRegion;
    private double[] minLimitRegion;
    private double[] maxLimitRegion;
    private double[] depthRegion;
    private NoiseGeneratorOctaves minLimitPerlinNoise;
    private NoiseGeneratorOctaves maxLimitPerlinNoise;
    private NoiseGeneratorOctaves mainPerlinNoise;
    private NoiseGeneratorPerlin surfaceNoise;
    private NoiseGeneratorOctaves depthNoise;
    private final float[] biomeWeights;
    private double[] depthBuffer = new double[256];

    public NormalTerrainGenerator() {
        this.heightMap = new double[825];
        this.biomeWeights = new float[25];
        for (int j = -2; j <= 2; ++j) {
            for (int k = -2; k <= 2; ++k) {
                float f;
                this.biomeWeights[j + 2 + (k + 2) * 5] = f = 10.0f / MathHelper.func_76129_c((float)((float)(j * j + k * k) + 0.2f));
            }
        }
    }

    @Override
    public void setup(World world, GenericChunkGenerator provider) {
        this.world = world;
        this.provider = provider;
        this.minLimitPerlinNoise = new NoiseGeneratorOctaves(provider.rand, 16);
        this.maxLimitPerlinNoise = new NoiseGeneratorOctaves(provider.rand, 16);
        this.mainPerlinNoise = new NoiseGeneratorOctaves(provider.rand, 8);
        this.surfaceNoise = new NoiseGeneratorPerlin(provider.rand, 4);
        NoiseGeneratorOctaves noiseGen5 = new NoiseGeneratorOctaves(provider.rand, 10);
        this.depthNoise = new NoiseGeneratorOctaves(provider.rand, 16);
        NoiseGeneratorOctaves mobSpawnerNoise = new NoiseGeneratorOctaves(provider.rand, 8);
        InitNoiseGensEvent.ContextOverworld ctx = new InitNoiseGensEvent.ContextOverworld(this.minLimitPerlinNoise, this.maxLimitPerlinNoise, this.mainPerlinNoise, this.surfaceNoise, noiseGen5, this.depthNoise, mobSpawnerNoise);
        ctx = (InitNoiseGensEvent.ContextOverworld)TerrainGen.getModdedNoiseGenerators((World)world, (Random)provider.rand, (InitNoiseGensEvent.Context)ctx);
        this.minLimitPerlinNoise = ctx.getLPerlin1();
        this.maxLimitPerlinNoise = ctx.getLPerlin2();
        this.mainPerlinNoise = ctx.getPerlin();
        this.surfaceNoise = ctx.getHeight();
        this.depthNoise = ctx.getDepth();
    }

    private void generateHeightmap(int chunkX4, int chunkY4, int chunkZ4) {
        boolean donearlands;
        ChunkProviderSettings settings = this.provider.getSettings();
        this.depthRegion = this.depthNoise.func_76305_a(this.depthRegion, chunkX4, chunkZ4, 5, 5, (double)settings.field_177808_e, (double)settings.field_177803_f, (double)settings.field_177804_g);
        float f = settings.field_177811_a;
        float f1 = settings.field_177809_b;
        this.mainNoiseRegion = this.mainPerlinNoise.func_76304_a(this.mainNoiseRegion, chunkX4, chunkY4, chunkZ4, 5, 33, 5, (double)(f / settings.field_177825_h), (double)(f1 / settings.field_177827_i), (double)(f / settings.field_177821_j));
        this.minLimitRegion = this.minLimitPerlinNoise.func_76304_a(this.minLimitRegion, chunkX4, chunkY4, chunkZ4, 5, 33, 5, (double)f, (double)f1, (double)f);
        this.maxLimitRegion = this.maxLimitPerlinNoise.func_76304_a(this.maxLimitRegion, chunkX4, chunkY4, chunkZ4, 5, 33, 5, (double)f, (double)f1, (double)f);
        int i = 0;
        int j = 0;
        boolean domaze = false;
        boolean elevated = false;
        boolean bl = donearlands = this.provider.dimensionInformation.getTerrainType() == TerrainType.TERRAIN_NEARLANDS;
        if (donearlands) {
            elevated = true;
        }
        if (this.provider.dimensionInformation.hasFeatureType(FeatureType.FEATURE_MAZE)) {
            domaze = true;
            long s2 = ((long)(chunkX4 >> 2) + this.provider.seed + 13L) * 314L + (long)(chunkZ4 >> 2) * 17L;
            Random rand = new Random(s2);
            rand.nextFloat();
            boolean bl2 = elevated = (chunkX4 >> 2 & 1) == 0;
            if (rand.nextFloat() < 0.2f) {
                boolean bl3 = elevated = !elevated;
            }
        }
        if (donearlands) {
            int cx = chunkX4 >> 2;
            int cz = chunkZ4 >> 2;
            if (Math.abs(cx) < 5 && Math.abs(cz) < 5) {
                elevated = false;
            }
        }
        if (this.provider.biomesForGeneration == null) {
            Logging.log((String)("Dimension " + this.world.field_73011_w.getDimension() + " has a problem! Ignoring for now."));
            return;
        }
        for (int k = 0; k < 5; ++k) {
            for (int l = 0; l < 5; ++l) {
                float f2 = 0.0f;
                float f3 = 0.0f;
                float f4 = 0.0f;
                Biome Biome2 = this.provider.biomesForGeneration[k + 2 + (l + 2) * 10];
                for (int j1 = -2; j1 <= 2; ++j1) {
                    for (int k1 = -2; k1 <= 2; ++k1) {
                        Biome Biome1 = this.provider.biomesForGeneration[k + j1 + 2 + (l + k1 + 2) * 10];
                        float f5 = this.provider.getSettings().field_177813_n + Biome1.func_185355_j() * this.provider.getSettings().field_177819_m;
                        float f6 = this.provider.getSettings().field_177843_p + Biome1.func_185360_m() * this.provider.getSettings().field_177815_o;
                        if (domaze || donearlands) {
                            if (f5 > 0.0f && elevated) {
                                if (this.provider.worldType == WorldType.field_151360_e) {
                                    f5 = 2.0f + f5 * 1.5f;
                                    f6 = 1.0f + f6 * 3.0f;
                                } else {
                                    f5 = 2.0f + f5;
                                    f6 = 0.5f + f6 * 1.5f;
                                }
                            } else if (this.provider.worldType == WorldType.field_151360_e && f5 > 0.0f) {
                                f5 = 0.5f + f5 * 1.5f;
                                f6 = 0.5f + f6 * 2.0f;
                            } else {
                                f6 *= 0.5f;
                            }
                        } else if (this.provider.worldType == WorldType.field_151360_e && f5 > 0.0f) {
                            f5 = 1.0f + f5 * 2.0f;
                            f6 = 1.0f + f6 * 4.0f;
                        }
                        float f7 = this.biomeWeights[j1 + 2 + (k1 + 2) * 5] / (f5 + 2.0f);
                        if (Biome1.func_185355_j() > Biome2.func_185355_j()) {
                            f7 /= 2.0f;
                        }
                        f2 += f6 * f7;
                        f3 += f5 * f7;
                        f4 += f7;
                    }
                }
                f2 /= f4;
                f3 /= f4;
                f2 = f2 * 0.9f + 0.1f;
                f3 = (f3 * 4.0f - 1.0f) / 8.0f;
                double d12 = this.depthRegion[j] / 8000.0;
                if (d12 < 0.0) {
                    d12 = -d12 * 0.3;
                }
                if ((d12 = d12 * 3.0 - 2.0) < 0.0) {
                    if ((d12 /= 2.0) < -1.0) {
                        d12 = -1.0;
                    }
                    d12 /= 1.4;
                    d12 /= 2.0;
                } else {
                    if (d12 > 1.0) {
                        d12 = 1.0;
                    }
                    d12 /= 8.0;
                }
                ++j;
                double d13 = f3;
                double d14 = f2;
                d13 += d12 * 0.2;
                d13 = d13 * 8.5 / 8.0;
                double d5 = 8.5 + d13 * 4.0;
                for (int j2 = 0; j2 < 33; ++j2) {
                    double d6 = ((double)j2 - d5) * 12.0 * 128.0 / 256.0 / d14;
                    if (d6 < 0.0) {
                        d6 *= 4.0;
                    }
                    double d7 = this.minLimitRegion[i] / 512.0;
                    double d8 = this.maxLimitRegion[i] / 512.0;
                    double d9 = (this.mainNoiseRegion[i] / 10.0 + 1.0) / 2.0;
                    double d10 = MathHelper.func_151238_b((double)d7, (double)d8, (double)d9) - d6;
                    if (j2 > 29) {
                        double d11 = (float)(j2 - 29) / 3.0f;
                        d10 = d10 * (1.0 - d11) + -10.0 * d11;
                    }
                    this.heightMap[i] = d10;
                    ++i;
                }
            }
        }
    }

    @Override
    public void generate(int chunkX, int chunkZ, ChunkPrimer primer) {
        IBlockState baseBlock = this.provider.dimensionInformation.getBaseBlockForTerrain();
        Block baseLiquid = this.provider.dimensionInformation.getFluidForTerrain();
        this.generateHeightmap(chunkX * 4, 0, chunkZ * 4);
        int waterLevel = 63;
        for (int x4 = 0; x4 < 4; ++x4) {
            int l = x4 * 5;
            int i1 = (x4 + 1) * 5;
            for (int z4 = 0; z4 < 4; ++z4) {
                int k1 = (l + z4) * 33;
                int l1 = (l + z4 + 1) * 33;
                int i2 = (i1 + z4) * 33;
                int j2 = (i1 + z4 + 1) * 33;
                for (int height32 = 0; height32 < 32; ++height32) {
                    double d1 = this.heightMap[k1 + height32];
                    double d2 = this.heightMap[l1 + height32];
                    double d3 = this.heightMap[i2 + height32];
                    double d4 = this.heightMap[j2 + height32];
                    double d5 = (this.heightMap[k1 + height32 + 1] - d1) * 0.125;
                    double d6 = (this.heightMap[l1 + height32 + 1] - d2) * 0.125;
                    double d7 = (this.heightMap[i2 + height32 + 1] - d3) * 0.125;
                    double d8 = (this.heightMap[j2 + height32 + 1] - d4) * 0.125;
                    for (int h = 0; h < 8; ++h) {
                        double d10 = d1;
                        double d11 = d2;
                        double d12 = (d3 - d1) * 0.25;
                        double d13 = (d4 - d2) * 0.25;
                        int height = height32 * 8 + h;
                        for (int x = 0; x < 4; ++x) {
                            int index = x + x4 * 4 << 12 | 0 + z4 * 4 << 8 | height;
                            int maxheight = 256;
                            index -= maxheight;
                            double d16 = (d11 - d10) * 0.25;
                            double d15 = d10 - d16;
                            for (int z = 0; z < 4; ++z) {
                                double d;
                                index += maxheight;
                                d15 += d16;
                                if (d > 0.0) {
                                    BaseTerrainGenerator.setBlockState(primer, index, baseBlock);
                                    continue;
                                }
                                if (height >= waterLevel) continue;
                                BaseTerrainGenerator.setBlockState(primer, index, baseLiquid.func_176223_P());
                            }
                            d10 += d12;
                            d11 += d13;
                        }
                        d1 += d5;
                        d2 += d6;
                        d3 += d7;
                        d4 += d8;
                    }
                }
            }
        }
    }

    @Override
    public void replaceBlocksForBiome(int chunkX, int chunkZ, ChunkPrimer primer, Biome[] Biomes2) {
        ChunkGeneratorEvent.ReplaceBiomeBlocks event = new ChunkGeneratorEvent.ReplaceBiomeBlocks((IChunkGenerator)this.provider, chunkX, chunkZ, primer, this.world);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.getResult() == Event.Result.DENY) {
            return;
        }
        double d0 = 0.03125;
        this.depthBuffer = this.surfaceNoise.func_151599_a(this.depthBuffer, (double)(chunkX * 16), (double)(chunkZ * 16), 16, 16, d0 * 2.0, d0 * 2.0, 1.0);
        for (int k = 0; k < 16; ++k) {
            for (int l = 0; l < 16; ++l) {
                Biome Biome2 = Biomes2[l + k * 16];
                Biome2.func_180622_a(this.world, this.provider.rand, primer, chunkX * 16 + k, chunkZ * 16 + l, this.depthBuffer[l + k * 16]);
            }
        }
    }
}

