/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.items;

import cofh.api.energy.IEnergyContainerItem;
import java.util.List;
import mcjty.rftoolsdim.config.PowerConfiguration;
import mcjty.rftoolsdim.items.GenericRFToolsItem;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PhasedFieldGeneratorItem
extends GenericRFToolsItem
implements IEnergyContainerItem {
    private int capacity;
    private int maxReceive;
    private int maxExtract;

    public PhasedFieldGeneratorItem() {
        super("phased_field_generator");
        this.func_77625_d(1);
        this.capacity = PowerConfiguration.PHASEDFIELD_MAXENERGY;
        this.maxReceive = PowerConfiguration.PHASEDFIELD_RECEIVEPERTICK;
        this.maxExtract = PowerConfiguration.PHASEDFIELD_CONSUMEPERTICK * 10;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        for (int i = 0; i <= 8; ++i) {
            ResourceLocation registryName = this.getRegistryName();
            registryName = new ResourceLocation(registryName.func_110624_b(), registryName.func_110623_a() + i);
            ModelBakery.registerItemVariants((Item)this, (ResourceLocation[])new ResourceLocation[]{new ModelResourceLocation(registryName, "inventory")});
        }
        ModelLoader.setCustomMeshDefinition((Item)this, (ItemMeshDefinition)new ItemMeshDefinition(){

            public ModelResourceLocation func_178113_a(ItemStack stack) {
                int level;
                NBTTagCompound tagCompound = stack.func_77978_p();
                int energy = 0;
                if (tagCompound != null) {
                    energy = tagCompound.func_74762_e("Energy");
                }
                if ((level = 9 * energy / PowerConfiguration.PHASEDFIELD_MAXENERGY) < 0) {
                    level = 0;
                } else if (level > 8) {
                    level = 8;
                }
                ResourceLocation registryName = PhasedFieldGeneratorItem.this.getRegistryName();
                registryName = new ResourceLocation(registryName.func_110624_b(), registryName.func_110623_a() + (8 - level));
                return new ModelResourceLocation(registryName, "inventory");
            }
        });
    }

    public int func_77626_a(ItemStack stack) {
        return 1;
    }

    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List list, boolean whatIsThis) {
        super.func_77624_a(itemStack, player, list, whatIsThis);
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound != null) {
            list.add(TextFormatting.BLUE + "Energy: " + tagCompound.func_74762_e("Energy") + " RF");
        }
        list.add("This RF/charged module gives a temporary");
        list.add("protection while visiting an unpowered dimension.");
        list.add("Use at your own risk and don't let power run out!");
    }

    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        if (container.func_77978_p() == null) {
            container.func_77982_d(new NBTTagCompound());
        }
        int energy = container.func_77978_p().func_74762_e("Energy");
        int energyReceived = Math.min(this.capacity - energy, Math.min(this.maxReceive, maxReceive));
        if (!simulate) {
            container.func_77978_p().func_74768_a("Energy", energy += energyReceived);
        }
        return energyReceived;
    }

    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        if (container.func_77978_p() == null || !container.func_77978_p().func_74764_b("Energy")) {
            return 0;
        }
        int energy = container.func_77978_p().func_74762_e("Energy");
        int energyExtracted = Math.min(energy, Math.min(this.maxExtract, maxExtract));
        if (!simulate) {
            container.func_77978_p().func_74768_a("Energy", energy -= energyExtracted);
        }
        return energyExtracted;
    }

    public int getEnergyStored(ItemStack container) {
        if (container.func_77978_p() == null || !container.func_77978_p().func_74764_b("Energy")) {
            return 0;
        }
        return container.func_77978_p().func_74762_e("Energy");
    }

    public int getMaxEnergyStored(ItemStack container) {
        return this.capacity;
    }
}

