/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.varia;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import org.apache.commons.lang3.StringUtils;

public class RFToolsTools {
    public static Map<String, String> modSourceID = null;

    public static boolean chunkLoaded(World world, BlockPos pos) {
        return world.func_72863_F().func_186026_b(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4) != null && world.func_175726_f(pos).func_177410_o();
    }

    public static StringBuffer appendIndent(StringBuffer buffer, int indent) {
        return buffer.append(StringUtils.repeat((char)' ', (int)indent));
    }

    public static void convertNBTtoJson(StringBuffer buffer, NBTTagList tagList, int indent) {
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound compound = tagList.func_150305_b(i);
            RFToolsTools.appendIndent(buffer, indent).append("{\n");
            RFToolsTools.convertNBTtoJson(buffer, compound, indent + 4);
            RFToolsTools.appendIndent(buffer, indent).append("},\n");
        }
    }

    public static void convertNBTtoJson(StringBuffer buffer, NBTTagCompound tagCompound, int indent) {
        boolean first = true;
        for (Object o : tagCompound.func_150296_c()) {
            if (!first) {
                buffer.append(",\n");
            }
            first = false;
            String key = (String)o;
            NBTBase tag = tagCompound.func_74781_a(key);
            RFToolsTools.appendIndent(buffer, indent).append(key).append(':');
            if (tag instanceof NBTTagCompound) {
                NBTTagCompound compound = (NBTTagCompound)tag;
                buffer.append("{\n");
                RFToolsTools.convertNBTtoJson(buffer, compound, indent + 4);
                RFToolsTools.appendIndent(buffer, indent).append('}');
                continue;
            }
            if (tag instanceof NBTTagList) {
                NBTTagList list = (NBTTagList)tag;
                buffer.append("[\n");
                RFToolsTools.convertNBTtoJson(buffer, list, indent + 4);
                RFToolsTools.appendIndent(buffer, indent).append(']');
                continue;
            }
            buffer.append(tag);
        }
        if (!first) {
            buffer.append("\n");
        }
    }

    public static String findModID(Object obj) {
        String path;
        if (modSourceID == null) {
            modSourceID = new HashMap<String, String>();
            for (ModContainer mod : Loader.instance().getModList()) {
                modSourceID.put(mod.getSource().getName(), mod.getModId());
            }
            modSourceID.put("1.8.0.jar", "minecraft");
            modSourceID.put("1.8.8.jar", "minecraft");
            modSourceID.put("1.8.9.jar", "minecraft");
            modSourceID.put("Forge", "minecraft");
        }
        try {
            path = obj instanceof Class ? ((Class)obj).getProtectionDomain().getCodeSource().getLocation().toString() : obj.getClass().getProtectionDomain().getCodeSource().getLocation().toString();
        }
        catch (Exception e) {
            return "<Unknown>";
        }
        try {
            path = URLDecoder.decode(path, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return "<Unknown>";
        }
        String modName = "<Unknown>";
        for (String s : modSourceID.keySet()) {
            if (!path.contains(s)) continue;
            modName = modSourceID.get(s);
            break;
        }
        if (modName.equals("Minecraft Coder Pack")) {
            modName = "minecraft";
        } else if (modName.equals("Forge")) {
            modName = "minecraft";
        }
        return modName;
    }
}

