/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.reap;

import de.maxhenkel.reap.Harvester;
import de.maxhenkel.reap.Main;
import de.maxhenkel.reap.TreeHarvester;
import de.maxhenkel.reap.UpdateChecker;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class Events {
    private static final String[] WHITELIST_DEFAULT = new String[]{"minecraft:potatoes", "minecraft:carrots", "minecraft:wheat", "minecraft:beetroots", "minecraft:cocoa"};
    private static final String[] TREE_TOOLS = new String[]{"minecraft:diamond_axe", "minecraft:iron_axe", "minecraft:stone_axe", "minecraft:wooden_axe", "minecraft:golden_axe"};
    private static final String[] LOG_TYPES = new String[]{"minecraft:log", "minecraft:log2"};
    private static final String[] GROUND_TYPES = new String[]{"minecraft:dirt", "minecraft:grass"};
    private Configuration config = Main.getInstance().getConfig();
    private Block[] whitelist = new Block[0];
    private Block[] logTypes;
    private Block[] groundTypes;
    private Item[] allowedTreeTools = new Item[0];
    private boolean checkUpdates = false;
    private boolean enableTreeHarvest = false;
    private boolean updateShown = false;

    public Events() {
        this.logTypes = new Block[0];
        this.groundTypes = new Block[0];
        try {
            this.config.load();
            boolean check = this.config.get("reap", "update_check", true).getBoolean();
            boolean harvest = this.config.get("reap", "enable_tree_harvest", true).getBoolean();
            String[] whitelist = this.config.get("reap", "whitelist", WHITELIST_DEFAULT).getStringList();
            String[] treeTools = this.config.get("reap", "allowed_tree_tools", TREE_TOOLS).getStringList();
            String[] logs = this.config.get("reap", "log_types", LOG_TYPES).getStringList();
            String[] groundTypes = this.config.get("reap", "tree_ground_blocks", GROUND_TYPES).getStringList();
            this.checkUpdates = check;
            this.enableTreeHarvest = harvest;
            this.whitelist = Events.getBlocks(whitelist);
            this.allowedTreeTools = Events.getItems(treeTools);
            this.logTypes = Events.getBlocks(logs);
            this.groundTypes = Events.getBlocks(groundTypes);
            this.config.save();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public void playerJoin(EntityJoinWorldEvent event) {
        if (event.isCanceled()) {
            return;
        }
        if (!(event.getEntity() instanceof EntityPlayer)) {
            return;
        }
        final EntityPlayer player = (EntityPlayer)event.getEntity();
        if (!player.field_70170_p.field_72995_K) {
            return;
        }
        if (player.field_70128_L) {
            return;
        }
        if (!this.checkUpdates) {
            return;
        }
        if (this.updateShown) {
            return;
        }
        UpdateChecker checker = new UpdateChecker(new UpdateChecker.IUpdateCheckResult(){

            @Override
            public void onResult(boolean isAvailable) {
                if (isAvailable) {
                    String msg = "[" + new TextComponentTranslation("message.modname", new Object[0]).func_150254_d() + "] " + new TextComponentTranslation("message.update", new Object[0]).func_150254_d() + " ";
                    ClickEvent openUrl = new ClickEvent(ClickEvent.Action.OPEN_URL, "http://minecraft.curseforge.com/projects/reap-mod");
                    Style style = new Style();
                    style.func_150241_a(openUrl);
                    style.func_150228_d(Boolean.valueOf(true));
                    style.func_150238_a(TextFormatting.GREEN);
                    style.func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString(new TextComponentTranslation("message.update.hover", new Object[0]).func_150254_d())));
                    TextComponentString comp = new TextComponentString("[Download]");
                    comp.func_150255_a(style);
                    player.func_145747_a(new TextComponentString(msg).func_150257_a((ITextComponent)comp));
                    Events.this.updateShown = true;
                }
            }
        }, 9, "http://maxhenkel.de/update/reap_1.10.2.txt");
        checker.start();
    }

    @SubscribeEvent
    public void onPlayerUse(PlayerInteractEvent.RightClickBlock event) {
        if (event.isCanceled()) {
            return;
        }
        EntityPlayer player = event.getEntityPlayer();
        if (player == null) {
            return;
        }
        BlockPos clickedBlock = event.getPos();
        boolean success = Harvester.harvest(clickedBlock, player, this.whitelist);
        if (success && event.isCancelable()) {
            event.setResult(Event.Result.DENY);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        World world = event.getWorld();
        EntityPlayer player = event.getPlayer();
        if (event.getWorld().field_72995_K || player == null || event.isCanceled() || player.field_71075_bZ.field_75098_d) {
            return;
        }
        BlockPos pos = event.getPos();
        TreeHarvester harvester = new TreeHarvester(pos, player, world, this.allowedTreeTools, this.logTypes, this.groundTypes);
        harvester.harvest();
    }

    public static Block[] getBlocks(String[] names) {
        ArrayList<Block> blocks = new ArrayList<Block>();
        for (String s : names) {
            Block b = Events.getBlock(s);
            if (b == null) continue;
            blocks.add(b);
        }
        return blocks.toArray(new Block[0]);
    }

    public static Item[] getItems(String[] names) {
        ArrayList<Item> items = new ArrayList<Item>();
        for (String s : names) {
            Item b = Events.getItem(s);
            if (b == null) continue;
            items.add(b);
        }
        return items.toArray(new Item[0]);
    }

    public static Block getBlock(String name) {
        try {
            String[] split = name.split(":");
            if (split.length == 2) {
                Block b = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(split[0], split[1]));
                if (b.equals(Blocks.field_150350_a)) {
                    return null;
                }
                return b;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Item getItem(String name) {
        try {
            String[] split = name.split(":");
            if (split.length == 2) {
                return (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(split[0], split[1]));
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }
}

