/*
 * Decompiled with CFR 0.152.
 */
package codechicken.enderstorage.client.render.tile;

import codechicken.core.fluid.FluidUtils;
import codechicken.enderstorage.api.Frequency;
import codechicken.enderstorage.client.model.ButtonModelLibrary;
import codechicken.enderstorage.client.render.RenderCustomEndPortal;
import codechicken.enderstorage.tile.TileEnderTank;
import codechicken.lib.math.MathHelper;
import codechicken.lib.render.CCModel;
import codechicken.lib.render.CCModelLibrary;
import codechicken.lib.render.CCOBJParser;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.RenderUtils;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.texture.TextureUtils;
import codechicken.lib.util.ClientUtils;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.SwapYZ;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Translation;
import codechicken.lib.vec.Vector3;
import codechicken.lib.vec.uv.UVTranslation;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidStack;

public class RenderTileEnderTank
extends TileEntitySpecialRenderer<TileEnderTank> {
    public static CCModel tankModel;
    public static CCModel valveModel;
    public static CCModel[] buttons;
    public static RenderCustomEndPortal renderEndPortal;
    private static boolean initialized;

    public static void loadModel() {
        if (initialized) {
            return;
        }
        initialized = true;
        Map models = CCOBJParser.parseObjModels((ResourceLocation)new ResourceLocation("enderstorage", "models/endertank.obj"), (Transformation)new SwapYZ());
        ArrayList tankParts = new ArrayList();
        tankParts.add(models.get("Blazerod1"));
        tankParts.add(models.get("Blazerod2"));
        tankParts.add(models.get("Blazerod3"));
        tankParts.add(models.get("Blazerod4"));
        tankParts.add(models.get("Top"));
        tankParts.add(models.get("Top2"));
        tankParts.add(models.get("Base"));
        tankParts.add(models.get("Glass"));
        tankParts.add(models.get("Valvebase"));
        Translation fix = new Translation(-0.5099, 0.0, -0.5027);
        tankModel = CCModel.combine(tankParts).apply((Transformation)fix).computeNormals();
        valveModel = ((CCModel)models.get("Valve")).apply((Transformation)fix).computeNormals();
        buttons = new CCModel[3];
        for (int i = 0; i < 3; ++i) {
            RenderTileEnderTank.buttons[i] = ButtonModelLibrary.button.copy().apply((Transformation)TileEnderTank.buttonT[i].with((Transformation)new Translation(-0.5, 0.0, -0.5)));
        }
    }

    public void renderTileEntityAt(TileEnderTank enderTank, double x, double y, double z, float partialTicks, int breakProgress) {
        CCRenderState ccrs = CCRenderState.instance();
        ccrs.reset();
        RenderTileEnderTank.renderTank(ccrs, enderTank.rotation, (float)MathHelper.interpolate((double)enderTank.pressure_state.b_rotate, (double)enderTank.pressure_state.a_rotate, (double)partialTicks) * 0.01745f, enderTank.frequency, x, y, z, RenderUtils.getTimeOffset((BlockPos)enderTank.func_174877_v()));
        RenderTileEnderTank.renderLiquid(enderTank.liquid_state.c_liquid, x, y, z);
    }

    public static void renderTank(CCRenderState ccrs, int rotation, float valve, Frequency freq, double x, double y, double z, int offset) {
        TileEntityRendererDispatcher info = TileEntityRendererDispatcher.field_147556_a;
        renderEndPortal.render(x, y, z, 0.0f, info.field_147560_j, info.field_147561_k, info.field_147558_l, info.field_147553_e);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(x + 0.5), (double)y, (double)(z + 0.5));
        GlStateManager.func_179114_b((float)(-90 * (rotation + 2)), (float)0.0f, (float)1.0f, (float)0.0f);
        TextureUtils.changeTexture((String)"enderstorage:textures/endertank.png");
        ccrs.startDrawing(4, DefaultVertexFormats.field_181712_l);
        tankModel.render(ccrs, new IVertexOperation[0]);
        valveModel.render(ccrs, new IVertexOperation[]{new Rotation((double)valve, new Vector3(0.0, 0.0, 1.0)).at(new Vector3(0.0, 0.4165, 0.0)), new UVTranslation(0.0, freq.hasOwner() ? 0.203125 : 0.0)});
        ccrs.draw();
        TextureUtils.changeTexture((String)"enderstorage:textures/buttons.png");
        ccrs.startDrawing(7, DefaultVertexFormats.field_181712_l);
        int[] colours = freq.toArray();
        for (int i = 0; i < 3; ++i) {
            buttons[i].render(ccrs, new IVertexOperation[]{new UVTranslation(0.25 * (double)(colours[i] % 4), 0.25 * (double)(colours[i] / 4))});
        }
        ccrs.draw();
        GlStateManager.func_179121_F();
        double time = ClientUtils.getRenderTime() + (double)offset;
        Matrix4 pearlMat = RenderUtils.getMatrix((Vector3)new Vector3(x + 0.5, y + 0.45 + (double)(RenderUtils.getPearlBob((double)time) * 2.0f), z + 0.5), (Rotation)new Rotation(time / 3.0, new Vector3(0.0, 1.0, 0.0)), (double)0.04);
        GlStateManager.func_179140_f();
        TextureUtils.changeTexture((String)"enderstorage:textures/hedronmap.png");
        ccrs.startDrawing(4, DefaultVertexFormats.field_181712_l);
        CCModelLibrary.icosahedron4.render(ccrs, new IVertexOperation[]{pearlMat});
        ccrs.draw();
        GlStateManager.func_179145_e();
    }

    public static void renderLiquid(FluidStack liquid, double x, double y, double z) {
        RenderUtils.renderFluidCuboidGL((FluidStack)liquid, (Cuboid6)new Cuboid6(0.22, 0.12, 0.22, 0.78, 0.751, 0.78).add(new Vector3(x, y, z)), (double)((double)liquid.amount / (16.0 * (double)FluidUtils.B)), (double)0.75);
    }

    static {
        renderEndPortal = new RenderCustomEndPortal(0.1205, 0.24, 0.76, 0.24, 0.76);
        initialized = false;
    }
}

