/*
 * Decompiled with CFR 0.152.
 */
package codechicken.enderstorage.item;

import codechicken.enderstorage.api.Frequency;
import codechicken.enderstorage.manager.EnderStorageManager;
import codechicken.enderstorage.reference.VariantReference;
import codechicken.enderstorage.storage.EnderLiquidStorage;
import codechicken.enderstorage.tile.TileFrequencyOwner;
import codechicken.enderstorage.util.LogHelper;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class ItemEnderStorage
extends ItemBlock
implements IFluidContainerItem {
    public ItemEnderStorage(Block block) {
        super(block);
        this.func_77627_a(true);
    }

    public int func_77647_b(int stackMeta) {
        return stackMeta;
    }

    public Frequency getFreq(ItemStack stack) {
        return Frequency.fromItemStack(stack);
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, IBlockState newState) {
        if (super.placeBlockAt(stack, player, world, pos, side, hitX, hitY, hitZ, newState)) {
            TileFrequencyOwner tile = (TileFrequencyOwner)world.func_175625_s(pos);
            tile.setFreq(this.getFreq(stack));
            return true;
        }
        return false;
    }

    public String func_77667_c(ItemStack stack) {
        return "tile." + VariantReference.enderBlockNames[this.func_77647_b(stack.func_77952_i())];
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> list, boolean extended) {
        Frequency frequency = Frequency.fromItemStack(stack);
        if (frequency.owner != null) {
            list.add(frequency.owner);
        }
        list.add(String.format("%s/%s/%s", frequency.getLocalizedLeft(), frequency.getLocalizedMiddle(), frequency.getLocalizedRight()));
    }

    private EnderLiquidStorage getLiquidStorage(ItemStack stack) {
        return (EnderLiquidStorage)EnderStorageManager.instance(FMLCommonHandler.instance().getSide().isClient()).getStorage(this.getFreq(stack), "liquid");
    }

    public FluidStack getFluid(ItemStack container) {
        if (this.func_77647_b(container.func_77952_i()) == 1) {
            FluidStack fluid = this.getLiquidStorage(container).getFluid();
            LogHelper.info("Liquid{ Name: %s, Amount: %s }", fluid.getFluid().getName(), fluid.amount);
            return fluid;
        }
        return null;
    }

    public int getCapacity(ItemStack container) {
        if (this.func_77647_b(container.func_77952_i()) == 1) {
            return EnderLiquidStorage.CAPACITY;
        }
        return 0;
    }

    public int fill(ItemStack container, FluidStack resource, boolean doFill) {
        if (this.func_77647_b(container.func_77952_i()) == 1) {
            return this.getLiquidStorage(container).fill(null, resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(ItemStack container, int maxDrain, boolean doDrain) {
        if (this.func_77647_b(container.func_77952_i()) == 1) {
            return this.getLiquidStorage(container).drain(null, maxDrain, doDrain);
        }
        return null;
    }
}

