/*
 * Decompiled with CFR 0.152.
 */
package codechicken.enderstorage.storage;

import codechicken.core.fluid.ExtendedFluidTank;
import codechicken.core.fluid.FluidUtils;
import codechicken.enderstorage.api.AbstractEnderStorage;
import codechicken.enderstorage.api.Frequency;
import codechicken.enderstorage.manager.EnderStorageManager;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class EnderLiquidStorage
extends AbstractEnderStorage
implements IFluidHandler {
    public static final int CAPACITY = 16 * FluidUtils.B;
    private Tank tank = new Tank(CAPACITY);

    public EnderLiquidStorage(EnderStorageManager manager, Frequency freq) {
        super(manager, freq);
    }

    @Override
    public void loadFromTag(NBTTagCompound tag) {
        this.tank.fromTag(tag.func_74775_l("tank"));
    }

    @Override
    public String type() {
        return "liquid";
    }

    @Override
    public NBTTagCompound saveToTag() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74782_a("tank", (NBTBase)this.tank.toTag());
        return compound;
    }

    public FluidStack getFluid() {
        return this.tank.getFluid();
    }

    public int fill(EnumFacing from, FluidStack resource, boolean doFill) {
        return this.tank.fill(resource, doFill);
    }

    public FluidStack drain(EnumFacing from, FluidStack resource, boolean doDrain) {
        return this.tank.drain(resource, doDrain);
    }

    public FluidStack drain(EnumFacing from, int maxDrain, boolean doDrain) {
        return this.tank.drain(maxDrain, doDrain);
    }

    public boolean canFill(EnumFacing from, Fluid fluid) {
        return true;
    }

    public boolean canDrain(EnumFacing from, Fluid fluid) {
        return true;
    }

    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }

    private class Tank
    extends ExtendedFluidTank {
        public Tank(int capacity) {
            super(capacity);
        }

        public void onLiquidChanged() {
            EnderLiquidStorage.this.setDirty();
        }
    }
}

