/*
 * Decompiled with CFR 0.152.
 */
package codechicken.enderstorage.tile;

import codechicken.core.fluid.FluidUtils;
import codechicken.enderstorage.api.Frequency;
import codechicken.enderstorage.manager.EnderStorageManager;
import codechicken.enderstorage.network.TankSynchroniser;
import codechicken.enderstorage.storage.EnderLiquidStorage;
import codechicken.enderstorage.tile.TileFrequencyOwner;
import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.math.MathHelper;
import codechicken.lib.packet.PacketCustom;
import codechicken.lib.raytracer.IndexedCuboid6;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Scale;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Translation;
import codechicken.lib.vec.Vector3;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.wrappers.FluidHandlerWrapper;

public class TileEnderTank
extends TileFrequencyOwner
implements IFluidHandler {
    private static Cuboid6[] selectionBoxes = new Cuboid6[4];
    public static Transformation[] buttonT = new Transformation[3];
    public int rotation;
    public EnderTankState liquid_state = new EnderTankState();
    public PressureState pressure_state = new PressureState();
    private boolean described;

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        this.pressure_state.update(this.field_145850_b.field_72995_K);
        if (this.pressure_state.a_pressure) {
            this.ejectLiquid();
        }
        this.liquid_state.update(this.field_145850_b.field_72995_K);
    }

    private void ejectLiquid() {
        for (EnumFacing side : EnumFacing.values()) {
            int qty;
            TileEntity tile = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(side));
            if (!(tile instanceof IFluidHandler)) continue;
            IFluidHandler c = (IFluidHandler)tile;
            FluidStack liquid = this.drain(null, 100, false);
            if (liquid == null || (qty = c.fill(side.func_176734_d(), liquid, true)) <= 0) continue;
            this.drain(null, qty, true);
        }
    }

    @Override
    public void setFreq(Frequency frequency) {
        super.setFreq(frequency);
        if (!this.field_145850_b.field_72995_K) {
            this.liquid_state.setFrequency(frequency);
        }
    }

    @Override
    public EnderLiquidStorage getStorage() {
        return (EnderLiquidStorage)EnderStorageManager.instance(this.field_145850_b.field_72995_K).getStorage(this.frequency, "liquid");
    }

    public int fill(EnumFacing from, FluidStack resource, boolean doFill) {
        return this.getStorage().fill(from, resource, doFill);
    }

    public FluidStack drain(EnumFacing from, int maxDrain, boolean doDrain) {
        return this.getStorage().drain(from, maxDrain, doDrain);
    }

    public FluidStack drain(EnumFacing from, FluidStack resource, boolean doDrain) {
        return this.getStorage().drain(from, resource, doDrain);
    }

    public boolean canDrain(EnumFacing from, Fluid fluid) {
        return this.getStorage().canDrain(from, fluid);
    }

    public boolean canFill(EnumFacing from, Fluid fluid) {
        return this.getStorage().canFill(from, fluid);
    }

    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        if (this.field_145850_b.field_72995_K) {
            return new FluidTankInfo[]{new FluidTankInfo(this.liquid_state.s_liquid, EnderLiquidStorage.CAPACITY)};
        }
        return this.getStorage().getTankInfo(from);
    }

    @Override
    public void onPlaced(EntityLivingBase entity) {
        this.rotation = (int)Math.floor((double)(entity.field_70177_z * 4.0f / 360.0f) + 2.5) & 3;
        this.pressure_state.b_rotate = this.pressure_state.a_rotate = this.pressure_state.approachRotate();
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74774_a("rot", (byte)this.rotation);
        tag.func_74757_a("ir", this.pressure_state.invert_redstone);
        return tag;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.liquid_state.setFrequency(this.frequency);
        this.rotation = tag.func_74771_c("rot");
        this.pressure_state.invert_redstone = tag.func_74767_n("ir");
    }

    @Override
    public void writeToPacket(MCDataOutput packet) {
        super.writeToPacket(packet);
        packet.writeByte(this.rotation);
        packet.writeFluidStack(this.liquid_state.s_liquid);
        packet.writeBoolean(this.pressure_state.a_pressure);
    }

    @Override
    public void readFromPacket(MCDataInput packet) {
        super.readFromPacket(packet);
        this.liquid_state.setFrequency(this.frequency);
        this.rotation = packet.readUByte();
        this.liquid_state.s_liquid = packet.readFluidStack();
        this.pressure_state.a_pressure = packet.readBoolean();
        if (!this.described) {
            this.liquid_state.c_liquid = this.liquid_state.s_liquid;
            this.pressure_state.b_rotate = this.pressure_state.a_rotate = this.pressure_state.approachRotate();
        }
        this.described = true;
    }

    @Override
    public boolean activate(EntityPlayer player, int subHit) {
        if (subHit == 4) {
            this.pressure_state.invert();
            return true;
        }
        return FluidUtils.fillTankWithContainer((IFluidHandler)this, (EntityPlayer)player) || FluidUtils.emptyTankIntoContainer((IFluidHandler)this, (EntityPlayer)player, (FluidStack)this.getStorage().getFluid());
    }

    public List<IndexedCuboid6> getIndexedCuboids() {
        ArrayList<IndexedCuboid6> cuboids = new ArrayList<IndexedCuboid6>();
        cuboids.add(new IndexedCuboid6((Object)0, new Cuboid6(0.15, 0.0, 0.15, 0.85, 0.916, 0.85)));
        for (int i = 0; i < 4; ++i) {
            cuboids.add(new IndexedCuboid6((Object)(i + 1), selectionBoxes[i].copy().apply(Rotation.quarterRotations[this.rotation ^ 2].at(Vector3.center))));
        }
        return cuboids;
    }

    @Override
    public int getLightValue() {
        if (this.liquid_state.s_liquid.amount > 0) {
            return FluidUtils.getLuminosity((FluidStack)this.liquid_state.c_liquid, (double)((double)this.liquid_state.s_liquid.amount / 16.0));
        }
        return 0;
    }

    @Override
    public boolean redstoneInteraction() {
        return true;
    }

    public void sync(PacketCustom packet) {
        if (packet.getType() == 5) {
            this.liquid_state.sync(packet.readFluidStack());
        } else if (packet.getType() == 6) {
            this.pressure_state.a_pressure = packet.readBoolean();
        }
    }

    @Override
    public boolean rotate() {
        if (!this.field_145850_b.field_72995_K) {
            this.rotation = (this.rotation + 1) % 4;
            PacketCustom.sendToChunk((Packet)this.func_189518_D_(), (World)this.field_145850_b, (int)(this.field_174879_c.func_177958_n() >> 4), (int)(this.field_174879_c.func_177952_p() >> 4));
        }
        return true;
    }

    @Override
    public int comparatorInput() {
        FluidTankInfo tank = this.getStorage().getTankInfo(null)[0];
        return tank.fluid.amount * 14 / tank.capacity + (tank.fluid.amount > 0 ? 1 : 0);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)new FluidHandlerWrapper((IFluidHandler)this, facing);
        }
        return (T)super.getCapability(capability, facing);
    }

    static {
        for (int i = 0; i < 3; ++i) {
            TileEnderTank.buttonT[i] = new Scale(0.6).with((Transformation)new Translation(0.35 + (double)i * 0.15, 0.91, 0.5));
            TileEnderTank.selectionBoxes[i] = selection_button.copy().apply(buttonT[i]);
        }
        TileEnderTank.selectionBoxes[3] = new Cuboid6(0.358, 0.268, 0.05, 0.662, 0.565, 0.15);
    }

    public class PressureState {
        public boolean invert_redstone;
        public boolean a_pressure;
        public boolean b_pressure;
        public double a_rotate;
        public double b_rotate;

        public void update(boolean client) {
            if (client) {
                this.b_rotate = this.a_rotate;
                this.a_rotate = MathHelper.approachExp((double)this.a_rotate, (double)this.approachRotate(), (double)0.5, (double)20.0);
            } else {
                this.b_pressure = this.a_pressure;
                boolean bl = this.a_pressure = TileEnderTank.this.field_145850_b.func_175640_z(TileEnderTank.this.func_174877_v()) != this.invert_redstone;
                if (this.a_pressure != this.b_pressure) {
                    this.sendSyncPacket();
                }
            }
        }

        public double approachRotate() {
            return this.a_pressure ? -90.0 : 90.0;
        }

        private void sendSyncPacket() {
            PacketCustom packet = new PacketCustom((Object)"ES", 6);
            packet.writePos(TileEnderTank.this.func_174877_v());
            packet.writeBoolean(this.a_pressure);
            packet.sendToChunk(TileEnderTank.this.field_145850_b, TileEnderTank.this.field_174879_c.func_177958_n() >> 4, TileEnderTank.this.field_174879_c.func_177952_p() >> 4);
        }

        public void invert() {
            this.invert_redstone = !this.invert_redstone;
            TileEnderTank.this.field_145850_b.func_72964_e(TileEnderTank.this.field_174879_c.func_177958_n(), TileEnderTank.this.field_174879_c.func_177952_p()).func_76630_e();
        }
    }

    public class EnderTankState
    extends TankSynchroniser.TankState {
        @Override
        public void sendSyncPacket() {
            PacketCustom packet = new PacketCustom((Object)"ES", 5);
            packet.writePos(TileEnderTank.this.func_174877_v());
            packet.writeFluidStack(this.s_liquid);
            packet.sendToChunk(TileEnderTank.this.field_145850_b, TileEnderTank.this.field_174879_c.func_177958_n() >> 4, TileEnderTank.this.field_174879_c.func_177952_p() >> 4);
        }

        @Override
        public void onLiquidChanged() {
            TileEnderTank.this.field_145850_b.func_175664_x(TileEnderTank.this.field_174879_c);
        }
    }
}

