/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.addons.thermalexpansion;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import mcp.mobius.waila.addons.thermalexpansion.ThermalExpansionModule;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.SpecialChars;
import mcp.mobius.waila.cbcore.LangUtil;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameData;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;

public class HUDHandlerCache
implements IWailaDataProvider {
    @Override
    public ItemStack getWailaStack(IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return null;
    }

    @Override
    public List<String> getWailaHead(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        if (!config.getConfig("thermalexpansion.cache")) {
            return currenttip;
        }
        try {
            ItemStack storedItem = null;
            if (accessor.getNBTData().func_74764_b("Item")) {
                storedItem = this.readItemStack(accessor.getNBTData().func_74775_l("Item"));
            }
            String name = currenttip.get(0);
            String color = "";
            if (name.startsWith("\u00a7")) {
                color = name.substring(0, 2);
            }
            if (storedItem != null) {
                String namex = String.valueOf(GameData.getItemRegistry().getNameForObject((IForgeRegistryEntry)storedItem.func_77973_b()));
                name = name + String.format(" < " + SpecialChars.getRenderString("waila.stack", "1", namex, "0", String.valueOf(storedItem.func_77952_i())) + color + " %s >", storedItem.func_82833_r());
            } else {
                name = name + " " + LangUtil.translateG("hud.msg.empty", new Object[0]);
            }
            currenttip.set(0, name);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return currenttip;
    }

    @Override
    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        if (!config.getConfig("thermalexpansion.cache")) {
            return currenttip;
        }
        NBTTagCompound tag = accessor.getNBTData();
        ItemStack storedItem = null;
        if (tag.func_74764_b("Item")) {
            storedItem = this.readItemStack(tag.func_74775_l("Item"));
        }
        int stored = 0;
        int maxStored = 0;
        if (tag.func_74764_b("Stored")) {
            stored = tag.func_74762_e("Stored");
        }
        if (tag.func_74764_b("MaxStored")) {
            maxStored = tag.func_74762_e("MaxStored");
        }
        if (storedItem != null) {
            currenttip.add("Stored: " + stored + "/" + maxStored);
        } else {
            currenttip.add("Capacity: " + maxStored);
        }
        return currenttip;
    }

    @Override
    public List<String> getWailaTail(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return currenttip;
    }

    @Override
    public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, BlockPos pos) {
        if (te != null) {
            te.func_189515_b(tag);
        }
        try {
            tag.func_74768_a("MaxStored", ((Integer)ThermalExpansionModule.TileCache_getMaxStored.invoke((Object)te, new Object[0])).intValue());
            tag.func_74768_a("Stored", ((Integer)ThermalExpansionModule.TileCache_getStored.invoke((Object)te, new Object[0])).intValue());
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return tag;
    }

    public ItemStack readItemStack(NBTTagCompound tag) {
        ItemStack is = new ItemStack(Item.func_150899_d((int)tag.func_74765_d("id")));
        is.field_77994_a = tag.func_74762_e("Count");
        is.func_77964_b(Math.max(0, tag.func_74765_d("Damage")));
        if (tag.func_150297_b("tag", 10)) {
            // empty if block
        }
        return is;
    }
}

