/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.overlay;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaEntityProvider;
import mcp.mobius.waila.api.impl.ConfigHandler;
import mcp.mobius.waila.api.impl.DataAccessorCommon;
import mcp.mobius.waila.api.impl.ModuleRegistrar;
import mcp.mobius.waila.utils.Constants;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;

public class RayTracing {
    private static RayTracing _instance;
    private RayTraceResult target = null;
    private ItemStack targetStack = null;
    private Entity targetEntity = null;
    private Minecraft mc = Minecraft.func_71410_x();

    private RayTracing() {
    }

    public static RayTracing instance() {
        if (_instance == null) {
            _instance = new RayTracing();
        }
        return _instance;
    }

    public void fire() {
        if (this.mc.field_71476_x != null && this.mc.field_71476_x.field_72313_a == RayTraceResult.Type.ENTITY) {
            this.target = this.mc.field_71476_x;
            this.targetStack = null;
            return;
        }
        Entity viewpoint = this.mc.func_175606_aa();
        if (viewpoint == null) {
            return;
        }
        this.target = this.rayTrace(viewpoint, this.mc.field_71442_b.func_78757_d(), 0.0f);
        if (this.target == null) {
            return;
        }
    }

    public RayTraceResult getTarget() {
        return this.target;
    }

    public ItemStack getTargetStack() {
        this.targetStack = this.target.field_72313_a == RayTraceResult.Type.BLOCK ? this.getIdentifierStack() : null;
        return this.targetStack;
    }

    public Entity getTargetEntity() {
        this.targetEntity = this.target.field_72313_a == RayTraceResult.Type.ENTITY ? this.getIdentifierEntity() : null;
        return this.targetEntity;
    }

    public RayTraceResult rayTrace(Entity entity, double par1, float par3) {
        Vec3d vec3 = entity.func_174824_e(par3);
        Vec3d vec31 = entity.func_70676_i(par3);
        Vec3d vec32 = vec3.func_72441_c(vec31.field_72450_a * par1, vec31.field_72448_b * par1, vec31.field_72449_c * par1);
        if (ConfigHandler.instance().getConfig("general", Constants.CFG_WAILA_LIQUID, true)) {
            return entity.field_70170_p.func_72901_a(vec3, vec32, true);
        }
        return entity.field_70170_p.func_72901_a(vec3, vec32, false);
    }

    public ItemStack getIdentifierStack() {
        WorldClient world = this.mc.field_71441_e;
        ArrayList<ItemStack> items = this.getIdentifierItems();
        if (items.isEmpty()) {
            return null;
        }
        Collections.sort(items, new Comparator<ItemStack>(){

            @Override
            public int compare(ItemStack stack0, ItemStack stack1) {
                return stack1.func_77952_i() - stack0.func_77952_i();
            }
        });
        return items.get(0);
    }

    public Entity getIdentifierEntity() {
        ArrayList<Entity> ents = new ArrayList<Entity>();
        if (this.target == null) {
            return null;
        }
        if (ModuleRegistrar.instance().hasOverrideEntityProviders(this.target.field_72308_g)) {
            for (List<IWailaEntityProvider> listProviders : ModuleRegistrar.instance().getOverrideEntityProviders(this.target.field_72308_g).values()) {
                for (IWailaEntityProvider provider : listProviders) {
                    ents.add(provider.getWailaOverride(DataAccessorCommon.instance, ConfigHandler.instance()));
                }
            }
        }
        if (ents.size() > 0) {
            return (Entity)ents.get(0);
        }
        return this.target.field_72308_g;
    }

    public ArrayList<ItemStack> getIdentifierItems() {
        IShearable shearable;
        ItemStack providerStack;
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        if (this.target == null) {
            return items;
        }
        EntityPlayerSP player = this.mc.field_71439_g;
        WorldClient world = this.mc.field_71441_e;
        BlockPos pos = this.target.func_178782_a();
        Block mouseoverBlock = world.func_180495_p(pos).func_177230_c();
        TileEntity tileEntity = world.func_175625_s(pos);
        if (mouseoverBlock == null) {
            return items;
        }
        if (ModuleRegistrar.instance().hasStackProviders(mouseoverBlock)) {
            for (List<IWailaDataProvider> providersList : ModuleRegistrar.instance().getStackProviders(mouseoverBlock).values()) {
                for (IWailaDataProvider provider : providersList) {
                    providerStack = provider.getWailaStack(DataAccessorCommon.instance, ConfigHandler.instance());
                    if (providerStack == null) continue;
                    if (providerStack.func_77973_b() == null) {
                        return new ArrayList<ItemStack>();
                    }
                    items.add(providerStack);
                }
            }
        }
        if (tileEntity != null && ModuleRegistrar.instance().hasStackProviders(tileEntity)) {
            for (List<IWailaDataProvider> providersList : ModuleRegistrar.instance().getStackProviders(tileEntity).values()) {
                for (IWailaDataProvider provider : providersList) {
                    providerStack = provider.getWailaStack(DataAccessorCommon.instance, ConfigHandler.instance());
                    if (providerStack == null) continue;
                    if (providerStack.func_77973_b() == null) {
                        return new ArrayList<ItemStack>();
                    }
                    items.add(providerStack);
                }
            }
        }
        if (items.size() > 0) {
            return items;
        }
        if (world.func_175625_s(pos) == null) {
            try {
                ItemStack block = new ItemStack(mouseoverBlock, 1, mouseoverBlock.func_176201_c(world.func_180495_p(pos)));
                if (block.func_77973_b() != null) {
                    items.add(block);
                }
            }
            catch (Exception block) {
                // empty catch block
            }
        }
        if (items.size() > 0) {
            return items;
        }
        try {
            ItemStack pick = mouseoverBlock.getPickBlock(mouseoverBlock.func_176223_P(), this.target, (World)world, pos, (EntityPlayer)player);
            if (pick != null) {
                items.add(pick);
            }
        }
        catch (Exception pick) {
            // empty catch block
        }
        if (items.size() > 0) {
            return items;
        }
        if (mouseoverBlock instanceof IShearable && (shearable = (IShearable)mouseoverBlock).isShearable(new ItemStack((Item)Items.field_151097_aZ), (IBlockAccess)world, pos)) {
            items.addAll(shearable.onSheared(new ItemStack((Item)Items.field_151097_aZ), (IBlockAccess)world, pos, 0));
        }
        if (items.size() == 0) {
            items.add(0, new ItemStack(mouseoverBlock, 1, mouseoverBlock.func_176201_c(world.func_180495_p(pos))));
        }
        return items;
    }
}

