/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.utils;

import java.util.HashSet;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagShort;

public class NBTUtil {
    public static NBTBase getTag(String key, NBTTagCompound tag) {
        String[] path = key.split("\\.");
        NBTTagCompound deepTag = tag;
        for (String i : path) {
            if (deepTag.func_74764_b(i)) {
                if (!(deepTag.func_74781_a(i) instanceof NBTTagCompound)) {
                    return deepTag.func_74781_a(i);
                }
            } else {
                return null;
            }
            deepTag = deepTag.func_74775_l(i);
        }
        return deepTag;
    }

    public static NBTTagCompound setTag(String key, NBTTagCompound targetTag, NBTBase addedTag) {
        String[] path = key.split("\\.");
        NBTTagCompound deepTag = targetTag;
        for (int i = 0; i < path.length - 1; ++i) {
            if (!deepTag.func_74764_b(path[i])) {
                deepTag.func_74782_a(path[i], (NBTBase)new NBTTagCompound());
            }
            deepTag = deepTag.func_74775_l(path[i]);
        }
        deepTag.func_74782_a(path[path.length - 1], addedTag);
        return targetTag;
    }

    public static NBTTagCompound createTag(NBTTagCompound inTag, HashSet<String> keys) {
        if (keys.contains("*")) {
            return inTag;
        }
        NBTTagCompound outTag = new NBTTagCompound();
        for (String key : keys) {
            NBTBase tagToAdd = NBTUtil.getTag(key, inTag);
            if (tagToAdd == null) continue;
            outTag = NBTUtil.setTag(key, outTag, tagToAdd);
        }
        return outTag;
    }

    public static int getNBTInteger(NBTTagCompound tag, String keyname) {
        NBTBase subtag = tag.func_74781_a(keyname);
        if (subtag instanceof NBTTagInt) {
            return tag.func_74762_e(keyname);
        }
        if (subtag instanceof NBTTagShort) {
            return tag.func_74765_d(keyname);
        }
        if (subtag instanceof NBTTagByte) {
            return tag.func_74771_c(keyname);
        }
        return 0;
    }
}

